/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.helpers.Util;

public class SimpleLogger
extends MarkerIgnoringBase {
    private static final long serialVersionUID = -632788891211436180L;
    private static final String CONFIGURATION_FILE = "simplelogger.properties";
    private static long START_TIME = System.currentTimeMillis();
    private static final Properties SIMPLE_LOGGER_PROPS = new Properties();
    private static final int LOG_LEVEL_TRACE = 0;
    private static final int LOG_LEVEL_DEBUG = 10;
    private static final int LOG_LEVEL_INFO = 20;
    private static final int LOG_LEVEL_WARN = 30;
    private static final int LOG_LEVEL_ERROR = 40;
    private static boolean INITIALIZED = false;
    private static int DEFAULT_LOG_LEVEL = 20;
    private static boolean SHOW_DATE_TIME = false;
    private static String DATE_TIME_FORMAT_STR = null;
    private static DateFormat DATE_FORMATTER = null;
    private static boolean SHOW_THREAD_NAME = false;
    private static boolean SHOW_LOG_NAME = false;
    private static boolean SHOW_SHORT_LOG_NAME = false;
    private static String LOG_FILE = "System.out";
    private static PrintStream TARGET_STREAM = null;
    private static boolean SHOW_LEVEL = false;
    private static boolean LEVEL_IN_BRACKETS = false;
    private static String WARN_LEVEL_STRING = "WARN";
    public static final String SYSTEM_PREFIX = "org.slf4j.simpleLogger.";
    public static final String DEFAULT_LOG_LEVEL_KEY = "org.slf4j.simpleLogger.defaultLogLevel";
    public static final String SHOW_DATE_TIME_KEY = "org.slf4j.simpleLogger.showDateTime";
    public static final String DATE_TIME_FORMAT_KEY = "org.slf4j.simpleLogger.dateTimeFormat";
    public static final String SHOW_THREAD_NAME_KEY = "org.slf4j.simpleLogger.showThreadName";
    public static final String SHOW_LOG_NAME_KEY = "org.slf4j.simpleLogger.showLogName";
    public static final String SHOW_SHORT_LOG_NAME_KEY = "org.slf4j.simpleLogger.showShortLogName";
    public static final String LOG_FILE_KEY = "org.slf4j.simpleLogger.logFile";
    public static final String SHOW_LEVEL_KEY = "org.slf4j.simpleLogger.showLevel";
    public static final String LEVEL_IN_BRACKETS_KEY = "org.slf4j.simpleLogger.levelInBrackets";
    public static final String WARN_LEVEL_STRING_KEY = "org.slf4j.simpleLogger.warnLevelString";
    public static final String LOG_KEY_PREFIX = "org.slf4j.simpleLogger.log.";
    protected int currentLogLevel = 20;
    private transient String shortLogName = null;

    private static String getStringProperty(String string) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return string2 == null ? SIMPLE_LOGGER_PROPS.getProperty(string) : string2;
    }

    private static String getStringProperty(String string, String string2) {
        String string3 = SimpleLogger.getStringProperty(string);
        return string3 == null ? string2 : string3;
    }

    private static boolean getBooleanProperty(String string, boolean bl) {
        String string2 = SimpleLogger.getStringProperty(string);
        return string2 == null ? bl : "true".equalsIgnoreCase(string2);
    }

    static void init() {
        INITIALIZED = true;
        SimpleLogger.loadProperties();
        String string = SimpleLogger.getStringProperty(DEFAULT_LOG_LEVEL_KEY, null);
        if (string != null) {
            DEFAULT_LOG_LEVEL = SimpleLogger.stringToLevel(string);
        }
        SHOW_LOG_NAME = SimpleLogger.getBooleanProperty(SHOW_LOG_NAME_KEY, SHOW_LOG_NAME);
        SHOW_SHORT_LOG_NAME = SimpleLogger.getBooleanProperty(SHOW_SHORT_LOG_NAME_KEY, SHOW_SHORT_LOG_NAME);
        SHOW_DATE_TIME = SimpleLogger.getBooleanProperty(SHOW_DATE_TIME_KEY, SHOW_DATE_TIME);
        SHOW_THREAD_NAME = SimpleLogger.getBooleanProperty(SHOW_THREAD_NAME_KEY, SHOW_THREAD_NAME);
        DATE_TIME_FORMAT_STR = SimpleLogger.getStringProperty(DATE_TIME_FORMAT_KEY, DATE_TIME_FORMAT_STR);
        SHOW_LEVEL = SimpleLogger.getBooleanProperty(SHOW_LEVEL_KEY, SHOW_LEVEL);
        LEVEL_IN_BRACKETS = SimpleLogger.getBooleanProperty(LEVEL_IN_BRACKETS_KEY, LEVEL_IN_BRACKETS);
        WARN_LEVEL_STRING = SimpleLogger.getStringProperty(WARN_LEVEL_STRING_KEY, WARN_LEVEL_STRING);
        LOG_FILE = SimpleLogger.getStringProperty(LOG_FILE_KEY, LOG_FILE);
        TARGET_STREAM = SimpleLogger.computeTargetStream(LOG_FILE);
        if (DATE_TIME_FORMAT_STR != null) {
            try {
                DATE_FORMATTER = new SimpleDateFormat(DATE_TIME_FORMAT_STR);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Util.report("Bad date format in simplelogger.properties; will output relative time", illegalArgumentException);
            }
        }
    }

    private static PrintStream computeTargetStream(String string) {
        if ("System.err".equalsIgnoreCase(string)) {
            return System.err;
        }
        if ("System.out".equalsIgnoreCase(string)) {
            return System.out;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream);
            return printStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            Util.report("Could not open [" + string + "]. Defaulting to System.err", fileNotFoundException);
            return System.err;
        }
    }

    private static void loadProperties() {
        InputStream inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader != null) {
                    return classLoader.getResourceAsStream(SimpleLogger.CONFIGURATION_FILE);
                }
                return ClassLoader.getSystemResourceAsStream(SimpleLogger.CONFIGURATION_FILE);
            }
        });
        if (null != inputStream) {
            try {
                SIMPLE_LOGGER_PROPS.load(inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    SimpleLogger(String string) {
        if (!INITIALIZED) {
            SimpleLogger.init();
        }
        this.name = string;
        String string2 = this.recursivelyComputeLevelString();
        this.currentLogLevel = string2 != null ? SimpleLogger.stringToLevel(string2) : DEFAULT_LOG_LEVEL;
    }

    String recursivelyComputeLevelString() {
        String string = this.name;
        String string2 = null;
        int n = string.length();
        while (string2 == null && n > -1) {
            string = string.substring(0, n);
            string2 = SimpleLogger.getStringProperty(LOG_KEY_PREFIX + string, null);
            n = String.valueOf(string).lastIndexOf(".");
        }
        return string2;
    }

    private static int stringToLevel(String string) {
        if ("trace".equalsIgnoreCase(string)) {
            return 0;
        }
        if ("debug".equalsIgnoreCase(string)) {
            return 10;
        }
        if ("info".equalsIgnoreCase(string)) {
            return 20;
        }
        if ("warn".equalsIgnoreCase(string)) {
            return 30;
        }
        if ("error".equalsIgnoreCase(string)) {
            return 40;
        }
        return 20;
    }

    private void log(int n, String string, Throwable throwable) {
        if (!this.isLevelEnabled(n)) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(32);
        if (SHOW_DATE_TIME) {
            if (DATE_FORMATTER != null) {
                stringBuffer.append(this.getFormattedDate());
                stringBuffer.append(' ');
            } else {
                stringBuffer.append(System.currentTimeMillis() - START_TIME);
                stringBuffer.append(' ');
            }
        }
        if (SHOW_THREAD_NAME) {
            stringBuffer.append('[');
            stringBuffer.append(Thread.currentThread().getName());
            stringBuffer.append("] ");
        }
        if (SHOW_LEVEL) {
            if (LEVEL_IN_BRACKETS) {
                stringBuffer.append('[');
            }
            switch (n) {
                case 0: {
                    stringBuffer.append("TRACE");
                    break;
                }
                case 10: {
                    stringBuffer.append("DEBUG");
                    break;
                }
                case 20: {
                    stringBuffer.append("INFO");
                    break;
                }
                case 30: {
                    stringBuffer.append(WARN_LEVEL_STRING);
                    break;
                }
                case 40: {
                    stringBuffer.append("ERROR");
                }
            }
            if (LEVEL_IN_BRACKETS) {
                stringBuffer.append(']');
            }
            stringBuffer.append(' ');
        }
        if (SHOW_SHORT_LOG_NAME) {
            if (this.shortLogName == null) {
                this.shortLogName = this.computeShortName();
            }
            stringBuffer.append(String.valueOf(this.shortLogName)).append(" - ");
        } else if (SHOW_LOG_NAME) {
            stringBuffer.append(String.valueOf(this.name)).append(" - ");
        }
        stringBuffer.append(string);
        this.write(stringBuffer, throwable);
    }

    void write(StringBuffer stringBuffer, Throwable throwable) {
        TARGET_STREAM.println(stringBuffer.toString());
        if (throwable != null) {
            throwable.printStackTrace(TARGET_STREAM);
        }
        TARGET_STREAM.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFormattedDate() {
        String string;
        Date date = new Date();
        DateFormat dateFormat = DATE_FORMATTER;
        synchronized (dateFormat) {
            string = DATE_FORMATTER.format(date);
        }
        return string;
    }

    private String computeShortName() {
        return this.name.substring(this.name.lastIndexOf(".") + 1);
    }

    private void formatAndLog(int n, String string, Object object, Object object2) {
        if (!this.isLevelEnabled(n)) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.format(string, object, object2);
        this.log(n, formattingTuple.getMessage(), formattingTuple.getThrowable());
    }

    private void formatAndLog(int n, String string, Object ... objectArray) {
        if (!this.isLevelEnabled(n)) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.arrayFormat(string, objectArray);
        this.log(n, formattingTuple.getMessage(), formattingTuple.getThrowable());
    }

    protected boolean isLevelEnabled(int n) {
        return n >= this.currentLogLevel;
    }

    public boolean isTraceEnabled() {
        return this.isLevelEnabled(0);
    }

    public void trace(String string) {
        this.log(0, string, null);
    }

    public void trace(String string, Object object) {
        this.formatAndLog(0, string, object, (Object)null);
    }

    public void trace(String string, Object object, Object object2) {
        this.formatAndLog(0, string, object, object2);
    }

    public void trace(String string, Object ... objectArray) {
        this.formatAndLog(0, string, objectArray);
    }

    public void trace(String string, Throwable throwable) {
        this.log(0, string, throwable);
    }

    public boolean isDebugEnabled() {
        return this.isLevelEnabled(10);
    }

    public void debug(String string) {
        this.log(10, string, null);
    }

    public void debug(String string, Object object) {
        this.formatAndLog(10, string, object, (Object)null);
    }

    public void debug(String string, Object object, Object object2) {
        this.formatAndLog(10, string, object, object2);
    }

    public void debug(String string, Object ... objectArray) {
        this.formatAndLog(10, string, objectArray);
    }

    public void debug(String string, Throwable throwable) {
        this.log(10, string, throwable);
    }

    public boolean isInfoEnabled() {
        return this.isLevelEnabled(20);
    }

    public void info(String string) {
        this.log(20, string, null);
    }

    public void info(String string, Object object) {
        this.formatAndLog(20, string, object, (Object)null);
    }

    public void info(String string, Object object, Object object2) {
        this.formatAndLog(20, string, object, object2);
    }

    public void info(String string, Object ... objectArray) {
        this.formatAndLog(20, string, objectArray);
    }

    public void info(String string, Throwable throwable) {
        this.log(20, string, throwable);
    }

    public boolean isWarnEnabled() {
        return this.isLevelEnabled(30);
    }

    public void warn(String string) {
        this.log(30, string, null);
    }

    public void warn(String string, Object object) {
        this.formatAndLog(30, string, object, (Object)null);
    }

    public void warn(String string, Object object, Object object2) {
        this.formatAndLog(30, string, object, object2);
    }

    public void warn(String string, Object ... objectArray) {
        this.formatAndLog(30, string, objectArray);
    }

    public void warn(String string, Throwable throwable) {
        this.log(30, string, throwable);
    }

    public boolean isErrorEnabled() {
        return this.isLevelEnabled(40);
    }

    public void error(String string) {
        this.log(40, string, null);
    }

    public void error(String string, Object object) {
        this.formatAndLog(40, string, object, (Object)null);
    }

    public void error(String string, Object object, Object object2) {
        this.formatAndLog(40, string, object, object2);
    }

    public void error(String string, Object ... objectArray) {
        this.formatAndLog(40, string, objectArray);
    }

    public void error(String string, Throwable throwable) {
        this.log(40, string, throwable);
    }
}

