/*
 * Decompiled with CFR 0.152.
 */
package opennlp.model;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import opennlp.model.AbstractDataIndexer;
import opennlp.model.ComparableEvent;
import opennlp.model.Event;
import opennlp.model.EventStream;
import opennlp.model.FileEventStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwoPassDataIndexer
extends AbstractDataIndexer {
    public TwoPassDataIndexer(EventStream eventStream) throws IOException {
        this(eventStream, 0);
    }

    public TwoPassDataIndexer(EventStream eventStream, int n) throws IOException {
        this(eventStream, n, true);
    }

    public TwoPassDataIndexer(EventStream eventStream, int n, boolean bl) throws IOException {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        System.out.println("Indexing events using cutoff of " + n + "\n");
        System.out.print("\tComputing event counts...  ");
        try {
            File file = File.createTempFile("events", null);
            file.deleteOnExit();
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
            int n2 = this.computeEventCounts(eventStream, bufferedWriter, hashMap, n);
            System.out.println("done. " + n2 + " events");
            System.out.print("\tIndexing...  ");
            List list = this.index(n2, new FileEventStream(file), hashMap);
            hashMap = null;
            file.delete();
            System.out.println("done.");
            if (bl) {
                System.out.print("Sorting and merging events... ");
            } else {
                System.out.print("Collecting events... ");
            }
            this.sortAndMerge(list, bl);
            System.out.println("Done indexing.");
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    private int computeEventCounts(EventStream eventStream, Writer writer, Map<String, Integer> map, int n) throws IOException {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int n2 = 0;
        HashSet hashSet = new HashSet();
        while (eventStream.hasNext()) {
            Event event = eventStream.next();
            ++n2;
            writer.write(FileEventStream.toLine(event));
            String[] stringArray = event.getContext();
            TwoPassDataIndexer.update(stringArray, hashSet, hashMap, n);
        }
        this.predCounts = new int[hashSet.size()];
        int n3 = 0;
        for (String string : hashSet) {
            this.predCounts[n3] = (Integer)hashMap.get(string);
            map.put(string, n3);
            ++n3;
        }
        writer.close();
        return n2;
    }

    private List index(int n, EventStream eventStream, Map<String, Integer> map) throws IOException {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int n2 = 0;
        ArrayList<ComparableEvent> arrayList = new ArrayList<ComparableEvent>(n);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        while (eventStream.hasNext()) {
            int n3;
            Event event = eventStream.next();
            String[] stringArray = event.getContext();
            String string = event.getOutcome();
            if (hashMap.containsKey(string)) {
                n3 = (Integer)hashMap.get(string);
            } else {
                n3 = n2++;
                hashMap.put(string, n3);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (!map.containsKey(string2)) continue;
                arrayList2.add(map.get(string2));
            }
            if (arrayList2.size() > 0) {
                int[] nArray = new int[arrayList2.size()];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = (Integer)arrayList2.get(i);
                }
                ComparableEvent comparableEvent = new ComparableEvent(n3, nArray);
                arrayList.add(comparableEvent);
            } else {
                System.err.println("Dropped event " + event.getOutcome() + ":" + Arrays.asList(event.getContext()));
            }
            arrayList2.clear();
        }
        this.outcomeLabels = TwoPassDataIndexer.toIndexedStringArray(hashMap);
        this.predLabels = TwoPassDataIndexer.toIndexedStringArray(map);
        return arrayList;
    }
}

