/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.princeton.file;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.didion.jwnl.JWNLRuntimeException;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.dictionary.file.DictionaryFile;
import net.didion.jwnl.dictionary.file.DictionaryFileType;
import net.didion.jwnl.princeton.file.AbstractPrincetonRandomAccessDictionaryFile;

public class PrincetonRandomAccessDictionaryFile
extends AbstractPrincetonRandomAccessDictionaryFile {
    public static final String READ_ONLY = "r";
    public static final String READ_WRITE = "rw";
    private RandomAccessFile _file = null;
    protected String _permissions;

    public DictionaryFile newInstance(String string, POS pOS, DictionaryFileType dictionaryFileType) {
        return new PrincetonRandomAccessDictionaryFile(string, pOS, dictionaryFileType);
    }

    public PrincetonRandomAccessDictionaryFile() {
    }

    public PrincetonRandomAccessDictionaryFile(String string, POS pOS, DictionaryFileType dictionaryFileType) {
        this(string, pOS, dictionaryFileType, READ_ONLY);
    }

    public PrincetonRandomAccessDictionaryFile(String string, POS pOS, DictionaryFileType dictionaryFileType, String string2) {
        super(string, pOS, dictionaryFileType);
        this._permissions = string2;
    }

    public String readLine() throws IOException {
        if (this.isOpen()) {
            return this._file.readLine();
        }
        throw new JWNLRuntimeException("PRINCETON_EXCEPTION_001");
    }

    public void seek(long l) throws IOException {
        this._file.seek(l);
    }

    public long getFilePointer() throws IOException {
        return this._file.getFilePointer();
    }

    public boolean isOpen() {
        return this._file != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            try {
                this._file.close();
            }
            catch (Exception exception) {
                Object var3_2 = null;
                this._file = null;
            }
            Object var3_1 = null;
            this._file = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._file = null;
            throw throwable;
        }
    }

    protected void openFile(File file) throws IOException {
        this._file = new RandomAccessFile(file, this._permissions);
    }

    public long length() throws IOException {
        return this._file.length();
    }

    public int read() throws IOException {
        return this._file.read();
    }
}

