/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.dictionary;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.JWNLRuntimeException;
import net.didion.jwnl.data.DictionaryElementFactory;
import net.didion.jwnl.data.Exc;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.dictionary.AbstractCachingDictionary;
import net.didion.jwnl.dictionary.Dictionary;
import net.didion.jwnl.dictionary.MorphologicalProcessor;
import net.didion.jwnl.dictionary.POSKey;
import net.didion.jwnl.dictionary.file.DictionaryFileType;
import net.didion.jwnl.dictionary.file_manager.FileManager;
import net.didion.jwnl.util.factory.Param;
import net.didion.jwnl.util.logging.Level;
import net.didion.jwnl.util.logging.LogPublishingService;

public class FileBackedDictionary
extends AbstractCachingDictionary {
    public static final String MORPH = "morphological_processor";
    public static final String FILE_MANAGER = "file_manager";
    public static final String ENABLE_CACHING = "enable_caching";
    public static final String CACHE_SIZE = "cache_size";
    public static final String INDEX_WORD_CACHE_SIZE = "index_word_cache_size";
    public static final String SYNSET_WORD_CACHE_SIZE = "synset_word_cache_size";
    public static final String EXCEPTION_WORD_CACHE_SIZE = "exception_word_cache_size";
    private FileManager _db = null;

    public FileBackedDictionary() {
    }

    private FileBackedDictionary(FileManager fileManager, MorphologicalProcessor morphologicalProcessor, boolean bl) {
        super(morphologicalProcessor, bl);
        this._db = fileManager;
    }

    private FileBackedDictionary(FileManager fileManager, MorphologicalProcessor morphologicalProcessor, AbstractCachingDictionary.CacheSizes cacheSizes) {
        super(morphologicalProcessor, cacheSizes);
        this._db = fileManager;
    }

    public void install(Map map) throws JWNLException {
        boolean bl;
        Param param = (Param)map.get(MORPH);
        MorphologicalProcessor morphologicalProcessor = param == null ? null : (MorphologicalProcessor)param.create();
        FileManager fileManager = (FileManager)((Param)map.get(FILE_MANAGER)).create();
        boolean bl2 = bl = !map.containsKey(ENABLE_CACHING) || !((Param)map.get(ENABLE_CACHING)).getValue().equalsIgnoreCase("false");
        if (bl) {
            AbstractCachingDictionary.CacheSizes cacheSizes = null;
            cacheSizes = map.containsKey(CACHE_SIZE) ? new AbstractCachingDictionary.CacheSizes(Integer.parseInt(((Param)map.get(CACHE_SIZE)).getValue())) : new AbstractCachingDictionary.CacheSizes();
            if (map.containsKey(INDEX_WORD_CACHE_SIZE)) {
                cacheSizes.setIndexWordCacheSize(Integer.parseInt(((Param)map.get(INDEX_WORD_CACHE_SIZE)).getValue()));
            }
            if (map.containsKey(SYNSET_WORD_CACHE_SIZE)) {
                cacheSizes.setIndexWordCacheSize(Integer.parseInt(((Param)map.get(SYNSET_WORD_CACHE_SIZE)).getValue()));
            }
            if (map.containsKey(EXCEPTION_WORD_CACHE_SIZE)) {
                cacheSizes.setIndexWordCacheSize(Integer.parseInt(((Param)map.get(EXCEPTION_WORD_CACHE_SIZE)).getValue()));
            }
            FileBackedDictionary.install(fileManager, morphologicalProcessor, cacheSizes);
        } else {
            FileBackedDictionary.install(fileManager, morphologicalProcessor, false);
        }
    }

    public static void install(FileManager fileManager) {
        FileBackedDictionary.install(fileManager, (MorphologicalProcessor)null);
    }

    public static void install(FileManager fileManager, MorphologicalProcessor morphologicalProcessor) {
        FileBackedDictionary.install(fileManager, morphologicalProcessor, true);
    }

    public static void install(FileManager fileManager, boolean bl) {
        FileBackedDictionary.install(fileManager, null, bl);
    }

    public static void install(FileManager fileManager, MorphologicalProcessor morphologicalProcessor, boolean bl) {
        Dictionary.setDictionary(new FileBackedDictionary(fileManager, morphologicalProcessor, bl));
    }

    public static void install(FileManager fileManager, AbstractCachingDictionary.CacheSizes cacheSizes) {
        FileBackedDictionary.install(fileManager, null, cacheSizes);
    }

    public static void install(FileManager fileManager, MorphologicalProcessor morphologicalProcessor, AbstractCachingDictionary.CacheSizes cacheSizes) {
        Dictionary.setDictionary(new FileBackedDictionary(fileManager, morphologicalProcessor, cacheSizes));
    }

    public void close() {
        this._db.close();
    }

    protected FileManager getFileManager() {
        return this._db;
    }

    public Iterator getIndexWordIterator(POS pOS) throws JWNLException {
        return new IndexFileLookaheadIterator(pOS);
    }

    public Iterator getIndexWordIterator(POS pOS, String string) throws JWNLException {
        return new SubstringIndexFileLookaheadIterator(pOS, string);
    }

    public IndexWord getIndexWord(POS pOS, String string) throws JWNLException {
        IndexWord indexWord = null;
        if (!string.equals("")) {
            if (this.isCachingEnabled()) {
                indexWord = this.getCachedIndexWord(new POSKey(pOS, string));
            }
            if (indexWord == null) {
                try {
                    long l = this.getFileManager().getIndexedLinePointer(pOS, DictionaryFileType.INDEX, string.toLowerCase().replace(' ', '_'));
                    if (l >= 0L) {
                        indexWord = this.parseAndCacheIndexWordLine(pOS, l, this.getFileManager().readLineAt(pOS, DictionaryFileType.INDEX, l));
                    }
                }
                catch (IOException iOException) {
                    throw new JWNLRuntimeException("DICTIONARY_EXCEPTION_004", string, (Throwable)iOException);
                }
            }
        }
        return indexWord;
    }

    private IndexWord parseAndCacheIndexWordLine(POS pOS, long l, String string) {
        IndexWord indexWord = DictionaryElementFactory.getInstance().createIndexWord(pOS, string);
        if (this.isCachingEnabled() && indexWord != null) {
            this.cacheIndexWord(new POSKey(pOS, l), indexWord);
        }
        return indexWord;
    }

    public Iterator getSynsetIterator(final POS pOS) {
        return new FileLookaheadIterator(pOS, DictionaryFileType.DATA){

            protected Object parseLine(long l, String string) {
                return FileBackedDictionary.this.getSynset(pOS, l, string);
            }
        };
    }

    public Synset getSynsetAt(POS pOS, long l) {
        return this.getSynset(pOS, l, null);
    }

    private Synset getSynset(POS pOS, long l, String string) {
        POSKey pOSKey = new POSKey(pOS, l);
        Synset synset = this.getCachedSynset(pOSKey);
        try {
            if (synset == null) {
                if (string == null) {
                    string = this.getFileManager().readLineAt(pOS, DictionaryFileType.DATA, l);
                }
                if ((synset = DictionaryElementFactory.getInstance().createSynset(pOS, string)) != null) {
                    this.cacheSynset(pOSKey, synset);
                }
            }
        }
        catch (Exception exception) {
            throw new JWNLRuntimeException("DICTIONARY_EXCEPTION_005", new Long(l), (Throwable)exception);
        }
        return synset;
    }

    public Iterator getExceptionIterator(final POS pOS) {
        return new FileLookaheadIterator(pOS, DictionaryFileType.EXCEPTION){

            protected Object parseLine(long l, String string) {
                Exc exc = null;
                if (FileBackedDictionary.this.isCachingEnabled()) {
                    exc = FileBackedDictionary.this.getCachedException(new POSKey(pOS, l));
                }
                if (exc == null) {
                    exc = FileBackedDictionary.this.parseAndCacheExceptionLine(pOS, l, string);
                }
                return exc;
            }
        };
    }

    public Exc getException(POS pOS, String string) {
        Exc exc = null;
        POSKey pOSKey = null;
        if (string != null) {
            if (this.isCachingEnabled()) {
                pOSKey = new POSKey(pOS, string);
                exc = this.getCachedException(pOSKey);
            }
            if (exc == null) {
                long l = -1L;
                try {
                    l = this.getFileManager().getIndexedLinePointer(pOS, DictionaryFileType.EXCEPTION, string.toLowerCase().replace(' ', '_'));
                    if (l >= 0L) {
                        exc = this.parseAndCacheExceptionLine(pOS, l, this.getFileManager().readLineAt(pOS, DictionaryFileType.EXCEPTION, l));
                    }
                }
                catch (Exception exception) {
                    throw new JWNLRuntimeException("DICTIONARY_EXCEPTION_006", exception);
                }
            }
        }
        return exc;
    }

    private Exc parseAndCacheExceptionLine(POS pOS, long l, String string) {
        Exc exc = DictionaryElementFactory.getInstance().createExc(pOS, string);
        if (this.isCachingEnabled() && exc != null) {
            this.cacheException(new POSKey(pOS, l), exc);
        }
        return exc;
    }

    private class SubstringIndexFileLookaheadIterator
    extends IndexFileLookaheadIterator {
        private String _substring = null;

        public SubstringIndexFileLookaheadIterator(POS pOS, String string) throws JWNLException {
            super(pOS);
            this._substring = string;
            this.nextOffset();
        }

        protected long getNextOffset(long l) throws JWNLException {
            try {
                return FileBackedDictionary.this.getFileManager().getMatchingLinePointer(this._pos, DictionaryFileType.INDEX, l, this._substring);
            }
            catch (IOException iOException) {
                throw new JWNLException("DICTIONARY_EXCEPTION_008", new Object[]{this._pos, this._fileType}, (Throwable)iOException);
            }
        }
    }

    private class IndexFileLookaheadIterator
    extends FileLookaheadIterator {
        protected POS _pos;

        public IndexFileLookaheadIterator(POS pOS) {
            super(pOS, DictionaryFileType.INDEX);
            this._pos = pOS;
        }

        protected Object parseLine(long l, String string) {
            IndexWord indexWord = null;
            if (FileBackedDictionary.this.isCachingEnabled()) {
                indexWord = FileBackedDictionary.this.getCachedIndexWord(new POSKey(this._pos, l));
            }
            if (indexWord == null) {
                indexWord = FileBackedDictionary.this.parseAndCacheIndexWordLine(this._pos, l, string);
            }
            return indexWord;
        }
    }

    private abstract class FileLookaheadIterator
    implements Iterator {
        private String _currentLine = null;
        private long _currentOffset = -1L;
        private long _nextOffset = 0L;
        private boolean _more = true;
        protected POS _pos;
        protected DictionaryFileType _fileType;

        public FileLookaheadIterator(POS pOS, DictionaryFileType dictionaryFileType) {
            this._pos = pOS;
            this._fileType = dictionaryFileType;
            try {
                do {
                    this.nextLine();
                } while (this._currentLine.startsWith("  "));
            }
            catch (NoSuchElementException noSuchElementException) {
                LogPublishingService.getInstance().log(Level.WARNING, "DICTIONARY_EXCEPTION_007", new Object[]{this._pos, this._fileType});
            }
        }

        protected abstract Object parseLine(long var1, String var3);

        public final Object next() {
            if (this.hasNext()) {
                Object object = this.parseLine(this._currentOffset, this._currentLine);
                this.nextLine();
                return object;
            }
            throw new NoSuchElementException();
        }

        public final boolean hasNext() {
            return this._more;
        }

        public void remove() {
        }

        protected final void nextLine() {
            try {
                if (this._nextOffset >= 0L) {
                    this._currentLine = FileBackedDictionary.this._db.readLineAt(this._pos, this._fileType, this._nextOffset);
                    if (this._currentLine != null) {
                        this.nextOffset();
                        return;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._more = false;
        }

        protected final void nextOffset() throws JWNLException {
            this._currentOffset = this._nextOffset;
            this._nextOffset = this.getNextOffset(this._currentOffset);
        }

        protected long getNextOffset(long l) throws JWNLException {
            try {
                return FileBackedDictionary.this._db.getNextLinePointer(this._pos, this._fileType, l);
            }
            catch (IOException iOException) {
                throw new JWNLException("DICTIONARY_EXCEPTION_008", new Object[]{this._pos, this._fileType}, (Throwable)iOException);
            }
        }
    }
}

