/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.JWNLRuntimeException;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.data.Word;
import net.didion.jwnl.util.Resolvable;

public class Adjective
extends Word {
    static final long serialVersionUID = 937870634100403173L;
    public static final AdjectivePosition NONE = new AdjectivePosition("NONE", "NONE_KEY");
    public static final AdjectivePosition PREDICATIVE = new AdjectivePosition("AP_PREDICATIVE", "AP_PREDICATIVE_KEY");
    public static final AdjectivePosition ATTRIBUTIVE = new AdjectivePosition("AP_ATTRIBUTIVE", "AP_ATTRIBUTIVE_KEY");
    public static final AdjectivePosition IMMEDIATE_POSTNOMINAL = new AdjectivePosition("AP_IMMEDIATE_POSTNOMIAL", "AP_IMMEDIATE_POSTNOMIAL_KEY");
    public static final AdjectivePosition[] ADJECTIVE_POSITIONS = new AdjectivePosition[]{NONE, PREDICATIVE, ATTRIBUTIVE, IMMEDIATE_POSTNOMINAL};
    private static final Map KEY_TO_OBJECT_MAP = new HashMap();
    private static boolean _initialized = false;
    private AdjectivePosition _adjectivePosition;

    public static void initialize() {
        if (!_initialized) {
            int n = 0;
            while (n < ADJECTIVE_POSITIONS.length) {
                KEY_TO_OBJECT_MAP.put(ADJECTIVE_POSITIONS[n].getKey(), ADJECTIVE_POSITIONS[n]);
                ++n;
            }
            _initialized = true;
        }
    }

    public static AdjectivePosition getAdjectivePositionForKey(String string) {
        AdjectivePosition adjectivePosition = (AdjectivePosition)KEY_TO_OBJECT_MAP.get(string);
        if (adjectivePosition == null) {
            throw new JWNLRuntimeException("PRINCETON_EXCEPTION_007", string);
        }
        return adjectivePosition;
    }

    public Adjective(Synset synset, int n, String string, AdjectivePosition adjectivePosition) {
        super(synset, n, string);
        this._adjectivePosition = adjectivePosition;
    }

    public AdjectivePosition getAdjectivePosition() {
        return this._adjectivePosition;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._adjectivePosition = Adjective.getAdjectivePositionForKey(this._adjectivePosition.getKey());
    }

    public static final class AdjectivePosition
    implements Serializable {
        private Resolvable _key;
        private Resolvable _label;
        private transient String _cachedToString = null;

        private AdjectivePosition(String string, String string2) {
            this._label = new Resolvable(string);
            this._key = new Resolvable(string2);
        }

        public String getKey() {
            return this._key.toString();
        }

        public String getLabel() {
            return this._label.toString();
        }

        public String toString() {
            if (this._cachedToString == null) {
                this._cachedToString = JWNL.resolveMessage("DATA_TOSTRING_006", this._label);
            }
            return this._cachedToString;
        }
    }
}

