/*
 * Decompiled with CFR 0.152.
 */
package Jet.Util;

import Jet.Util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleArrayTrie {
    int[] base = new int[0];
    int[] check = new int[0];
    MappedByteBuffer map = null;
    boolean[] used;
    int size;
    int alloc_size = 0;
    char[][] keys;
    int[] length;
    int[] val;
    int next_check_pos;
    int progress;
    int error;

    private void resize(int n) {
        this.base = this.resize(this.base, this.alloc_size, n);
        this.check = this.resize(this.check, this.alloc_size, n);
        this.used = this.resize(this.used, this.alloc_size, n);
        this.alloc_size = n;
    }

    private <T> T resize(T t, int n, int n2) {
        Object object = Array.newInstance(t.getClass().getComponentType(), n2);
        System.arraycopy(t, 0, object, 0, Math.min(n, n2));
        return (T)object;
    }

    private int fetch(Node node, List<Node> list) {
        if (this.error < 0) {
            return 0;
        }
        int n = 0;
        for (int i = node.left; i < node.right; ++i) {
            if (this.keys[i].length < node.depth) continue;
            char[] cArray = this.keys[i];
            int n2 = 0;
            if (this.keys[i].length != node.depth) {
                n2 = cArray[node.depth] + '\u0001';
            }
            if (n > n2) {
                this.error = -3;
                return 0;
            }
            if (n2 != n || list.isEmpty()) {
                Node node2 = new Node();
                node2.depth = node.depth + 1;
                node2.code = n2;
                node2.left = i;
                if (!list.isEmpty()) {
                    list.get((int)(list.size() - 1)).right = i;
                }
                list.add(node2);
            }
            n = n2;
        }
        if (!list.isEmpty()) {
            list.get((int)(list.size() - 1)).right = node.right;
        }
        return list.size();
    }

    private int insert(List<Node> list) {
        int n;
        if (this.error < 0) {
            return 0;
        }
        int n2 = 0;
        int n3 = Math.max(list.get((int)0).code + 1, this.next_check_pos) - 1;
        int n4 = 0;
        boolean bl = false;
        if (this.alloc_size <= n3) {
            this.resize(n3 + 1);
        }
        block0: while (true) {
            if (this.alloc_size <= ++n3) {
                this.resize(n3 + 1);
            }
            if (this.getCheck(n3) != 0) {
                ++n4;
                continue;
            }
            if (!bl) {
                this.next_check_pos = n3;
                bl = true;
            }
            if (this.alloc_size <= (n2 = n3 - list.get((int)0).code) + list.get((int)(list.size() - 1)).code) {
                this.resize((int)((double)this.alloc_size * Math.max(1.05, 1.0 * (double)this.keys.length / (double)this.progress)));
            }
            if (this.used[n2]) continue;
            for (n = 1; n < list.size(); ++n) {
                if (this.getCheck(n2 + list.get((int)n).code) == 0) continue;
                continue block0;
            }
            break;
        }
        if (1.0 * (double)n4 / (double)(n3 - this.next_check_pos + 1) >= 0.95) {
            this.next_check_pos = n3;
        }
        this.used[n2] = true;
        this.size = Math.max(this.size, n2 + list.get((int)(list.size() - 1)).code + 1);
        for (n = 0; n < list.size(); ++n) {
            this.setCheck(n2 + list.get((int)n).code, n2);
        }
        for (n = 0; n < list.size(); ++n) {
            int n5;
            ArrayList<Node> arrayList = new ArrayList<Node>();
            if (this.fetch(list.get(n), arrayList) == 0) {
                n5 = this.val != null ? -this.val[list.get((int)n).left] - 1 : -list.get((int)n).left - 1;
                this.setBase(n2 + list.get((int)n).code, n5);
                if (this.val != null && -this.val[list.get((int)n).left] - 1 >= 0) {
                    this.error = -2;
                    return 0;
                }
                ++this.progress;
                continue;
            }
            n5 = this.insert(arrayList);
            this.setBase(n2 + list.get((int)n).code, n5);
        }
        return n2;
    }

    public boolean build(char[][] cArray, int[] nArray) {
        this.keys = cArray;
        this.val = nArray;
        this.progress = 0;
        this.used = new boolean[this.alloc_size];
        this.length = new int[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            this.length[i] = cArray[i].length;
        }
        this.resize(8192);
        this.setBase(0, 1);
        this.next_check_pos = 0;
        Node node = new Node();
        node.left = 0;
        node.right = cArray.length;
        node.depth = 0;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        this.fetch(node, arrayList);
        this.insert(arrayList);
        this.size += 65537;
        if (this.size >= this.alloc_size) {
            this.resize(this.size);
        }
        this.used = null;
        return this.error >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String string) throws IOException {
        RandomAccessFile randomAccessFile = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        try {
            int n;
            randomAccessFile = new RandomAccessFile(string, "rw");
            int n2 = this.alloc_size * 8;
            randomAccessFile.setLength(n2);
            abstractInterruptibleChannel = randomAccessFile.getChannel();
            MappedByteBuffer mappedByteBuffer = ((FileChannel)abstractInterruptibleChannel).map(FileChannel.MapMode.READ_WRITE, 0L, n2);
            mappedByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            for (n = 0; n < this.alloc_size; ++n) {
                mappedByteBuffer.putInt(this.getBase(n));
            }
            for (n = 0; n < this.alloc_size; ++n) {
                mappedByteBuffer.putInt(this.getCheck(n));
            }
            randomAccessFile.setLength(mappedByteBuffer.position());
        }
        finally {
            if (abstractInterruptibleChannel != null) {
                abstractInterruptibleChannel.close();
            } else if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
    }

    public void load(String string) throws IOException {
        this.load(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws IOException {
        RandomAccessFile randomAccessFile = null;
        FileChannel fileChannel = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            fileChannel = randomAccessFile.getChannel();
            this.map = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, randomAccessFile.length());
            this.map.order(ByteOrder.LITTLE_ENDIAN);
            this.alloc_size = (int)(randomAccessFile.length() / 8L);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileChannel);
            IOUtils.closeQuietly(randomAccessFile);
            throw throwable;
        }
        IOUtils.closeQuietly(fileChannel);
        IOUtils.closeQuietly(randomAccessFile);
    }

    public int exactMatchSearch(CharSequence charSequence, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = this.getBase(n3);
        int n7 = -1;
        for (n5 = 0; n5 < n2; ++n5) {
            n4 = n6 + charSequence.charAt(n + n5) + 1;
            if (n6 != this.getCheck(n4)) {
                return n7;
            }
            n6 = this.getBase(n4);
        }
        n4 = n6;
        n5 = this.getBase(n4);
        if (n6 == this.getCheck(n4) && n5 < 0) {
            n7 = -n5 - 1;
        }
        return n7;
    }

    public int exactMatchSearch(CharSequence charSequence, int n, int n2) {
        return this.exactMatchSearch(charSequence, n, n2, 0);
    }

    public int exactMatchSearch(CharSequence charSequence, int n) {
        return this.exactMatchSearch(charSequence, n, charSequence.length() - n, 0);
    }

    public int exactMatchSearch(CharSequence charSequence) {
        return this.exactMatchSearch(charSequence, 0, charSequence.length(), 0);
    }

    public List<Result> commonPrefixSearch(CharSequence charSequence, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = this.getBase(n3);
        ArrayList<Result> arrayList = new ArrayList<Result>();
        for (int i = 0; i < n2; ++i) {
            n5 = n6;
            n4 = this.getBase(n5);
            if (n6 == this.getCheck(n5) && n4 < 0) {
                arrayList.add(new Result(-n4 - 1, i));
            }
            if (n6 != this.getCheck(n5 = n6 + charSequence.charAt(n + i) + 1)) {
                return arrayList;
            }
            n6 = this.getBase(n5);
        }
        n5 = n6;
        n4 = this.getBase(n5);
        if (n6 == this.getCheck(n5) && n4 < 0) {
            arrayList.add(new Result(-n4 - 1, n2));
        }
        return arrayList;
    }

    public List<Result> commonPrefixSearch(CharSequence charSequence, int n, int n2) {
        return this.commonPrefixSearch(charSequence, n, n2, 0);
    }

    public List<Result> commonPrefixSearch(CharSequence charSequence, int n) {
        return this.commonPrefixSearch(charSequence, n, charSequence.length() - n, 0);
    }

    public List<Result> commonPrefixSearch(CharSequence charSequence) {
        return this.commonPrefixSearch(charSequence, 0, charSequence.length(), 0);
    }

    public Result getLongestCommonPrefix(CharSequence charSequence, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = this.getBase(n3);
        int n7 = -1;
        int n8 = -1;
        for (int i = 0; i < n2; ++i) {
            n5 = n6;
            n4 = this.getBase(n5);
            if (n6 == this.getCheck(n5) && n4 < 0) {
                n7 = -n4 - 1;
                n8 = i;
            }
            if (n6 != this.getCheck(n5 = n6 + charSequence.charAt(n + i) + 1)) {
                if (n8 < 0) {
                    return null;
                }
                return new Result(n7, n8);
            }
            n6 = this.getBase(n5);
        }
        n5 = n6;
        n4 = this.getBase(n5);
        if (n6 == this.getCheck(n5) && n4 < 0) {
            n7 = -n4 - 1;
            n8 = n2;
        }
        if (n8 > 0) {
            return new Result(n7, n8);
        }
        return null;
    }

    public Result getLongestCommonPrefix(CharSequence charSequence, int n, int n2) {
        return this.getLongestCommonPrefix(charSequence, n, n2, 0);
    }

    public Result getLongestCommonPrefix(CharSequence charSequence, int n) {
        return this.getLongestCommonPrefix(charSequence, n, charSequence.length() - n, 0);
    }

    public Result getLongestCommonPrefix(CharSequence charSequence) {
        return this.getLongestCommonPrefix(charSequence, 0, charSequence.length(), 0);
    }

    private int getBase(int n) {
        if (this.map != null) {
            int n2 = n * 32 / 8;
            this.map.position(n2);
            return this.map.getInt();
        }
        return this.base[n];
    }

    private void setBase(int n, int n2) {
        this.base[n] = n2;
    }

    private int getCheck(int n) {
        if (this.map != null) {
            int n2 = this.alloc_size * 32 / 8 + n * 32 / 8;
            this.map.position(n2);
            return this.map.getInt();
        }
        return this.check[n];
    }

    private void setCheck(int n, int n2) {
        this.check[n] = n2;
    }

    public static final class Result {
        private int value;
        private int length;

        Result(int n, int n2) {
            this.value = n;
            this.length = n2;
        }

        public int getLength() {
            return this.length;
        }

        public int getValue() {
            return this.value;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.length;
            n = 31 * n + this.value;
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof Result) {
                Result result = (Result)object;
                return this.value == result.value && this.length == result.length;
            }
            return false;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[value=");
            stringBuilder.append(this.value);
            stringBuilder.append(", length=");
            stringBuilder.append(this.length);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }

    private static class Node {
        int code;
        int depth;
        int left;
        int right;

        private Node() {
        }
    }
}

