/*
 * Decompiled with CFR 0.152.
 */
package Jet.Parser;

import Jet.Format.InvalidFormatException;
import Jet.Parser.ParseTreeNode;
import Jet.Util.IOUtils;
import Jet.Util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeadRule {
    private static final String DEFAULT_RULE_PATH = "Jet/Parser/resources/head_rule.txt";
    private static final String DEFAULT_RULE_ENCODING = "US-ASCII";
    private static final HeadRule defaultInstance = HeadRule.createDefaultRule();
    private Map<String, HeadRuleEntry> rules = new HashMap<String, HeadRuleEntry>();
    private static final Pattern puncOrParenPattern = Pattern.compile("[\\p{P}\\p{Ps}\\p{Pc}]+");

    private HeadRule() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HeadRule createDefaultRule() {
        HeadRule headRule = new HeadRule();
        InputStream inputStream = HeadRule.class.getClassLoader().getResourceAsStream(DEFAULT_RULE_PATH);
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, DEFAULT_RULE_ENCODING);
            headRule.load(inputStreamReader);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            try {
                throw new RuntimeException(unsupportedOperationException);
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                catch (InvalidFormatException invalidFormatException) {
                    throw new RuntimeException(invalidFormatException);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStreamReader);
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(inputStreamReader);
        IOUtils.closeQuietly(inputStream);
        return headRule;
    }

    public static HeadRule getDefaultRule() {
        return defaultInstance;
    }

    public static HeadRule getRule(Reader reader) throws IOException, InvalidFormatException {
        HeadRule headRule = new HeadRule();
        headRule.load(reader);
        return headRule;
    }

    public static HeadRule getRule(File file) throws IOException, InvalidFormatException {
        HeadRule headRule = new HeadRule();
        headRule.load(file);
        return headRule;
    }

    public int getHead(ParseTreeNode parseTreeNode) {
        int n;
        int n2;
        int n3;
        String string = (String)parseTreeNode.category;
        HeadRuleEntry headRuleEntry = this.rules.get(string);
        ParseTreeNode[] parseTreeNodeArray = parseTreeNode.children;
        if (string.equals("np")) {
            String string2;
            for (n3 = parseTreeNodeArray.length - 1; n3 >= 0; --n3) {
                string2 = (String)parseTreeNodeArray[n3].category;
                if (!string2.startsWith("nn") && !string2.equals("nx") && !string2.equals("pos") && !string2.equals("jjr")) continue;
                return n3 + 1;
            }
            for (n3 = 0; n3 < parseTreeNodeArray.length; ++n3) {
                string2 = (String)parseTreeNodeArray[n3].category;
                if (!string2.equals("np")) continue;
                return n3 + 1;
            }
        }
        if (headRuleEntry == null) {
            if (parseTreeNodeArray.length == 1) {
                return 1;
            }
            return 0;
        }
        switch (headRuleEntry.getDirection()) {
            case LEFT_TO_RIGHT: {
                n3 = 0;
                n2 = parseTreeNodeArray.length;
                n = 1;
                break;
            }
            case RIGHT_TO_LEFT: {
                n3 = parseTreeNodeArray.length - 1;
                n2 = -1;
                n = -1;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        for (String string3 : headRuleEntry.getPriorityList()) {
            for (int i = n3; i != n2; i += n) {
                ParseTreeNode parseTreeNode2 = parseTreeNodeArray[i];
                if (!string3.equals(parseTreeNode2.category)) continue;
                return i + 1;
            }
        }
        for (int i = n3; i != n2; i += n) {
            if (!this.isTerminal(parseTreeNodeArray[i])) {
                return i + 1;
            }
            if (this.isPunctuationOrParenthesis(parseTreeNodeArray[i])) continue;
            return i + 1;
        }
        return n3;
    }

    public void apply(ParseTreeNode parseTreeNode) {
        if (parseTreeNode.children == null || parseTreeNode.children.length == 0) {
            return;
        }
        parseTreeNode.head = this.getHead(parseTreeNode);
        for (ParseTreeNode parseTreeNode2 : parseTreeNode.children) {
            this.apply(parseTreeNode2);
        }
    }

    public void addEntry(String string, ScanDirection scanDirection, List<String> list) {
        HeadRuleEntry headRuleEntry = new HeadRuleEntry(string, scanDirection, list);
        this.rules.put(string, headRuleEntry);
    }

    private void load(Reader reader) throws IOException, InvalidFormatException {
        String string;
        LineNumberReader lineNumberReader = null;
        lineNumberReader = reader instanceof BufferedReader ? new LineNumberReader(reader) : new LineNumberReader(new BufferedReader(reader));
        Pattern pattern = Pattern.compile("^(\\w+) \\s+ (left-to-right|right-to-left) \\s+ (.*)$", 4);
        Pattern pattern2 = Pattern.compile("\\s+");
        while ((string = lineNumberReader.readLine()) != null) {
            if (string.startsWith("#")) continue;
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) {
                throw new InvalidFormatException("Invalid format at line " + lineNumberReader.getLineNumber());
            }
            String string2 = matcher.group(1).toLowerCase();
            ScanDirection scanDirection = this.getScanDirection(matcher.group(2));
            List<String> list = Arrays.asList(pattern2.split(matcher.group(3).toLowerCase()));
            this.addEntry(string2, scanDirection, list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(File file) throws IOException, InvalidFormatException {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            this.load(fileReader);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileReader);
            throw throwable;
        }
        IOUtils.closeQuietly(fileReader);
    }

    private ScanDirection getScanDirection(String string) {
        if (string.equals("left-to-right")) {
            return ScanDirection.LEFT_TO_RIGHT;
        }
        if (string.equals("right-to-left")) {
            return ScanDirection.RIGHT_TO_LEFT;
        }
        return null;
    }

    private boolean isTerminal(ParseTreeNode parseTreeNode) {
        return parseTreeNode.children == null;
    }

    private boolean isPunctuationOrParenthesis(ParseTreeNode parseTreeNode) {
        return puncOrParenPattern.matcher(parseTreeNode.word).matches();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScanDirection {
        LEFT_TO_RIGHT,
        RIGHT_TO_LEFT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HeadRuleEntry {
        private String category;
        private ScanDirection direction;
        private List<String> priorityList;

        public HeadRuleEntry(String string, ScanDirection scanDirection, List<String> list) {
            this.category = string;
            this.direction = scanDirection;
            this.priorityList = list;
        }

        public HeadRuleEntry() {
            this(null, null, new ArrayList<String>());
        }

        public String getCategory() {
            return this.category;
        }

        public void setCategory(String string) {
            this.category = string;
        }

        public ScanDirection getDirection() {
            return this.direction;
        }

        public void setDirection(ScanDirection scanDirection) {
            this.direction = scanDirection;
        }

        public List<String> getPriorityList() {
            return this.priorityList;
        }

        public void setPriorityList(List<String> list) {
            this.priorityList = list;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.category);
            switch (this.direction) {
                case LEFT_TO_RIGHT: {
                    stringBuilder.append(" LR ");
                    break;
                }
                case RIGHT_TO_LEFT: {
                    stringBuilder.append(" RL ");
                }
            }
            stringBuilder.append(StringUtils.join(" ", this.priorityList));
            return stringBuilder.toString();
        }
    }
}

