/*
 * Decompiled with CFR 0.152.
 */
package Jet.HMM;

import Jet.Lex.Tokenizer;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.DocumentCollection;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import Jet.Zoner.SentenceSplitter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;

public class BIOWriter {
    private static final String home = "C:/Documents and Settings/Ralph Grishman/My Documents/";
    private static final String xmlCollection = "C:/Documents and Settings/Ralph Grishman/My Documents/HMM/NE/ACE training Collection.txt";
    private static final String bioFile = "C:/Documents and Settings/Ralph Grishman/My Documents/HMM/NE/aceTrainingBIO.txt";
    private static final String[] tagsToRead = new String[]{"ENAMEX", "TIMEX", "NUMEX"};
    private static PrintStream writer;

    public static void main(String[] stringArray) throws IOException {
        BIOWriter.convertCollection(xmlCollection, bioFile);
    }

    public static void task(String[] stringArray) {
        if (stringArray.length != 3) {
            System.out.println("BIOWriter requires 2 arguments: jet -BIOWriter <XML-collection> <BIO-file>");
            System.exit(1);
        }
        String string = stringArray[1];
        String string2 = stringArray[2];
        try {
            BIOWriter.convertCollection(string, string2);
        }
        catch (IOException iOException) {
            System.out.println("BIOWriter IO error: " + iOException);
        }
    }

    public static void convertCollection(String string, String string2) throws IOException {
        DocumentCollection documentCollection = new DocumentCollection(string);
        writer = new PrintStream(new FileOutputStream(string2));
        documentCollection.open();
        for (int i = 0; i < documentCollection.size(); ++i) {
            ExternalDocument externalDocument = documentCollection.get(i);
            System.out.println("Processing document " + externalDocument.fileName());
            externalDocument.setSGMLtags(tagsToRead);
            externalDocument.open();
            externalDocument.annotateWithTag("text");
            Span span = externalDocument.annotationsOfType("text").get(0).span();
            BIOWriter.eraseAnnotationsOutside(externalDocument, "ENAMEX", span);
            BIOWriter.eraseAnnotationsOutside(externalDocument, "TIMEX", span);
            BIOWriter.eraseAnnotationsOutside(externalDocument, "NUMEX", span);
            SentenceSplitter.split(externalDocument, span);
            Vector<Annotation> vector = externalDocument.annotationsOfType("sentence");
            if (vector == null) continue;
            for (Annotation annotation : vector) {
                Span span2 = annotation.span();
                Tokenizer.tokenize(externalDocument, span2);
                BIOWriter.writeTags(externalDocument, span2);
            }
        }
    }

    private static void writeTags(Document document, Span span) {
        int n = span.start();
        int n2 = span.end();
        n = Tokenizer.skipWSX(document, n, n2);
        String string = "O";
        int n3 = 0;
        while (n < n2) {
            String string2;
            Annotation annotation = document.tokenAt(n);
            String string3 = document.text(annotation).trim();
            Vector<Annotation> vector = document.annotationsAt(n, "ENAMEX");
            if (vector != null && vector.size() > 0) {
                Annotation annotation2 = vector.get(0);
                String string4 = (String)annotation2.get("TYPE");
                if (n3 == 0) {
                    string2 = ("B-" + string4).intern();
                    string = ("I-" + string4).intern();
                    n3 = annotation2.span().end();
                } else {
                    System.out.println("Nested tag " + string4 + " ignored.");
                    System.out.println("(tag from annotation " + annotation2 + ")");
                    string2 = string;
                }
            } else {
                string2 = string;
            }
            writer.println(string3 + " " + string2);
            n = annotation.span().end();
            if (n3 != 0 && n > n3) {
                System.out.println("Annotation does not end at token boundary");
                System.out.println("(annotation ends at " + n3 + ", token boundary is " + n);
            }
            if (n < n3) continue;
            n3 = 0;
            string = "O";
        }
        if (n3 != 0) {
            System.out.println("Annotation extends past text [sentence] boundary");
            System.out.println("(annotation ends at " + n3 + ")");
        }
        writer.println();
    }

    private static void eraseAnnotationsOutside(Document document, String string, Span span) {
        Vector vector = document.annotationsOfType(string);
        if (vector == null) {
            return;
        }
        vector = (Vector)vector.clone();
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = (Annotation)vector.get(i);
            if (annotation.span().within(span)) continue;
            document.removeAnnotation(annotation);
        }
    }
}

