/*
 * Decompiled with CFR 0.152.
 */
package Jet.Format;

import Jet.Format.InvalidFormatException;
import Jet.Format.Treebank;
import Jet.Lisp.FeatureSet;
import Jet.Parser.HeadRule;
import Jet.Parser.ParseTreeNode;
import Jet.Parser.StatParser;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import Jet.Util.IOUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PTBReader {
    static Pattern tagNamePattern = Pattern.compile("([^-=]+) (?: - ([\\-a-zA-Z]+)*)? (?: [-=] ([\\-\\d]+))?", 4);
    static Pattern specialTagNamePattern = Pattern.compile("-.*-");
    private static final Map<String, String> TRANSFORM_TABLE = new HashMap<String, String>();
    private static final Set<String> PUNCTUATIONS;
    private static final Set<String> NO_FOLLOWING_SPACE;
    private static final Set<String> DELETE_PREVIOUS_SPACE;
    private boolean backslashAsEscapeChar = true;
    private boolean isAddingTokens = false;
    HeadRule hr = null;
    private static final String[] skip;
    private static final String[] match;
    List<Integer> offsets;
    private StringBuffer comment = new StringBuffer();
    private int offset = -1;

    public void addAnnotations(ParseTreeNode parseTreeNode, Document document, Span span, boolean bl) {
        List<ParseTreeNode> list = this.getTerminalNodes(parseTreeNode);
        String string = document.text();
        int n = span.start();
        for (ParseTreeNode parseTreeNode2 : list) {
            int n2;
            while (n < span.end() && Character.isWhitespace(string.charAt(n))) {
                ++n;
            }
            String[] stringArray = skip;
            int n3 = stringArray.length;
            for (int i = 0; i < n3; ++i) {
                String string2 = stringArray[i];
                if (!string.startsWith(string2, n)) continue;
                n += string2.length();
                while (n < span.end() && Character.isWhitespace(string.charAt(n))) {
                    ++n;
                }
                break;
            }
            if ((n2 = PTBReader.matchTextToTree(string, n, parseTreeNode2.word)) > 0) {
                for (n3 = n + n2; n3 < span.end() && Character.isWhitespace(string.charAt(n3)); ++n3) {
                }
                parseTreeNode2.start = n;
                parseTreeNode2.end = n3;
                n = n3;
                continue;
            }
            System.err.println("PTBReader.addAnnotations:  Cannot determine parse tree offset for word " + parseTreeNode2.word);
            System.err.println("  at document offset " + n + " in sentence");
            System.err.println("  " + document.text(span));
            return;
        }
        if (bl) {
            this.setJetAnnotations(parseTreeNode, span, document);
            StatParser.deleteUnusedConstits(document, span, parseTreeNode.ann);
        } else {
            this.determineNonTerminalSpans(parseTreeNode, span.start());
            this.setAnnotations(parseTreeNode, document);
        }
    }

    private static int matchTextToTree(String string, int n, String string2) {
        if (string2.equals("can") && string.startsWith("can't", n)) {
            return 2;
        }
        if (string2.equals("Can") && string.startsWith("Can't", n)) {
            return 2;
        }
        for (int i = 0; i < match.length; i += 2) {
            String string3 = match[i];
            String string4 = match[i + 1];
            if (!string.startsWith(string3, n) || !string2.equals(string4)) continue;
            return string3.length();
        }
        if (string.startsWith(string2, n)) {
            return string2.length();
        }
        if (string.startsWith("." + string2, n)) {
            return string2.length() + 1;
        }
        return -1;
    }

    public void addAnnotations(List<ParseTreeNode> list, Document document, String string, Span span, boolean bl) {
        Vector<Annotation> vector = document.annotationsOfType(string, span);
        Comparator<Annotation> comparator = new Comparator<Annotation>(){

            @Override
            public int compare(Annotation annotation, Annotation annotation2) {
                return annotation.span().compareTo(annotation2.span());
            }
        };
        Collections.sort(vector, comparator);
        if (list.size() != vector.size()) {
            System.err.println("PTBReader.addAnnotations:  mismatch between number of " + string + " (" + vector.size() + ") and number of trees (" + list.size() + ")");
        }
        int n = Math.min(list.size(), vector.size());
        for (int i = 0; i < n; ++i) {
            ParseTreeNode parseTreeNode = list.get(i);
            this.addAnnotations(parseTreeNode, document, ((Annotation)vector.get(i)).span(), bl);
            ((Annotation)vector.get(i)).put("parse", parseTreeNode.ann);
        }
    }

    public void addAnnotations(List<ParseTreeNode> list, List<Integer> list2, Document document, String string, Span span, boolean bl) {
        if (list.size() != list2.size()) {
            System.err.println("PTBReader.addAnnotations:  mismatch between number of trees (" + list.size() + ") and number of offsets (" + list2.size() + ")");
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            ParseTreeNode parseTreeNode = list.get(i);
            int n = list2.get(i);
            if (n < 0) {
                System.err.println("PTBReader.addAnnotations:  offset missing for  parse tree " + i);
                continue;
            }
            int n2 = i + 1 == list2.size() ? span.end() : list2.get(i + 1).intValue();
            Span span2 = new Span(n, n2);
            this.addAnnotations(parseTreeNode, document, span2, bl);
            Vector<Annotation> vector = document.annotationsAt(n, string);
            if (vector == null || vector.size() <= 0) continue;
            Annotation annotation = vector.get(0);
            annotation.put("parse", parseTreeNode.ann);
        }
    }

    public List<ParseTreeNode> loadParseTrees(Reader reader) throws IOException, InvalidFormatException {
        ArrayList<ParseTreeNode> arrayList = new ArrayList<ParseTreeNode>();
        this.offsets = new ArrayList<Integer>();
        PushbackReader pushbackReader = new PushbackReader(reader);
        while (true) {
            this.skipWhitespaceAndComment(pushbackReader);
            if (this.lookAhead(pushbackReader) == -1) break;
            this.offsets.add(this.offset);
            ParseTreeNode parseTreeNode = this.readNode(pushbackReader);
            arrayList.add(parseTreeNode);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ParseTreeNode> loadParseTrees(File file) throws IOException, InvalidFormatException {
        List<ParseTreeNode> list;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            list = this.loadParseTrees(bufferedReader);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedReader);
            throw throwable;
        }
        IOUtils.closeQuietly(bufferedReader);
        return list;
    }

    public List<Integer> getOffsets() {
        return this.offsets;
    }

    public Treebank load(Reader reader) throws IOException, InvalidFormatException {
        Object object;
        ArrayList<ParseTreeNode> arrayList = new ArrayList<ParseTreeNode>();
        PushbackReader pushbackReader = new PushbackReader(reader);
        int n = 0;
        while (true) {
            this.skipWhitespace(pushbackReader);
            if (this.lookAhead(pushbackReader) == -1) break;
            object = this.readNode(pushbackReader);
            arrayList.add((ParseTreeNode)object);
            this.determineSpans((ParseTreeNode)object, n);
            this.setAnnotations((ParseTreeNode)object, null);
            n = ((ParseTreeNode)object).end;
        }
        object = this.buildDocumentString(arrayList);
        Document document = new Document((String)object);
        for (ParseTreeNode parseTreeNode : arrayList) {
            document.annotate("sentence", new Span(parseTreeNode.start, parseTreeNode.end), new FeatureSet());
            this.annotate(document, parseTreeNode);
        }
        return new Treebank(document, arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Treebank load(File file) throws IOException, InvalidFormatException {
        Treebank treebank;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            treebank = this.load(bufferedReader);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedReader);
            throw throwable;
        }
        IOUtils.closeQuietly(bufferedReader);
        return treebank;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Treebank load(File file, String string) throws IOException, InvalidFormatException {
        Treebank treebank;
        FileInputStream fileInputStream = null;
        Reader reader = null;
        try {
            fileInputStream = new FileInputStream(file);
            reader = new InputStreamReader((InputStream)fileInputStream, string);
            reader = new BufferedReader(reader);
            treebank = this.load(reader);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly(fileInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(reader);
        IOUtils.closeQuietly(fileInputStream);
        return treebank;
    }

    public void setBackslashAsEscapeCharacter(boolean bl) {
        this.backslashAsEscapeChar = bl;
    }

    public void setAddingToken(boolean bl) {
        this.isAddingTokens = bl;
    }

    private static boolean isNullNode(ParseTreeNode parseTreeNode) {
        return parseTreeNode.category.equals("-none-");
    }

    private void modifyAnnotationEnd(List<Annotation> list, StringBuilder stringBuilder) {
        Annotation annotation;
        ListIterator<Annotation> listIterator = list.listIterator(list.size());
        if (stringBuilder.length() == 0) {
            return;
        }
        if (!Character.isWhitespace(stringBuilder.charAt(stringBuilder.length() - 1))) {
            return;
        }
        while (listIterator.hasPrevious() && (annotation = listIterator.previous()).end() == stringBuilder.length()) {
            Span span = new Span(annotation.start(), annotation.end() - 1);
            Annotation annotation2 = new Annotation(annotation.type(), span, annotation.attributes());
            listIterator.set(annotation2);
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
    }

    private ParseTreeNode readNode(PushbackReader pushbackReader) throws IOException, InvalidFormatException {
        ParseTreeNode parseTreeNode;
        int n = pushbackReader.read();
        if (n != 40) {
            throw new InvalidFormatException();
        }
        n = this.lookAhead(pushbackReader);
        if (n == -1) {
            throw new InvalidFormatException();
        }
        if (Character.isWhitespace(n) || n == 40) {
            this.skipWhitespace(pushbackReader);
            ParseTreeNode parseTreeNode2 = this.readNode(pushbackReader);
            this.skipWhitespace(pushbackReader);
            n = (char)pushbackReader.read();
            if (n != 41) {
                throw new InvalidFormatException();
            }
            return parseTreeNode2;
        }
        String string = this.readTagName(pushbackReader);
        String string2 = null;
        Matcher matcher = tagNamePattern.matcher(string);
        if (matcher.matches()) {
            string = matcher.group(1);
            string2 = matcher.group(2);
        } else if (!specialTagNamePattern.matcher(string).matches()) {
            throw new InvalidFormatException(string + " is invalid format.");
        }
        if (this.skipWhitespace(pushbackReader) == 0) {
            return null;
        }
        if (this.lookAhead(pushbackReader) == 40) {
            ArrayList<ParseTreeNode> arrayList = new ArrayList<ParseTreeNode>();
            do {
                ParseTreeNode parseTreeNode3;
                if (!PTBReader.isNullNode(parseTreeNode3 = this.readNode(pushbackReader))) {
                    arrayList.add(parseTreeNode3);
                }
                this.skipWhitespace(pushbackReader);
            } while (this.lookAhead(pushbackReader) != 41);
            parseTreeNode = new ParseTreeNode((Object)string, arrayList.toArray(new ParseTreeNode[0]), 0, 0, 0, string2);
        } else {
            String string3 = this.readWord(pushbackReader);
            parseTreeNode = new ParseTreeNode(string, null, 0, 0, null, string3, string2);
        }
        this.skipWhitespace(pushbackReader);
        if (pushbackReader.read() != 41) {
            throw new InvalidFormatException();
        }
        return parseTreeNode;
    }

    private int skipWhitespace(PushbackReader pushbackReader) throws IOException {
        int n;
        int n2 = 0;
        do {
            n = pushbackReader.read();
            ++n2;
        } while (Character.isWhitespace(n) && n != -1);
        if (n != -1) {
            pushbackReader.unread(n);
        }
        return n2 - 1;
    }

    private int skipWhitespaceAndComment(PushbackReader pushbackReader) throws IOException {
        int n;
        int n2 = 0;
        boolean bl = false;
        this.offset = -1;
        do {
            n = pushbackReader.read();
            ++n2;
            if (n == 35 && !bl) {
                bl = true;
                this.comment.setLength(0);
                continue;
            }
            if (n == 10 && bl) {
                try {
                    this.offset = Integer.parseInt(this.comment.toString().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                bl = false;
                continue;
            }
            if (!bl) continue;
            this.comment.append((char)n);
        } while ((Character.isWhitespace(n) || bl) && n != -1);
        if (n != -1) {
            pushbackReader.unread(n);
        }
        return n2 - 1;
    }

    private String readTagName(PushbackReader pushbackReader) throws IOException, InvalidFormatException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            if ((n = pushbackReader.read()) == -1) {
                throw new InvalidFormatException();
            }
            if (Character.isWhitespace(n)) break;
            stringBuilder.append((char)n);
        }
        pushbackReader.unread(n);
        if (stringBuilder.length() == 0) {
            throw new InvalidFormatException();
        }
        return stringBuilder.toString().toLowerCase().intern();
    }

    private String readWord(PushbackReader pushbackReader) throws IOException, InvalidFormatException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            if ((n = pushbackReader.read()) != -1 && this.backslashAsEscapeChar && n == 92) {
                n = pushbackReader.read();
            }
            if (n == 41) break;
            if (n == -1) {
                throw new InvalidFormatException();
            }
            stringBuilder.append((char)n);
        }
        pushbackReader.unread(n);
        String string = stringBuilder.toString();
        if (TRANSFORM_TABLE.containsKey(string)) {
            string = TRANSFORM_TABLE.get(string);
        }
        return string;
    }

    private int lookAhead(PushbackReader pushbackReader) throws IOException {
        int n = pushbackReader.read();
        if (n != -1) {
            pushbackReader.unread(n);
        }
        return n;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 2) {
            System.out.println("usage: java " + PTBReader.class.getName() + " ");
            System.exit(1);
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        PTBReader pTBReader = new PTBReader();
        for (File file3 : PTBReader.getFiles(new File(stringArray[0]), ".mrg")) {
            String string = PTBReader.removeSuffix(PTBReader.getRelativePath(file, file3));
            File file4 = new File(file2, string);
            file4.getParentFile().mkdirs();
            FileWriter fileWriter = new FileWriter(file4);
            Document document = pTBReader.load(file3).getDocument();
            fileWriter.write(document.text());
            ((Writer)fileWriter).close();
        }
    }

    private static List<File> getFiles(File file, String string) throws IOException {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file2 : file.listFiles()) {
            if (file2.isFile() && file2.getName().endsWith(string)) {
                arrayList.add(file2);
                continue;
            }
            if (!file2.isDirectory()) continue;
            arrayList.addAll(PTBReader.getFiles(file2, string));
        }
        return arrayList;
    }

    private static String getRelativePath(File file, File file2) {
        return file2.getAbsolutePath().substring(file.getAbsolutePath().length());
    }

    private static String removeSuffix(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return string.substring(0, n);
        }
        return string;
    }

    private String buildDocumentString(List<ParseTreeNode> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ParseTreeNode parseTreeNode : list) {
            List<ParseTreeNode> list2 = this.getTerminalNodes(parseTreeNode);
            for (ParseTreeNode parseTreeNode2 : list2) {
                if (parseTreeNode2.word == null) continue;
                stringBuilder.append(parseTreeNode2.word);
                while (stringBuilder.length() < parseTreeNode2.end) {
                    stringBuilder.append(' ');
                }
            }
            if (stringBuilder.charAt(stringBuilder.length() - 1) != ' ') continue;
            stringBuilder.setCharAt(stringBuilder.length() - 1, '\n');
        }
        return stringBuilder.toString();
    }

    private void determineSpans(ParseTreeNode parseTreeNode, int n) {
        List<ParseTreeNode> list = this.getTerminalNodes(parseTreeNode);
        this.determineTerminalSpans(list, n);
        this.determineNonTerminalSpans(parseTreeNode, n);
    }

    private void determineTerminalSpans(List<ParseTreeNode> list, int n) {
        int n2 = n;
        int n3 = list.size();
        for (int i = 0; i < n3; ++i) {
            ParseTreeNode parseTreeNode = list.get(i);
            ParseTreeNode parseTreeNode2 = i > 0 ? list.get(i - 1) : null;
            String string = parseTreeNode.word;
            int n4 = n2 + (string != null ? string.length() + 1 : 0);
            if (!this.hasAfterSpace(string)) {
                --n4;
            }
            if (this.hasBeforeSpace(string) && parseTreeNode2 != null && this.hasAfterSpace(parseTreeNode2.word)) {
                --parseTreeNode2.end;
            }
            parseTreeNode.start = --n2;
            parseTreeNode.end = --n4;
            n2 = n4;
        }
    }

    private int determineNonTerminalSpans(ParseTreeNode parseTreeNode, int n) {
        if (this.isTerminalNode(parseTreeNode)) {
            return parseTreeNode.end;
        }
        ParseTreeNode[] parseTreeNodeArray = parseTreeNode.children;
        if (parseTreeNodeArray.length > 0) {
            for (ParseTreeNode parseTreeNode2 : parseTreeNodeArray) {
                n = this.determineNonTerminalSpans(parseTreeNode2, n);
            }
            parseTreeNode.start = parseTreeNodeArray[0].start;
            parseTreeNode.end = parseTreeNodeArray[parseTreeNodeArray.length - 1].end;
        } else {
            parseTreeNode.start = n;
            parseTreeNode.end = n;
        }
        return parseTreeNode.end;
    }

    private boolean hasAfterSpace(String string) {
        return !NO_FOLLOWING_SPACE.contains(string);
    }

    private boolean hasBeforeSpace(String string) {
        if (DELETE_PREVIOUS_SPACE.contains(string)) {
            return true;
        }
        return this.isPartOfShortenedForm(string);
    }

    private boolean isPartOfShortenedForm(String string) {
        if (string != null) {
            return string.startsWith("'") || string.equals("n't");
        }
        return false;
    }

    private void annotate(Document document, ParseTreeNode parseTreeNode) {
        document.addAnnotation(parseTreeNode.ann);
        if (parseTreeNode.children != null) {
            Annotation[] annotationArray = new Annotation[parseTreeNode.children.length];
            for (int i = 0; i < parseTreeNode.children.length; ++i) {
                annotationArray[i] = parseTreeNode.children[i].ann;
            }
            parseTreeNode.ann.put("children", annotationArray);
            for (ParseTreeNode parseTreeNode2 : parseTreeNode.children) {
                this.annotate(document, parseTreeNode2);
            }
        }
        if (parseTreeNode.children == null && this.isAddingTokens) {
            document.annotate("token", parseTreeNode.ann.span(), new FeatureSet());
        }
    }

    private List<ParseTreeNode> getTerminalNodes(ParseTreeNode parseTreeNode) {
        if (parseTreeNode.children == null || parseTreeNode.children.length == 0) {
            if (parseTreeNode.word != null) {
                return Collections.singletonList(parseTreeNode);
            }
            return Collections.emptyList();
        }
        ArrayList<ParseTreeNode> arrayList = new ArrayList<ParseTreeNode>();
        for (ParseTreeNode parseTreeNode2 : parseTreeNode.children) {
            arrayList.addAll(this.getTerminalNodes(parseTreeNode2));
        }
        return arrayList;
    }

    private boolean isTerminalNode(ParseTreeNode parseTreeNode) {
        return parseTreeNode.children == null;
    }

    private void setAnnotations(ParseTreeNode parseTreeNode, Document document) {
        Span span = new Span(parseTreeNode.start, parseTreeNode.end);
        FeatureSet featureSet = new FeatureSet();
        featureSet.put("cat", parseTreeNode.category);
        if (parseTreeNode.head != 0) {
            featureSet.put("head", parseTreeNode.head);
        }
        if (parseTreeNode.function != null) {
            featureSet.put("func", parseTreeNode.function);
        }
        parseTreeNode.ann = new Annotation("constit", span, featureSet);
        if (document != null) {
            document.addAnnotation(parseTreeNode.ann);
        }
        if (parseTreeNode.children != null) {
            for (ParseTreeNode parseTreeNode2 : parseTreeNode.children) {
                this.setAnnotations(parseTreeNode2, document);
            }
        }
    }

    private void setJetAnnotations(ParseTreeNode parseTreeNode, Span span, Document document) {
        StatParser.buildParserInput(document, span.start(), span.end(), false);
        StatParser.fixHyphenatedItems(document);
        int n = -1;
        List<ParseTreeNode> list = this.getTerminalNodes(parseTreeNode);
        for (ParseTreeNode parseTreeNode2 : list) {
            int n2 = parseTreeNode2.end;
            Vector<Annotation> vector = document.annotationsAt(parseTreeNode2.start, "constit");
            Annotation object = null;
            Annotation annotation = null;
            Annotation object2 = null;
            if (vector != null) {
                for (Annotation annotation2 : vector) {
                    if (annotation2.get("cat") == "name") {
                        annotation = annotation2;
                    } else if (annotation2.get("cat") == "hyphword") {
                        object2 = annotation2;
                    }
                    if (object != null) continue;
                    object = annotation2;
                }
            }
            if (object2 != null) {
                annotation = null;
                object = object2;
            }
            if (annotation != null) {
                parseTreeNode2.end = annotation.end();
                parseTreeNode2.ann = annotation;
                n = annotation.end();
            } else if (n >= 0) {
                parseTreeNode2.word = null;
            } else {
                Span span2 = new Span(parseTreeNode2.start, parseTreeNode2.end);
                String string = ((String)parseTreeNode2.category).toUpperCase().intern();
                String string2 = parseTreeNode2.word;
                parseTreeNode2.ann = StatParser.buildWordDefn(document, string2, span2, object, string);
            }
            if (n != n2) continue;
            n = -1;
        }
        this.pruneTree(parseTreeNode);
        this.determineNonTerminalSpans(parseTreeNode, span.start());
        if (this.hr == null) {
            this.hr = HeadRule.createDefaultRule();
        }
        this.hr.apply(parseTreeNode);
        ParseTreeNode.makeParseAnnotations(document, parseTreeNode);
    }

    private ParseTreeNode pruneTree(ParseTreeNode parseTreeNode) {
        Object object = parseTreeNode.children;
        if (object != null) {
            ArrayList<ParseTreeNode> arrayList = new ArrayList<ParseTreeNode>();
            for (ParseTreeNode parseTreeNode2 : object) {
                ParseTreeNode parseTreeNode3 = this.pruneTree(parseTreeNode2);
                if (parseTreeNode3 == null) continue;
                arrayList.add(parseTreeNode3);
            }
            object = arrayList.isEmpty() ? null : arrayList.toArray(new ParseTreeNode[0]);
            parseTreeNode.children = object;
        }
        if (parseTreeNode.word == null && object == null) {
            return null;
        }
        return parseTreeNode;
    }

    static {
        TRANSFORM_TABLE.put("-LRB-", "(");
        TRANSFORM_TABLE.put("-LCB-", "{");
        TRANSFORM_TABLE.put("-LSB-", "[");
        TRANSFORM_TABLE.put("-RRB-", ")");
        TRANSFORM_TABLE.put("-RCB-", "}");
        TRANSFORM_TABLE.put("-RSB-", "]");
        PUNCTUATIONS = new HashSet<String>();
        PUNCTUATIONS.add(".");
        PUNCTUATIONS.add(",");
        PUNCTUATIONS.add("?");
        PUNCTUATIONS.add("!");
        NO_FOLLOWING_SPACE = new HashSet<String>();
        NO_FOLLOWING_SPACE.add("(");
        NO_FOLLOWING_SPACE.add("{");
        NO_FOLLOWING_SPACE.add("[");
        DELETE_PREVIOUS_SPACE = new HashSet<String>();
        DELETE_PREVIOUS_SPACE.add(")");
        DELETE_PREVIOUS_SPACE.add("}");
        DELETE_PREVIOUS_SPACE.add("]");
        DELETE_PREVIOUS_SPACE.add(".");
        DELETE_PREVIOUS_SPACE.add(",");
        skip = new String[]{"....", "...", "uh,", "Uh,", "um,", "Um,", "&lt;", "&LT;", "&gt;", "&GT;", "_"};
        match = new String[]{"\"", "``", "\"", "''", "&quot;", "``", "&quot;", "''", "&QUOT;", "``", "&QUOT;", "''", "&amp;", "&", "&AMP;", "&", "wo", "will", "Wo", "Will", "((", "(", "))", ")"};
    }
}

