/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.AceDocument;
import AceJet.AceEvent;
import AceJet.AceEventMention;
import AceJet.AceEventMentionArgument;
import AceJet.AceValue;
import AceJet.AceValueMention;
import Jet.JetTest;
import Jet.Parser.SynFun;
import Jet.Refres.Resolve;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindAceValues {
    static final Logger logger = LoggerFactory.getLogger(FindAceValues.class);
    static TreeMap<String, String> valueTypeMap = new TreeMap();

    public static void readTypeDict() {
        String string = JetTest.getConfigFile("Ace.Value.fileName");
        if (string != null) {
            FindAceValues.readTypeDict(string);
        } else {
            logger.error("No Ace.Value.fileName specified in config file");
        }
    }

    public static void readTypeDict(String string) {
        logger.info("Loading type dictionary {}", (Object)string);
        valueTypeMap = new TreeMap();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string3 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.trim().length() == 0 || string2.charAt(0) == '#') continue;
                if (string2.charAt(0) == '=') {
                    string3 = string2.substring(1);
                    continue;
                }
                String[] stringArray = string2.split(" ");
                if (string3 == null) {
                    logger.warn("Error in loading value dictionary.");
                    logger.warn("No type specified for {}", (Object)stringArray[0]);
                    continue;
                }
                valueTypeMap.put(stringArray[0], string3);
            }
            logger.info("Value dictionary loaded.");
        }
        catch (IOException iOException) {
            logger.error("Unable to load value dictionary due to exception: {}", iOException);
        }
    }

    public static boolean isDictLoaded() {
        return !valueTypeMap.isEmpty();
    }

    public static String getTypeSubtype(Document document, Annotation annotation) {
        String string = SynFun.getHead(document, annotation).toLowerCase();
        Annotation annotation2 = Resolve.getHeadC(annotation);
        String string2 = Resolve.normalizeName(document.text(annotation2).trim());
        String string3 = SynFun.getName(document, annotation);
        String string4 = (String)annotation2.get("cat");
        if (string3 != null) {
            if (string.equals("email")) {
                return "Contact-Info:E-Mail";
            }
            if (string.equals("url")) {
                return "Contact-Info:URL";
            }
            return "OTHER";
        }
        if (string4.equals("pro") || string4.equals("det") || string4.equals("q")) {
            return "OTHER";
        }
        String string5 = FindAceValues.lookUpValueType(string2);
        if (string5 != null) {
            return string5.intern();
        }
        string5 = FindAceValues.lookUpValueType(string);
        if (string5 != null) {
            return string5.intern();
        }
        return "OTHER";
    }

    static String lookUpValueType(String string) {
        return valueTypeMap.get(string.toLowerCase());
    }

    public static String bareType(String string) {
        int n = string.indexOf(58);
        if (n > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    static String subtype(String string) {
        int n = string.indexOf(58);
        if (n > 0) {
            return string.substring(n + 1);
        }
        return "";
    }

    public static void buildAceValues(Document document, String string, AceDocument aceDocument) {
        int n = 0;
        String string2 = document.text();
        Vector<Annotation> vector = document.annotationsOfType("entity");
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Annotation annotation = vector.get(i);
                Vector vector2 = (Vector)annotation.get("mentions");
                for (int j = 0; j < vector2.size(); ++j) {
                    Annotation annotation2 = (Annotation)vector2.get(j);
                    String string3 = FindAceValues.getTypeSubtype(document, annotation2);
                    if (string3.equals("OTHER")) continue;
                    String string4 = string + "-V" + ++n;
                    FindAceValues.buildAceValue(string4, string3, annotation2.span(), aceDocument, string2);
                }
            }
        }
        logger.info("Built {} values.", (Object)aceDocument.values.size());
    }

    public static void buildAceValue(String string, String string2, Span span, AceDocument aceDocument, String string3) {
        String string4 = FindAceValues.bareType(string2);
        String string5 = FindAceValues.subtype(string2);
        AceValueMention aceValueMention = new AceValueMention(string + "-1", span, string3);
        AceValue aceValue = new AceValue(string, string4, string5);
        aceValue.addMention(aceValueMention);
        aceDocument.addValue(aceValue);
    }

    public static void pruneAceValues(AceDocument aceDocument) {
        ArrayList<AceValue> arrayList = aceDocument.values;
        HashSet<AceValue> hashSet = new HashSet<AceValue>();
        for (AceEvent object : aceDocument.events) {
            for (AceEventMention aceEventMention : object.mentions) {
                for (AceEventMentionArgument aceEventMentionArgument : aceEventMention.arguments) {
                    if (!(aceEventMentionArgument.value instanceof AceValueMention)) continue;
                    AceValue aceValue = ((AceValueMention)aceEventMentionArgument.value).value;
                    hashSet.add(aceValue);
                }
            }
        }
        for (AceValue aceValue : arrayList) {
            String string = aceValue.type;
            if (!string.equals("Numeric") && !string.equals("Contact-Info")) continue;
            hashSet.add(aceValue);
        }
        arrayList.retainAll(hashSet);
        logger.info("{} values remain after pruning.", (Object)aceDocument.values.size());
    }
}

