/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.Ace;
import AceJet.AceDocument;
import AceJet.AceEntityMention;
import AceJet.EDTtypeData;
import AceJet.LearnRelations;
import AceJet.NameSubtyper;
import AceJet.PerfectAce;
import Jet.Control;
import Jet.JetTest;
import Jet.Lex.EnglishLex;
import Jet.Lisp.FeatureSet;
import Jet.Parser.SynFun;
import Jet.Pat.Pat;
import Jet.Refres.Resolve;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

public class EDTtype {
    static ExternalDocument doc;
    static boolean monocase;
    static PrintStream writer;
    static PrintStream gwriter;
    static TreeMap<String, EDTtypeData> typeDataMap;
    static TreeSet<String> genericHeads;
    static int trainingMentions;
    static int correct;
    static int incorrect;
    static int unknown;
    static String apfFileSuffix;
    static String dataDir;
    static boolean useSubtype;
    private static final String[] partitives;
    private static final String[] governmentTitles;
    static HashMap<String, String> specifiedEDTtype;

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length < 7 || (stringArray.length - 3) % 4 != 0) {
            System.err.println("EDTtype must have 4n+3 arguments:");
            System.err.print("  property-file type-dict generic-dict ");
            System.err.print("(year useSubtypes directory filelist)+");
            System.exit(1);
        }
        System.out.println("Starting ACE EDT Type / Generic Training ...");
        JetTest.initializeFromConfig(stringArray[0]);
        Pat.trace = false;
        Resolve.ACE = true;
        writer = new PrintStream(new FileOutputStream(stringArray[1]));
        gwriter = new PrintStream(new FileOutputStream(stringArray[2]));
        for (int i = 3; i < stringArray.length; i += 4) {
            String string = stringArray[i];
            useSubtype = !stringArray[i + 1].equals("-");
            String string2 = stringArray[i + 2];
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
            String string3 = stringArray[i + 3];
            if (string.equals("2002")) {
                AceDocument.ace2004 = false;
                AceDocument.ace2005 = false;
                apfFileSuffix = ".sgm.tmx.rdc.xml";
            } else if (string.equals("2003")) {
                AceDocument.ace2004 = false;
                AceDocument.ace2005 = false;
                apfFileSuffix = ".apf.xml";
            } else if (string.equals("2004")) {
                AceDocument.ace2004 = true;
                AceDocument.ace2005 = false;
                apfFileSuffix = ".apf.xml";
            } else if (string.equals("2005")) {
                AceDocument.ace2004 = true;
                AceDocument.ace2005 = true;
                apfFileSuffix = ".apf.xml";
            } else {
                System.err.println("Invalid year " + string + " in argument list.");
                System.err.println("(Only 2002 - 2005 allowed.)");
                System.exit(1);
            }
            EDTtype.trainFromFileList(string2, string3);
        }
        EDTtype.writeTypeDict(writer);
        EDTtype.writeGenericDict(gwriter);
        EDTtypeData.reportSubtypeTotals();
        System.out.println(trainingMentions + " training mentions");
        System.out.println(correct + " correct predictions, " + incorrect + " incorrect");
        System.out.println(unknown + " unknown");
    }

    static void trainFromFileList(String string, String string2) throws IOException {
        String string3;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
        int n = 0;
        while ((string3 = bufferedReader.readLine()) != null) {
            System.out.println("\nProcessing document " + ++n + ": " + string3);
            String string4 = string + string3 + ".sgm";
            doc = new ExternalDocument("sgml", string4);
            doc.setAllTags(true);
            if (!AceDocument.ace2005) {
                doc.setEmptyTags(new String[]{"W", "TURN"});
            }
            doc.open();
            Ace.monocase = Ace.allLowerCase(doc);
            Control.processDocument(doc, null, false, n);
            String string5 = string + string3 + apfFileSuffix;
            AceDocument aceDocument = new AceDocument(string4, string5);
            LearnRelations.findEntityMentions(aceDocument);
            EDTtype.processMentions(doc);
        }
    }

    static void processMentions(ExternalDocument externalDocument) {
        Vector<Annotation> vector = Resolve.gatherMentions(externalDocument, new Span(0, externalDocument.length()));
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            boolean bl;
            Annotation annotation = vector.get(i);
            Annotation annotation2 = Resolve.getHeadC(annotation);
            String string = (String)annotation2.get("cat");
            if (string.equals("pro") || string.equals("det") || string.equals("name")) continue;
            String string2 = Resolve.normalizeName(externalDocument.text(annotation2));
            if (monocase) {
                string2 = string2.toLowerCase();
            }
            AceEntityMention aceEntityMention = (AceEntityMention)LearnRelations.mentionStartMap.get(new Integer(annotation2.start()));
            String string3 = "OTHER";
            String string4 = "";
            if (aceEntityMention != null) {
                string3 = aceEntityMention.entity.type;
                string4 = aceEntityMention.entity.subtype;
            }
            if (!useSubtype) {
                string4 = "*";
            }
            boolean bl2 = bl = trainingMentions < 200000;
            if (bl) {
                ++trainingMentions;
                object = typeDataMap.get(string2);
                if (object == null) {
                    object = new EDTtypeData(string2);
                    typeDataMap.put(string2, (EDTtypeData)object);
                }
                ((EDTtypeData)object).incrementTypeCount(string3, string4, 1);
                if (aceEntityMention == null) continue;
                ((EDTtypeData)object).incrementGenericCount(aceEntityMention.entity.generic);
                continue;
            }
            object = EDTtype.bareType(EDTtype.getTypeSubtype(externalDocument, null, annotation));
            if (((String)object).equals(string3)) {
                ++correct;
                continue;
            }
            ++incorrect;
            System.out.print("Word: " + string2);
            System.out.println(" predict " + (String)object + ", should be " + string3);
        }
    }

    static void writeTypeDict(PrintStream printStream) {
        Iterator<EDTtypeData> iterator = typeDataMap.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().write(printStream);
        }
        printStream.close();
    }

    public static void readTypeDict() {
        File file;
        typeDataMap = new TreeMap();
        String string = JetTest.getConfigFile("Ace.EDTtype.fileName");
        if (string != null) {
            EDTtype.readTypeDict(string);
        } else {
            System.err.println("EDTtype.readTypeDict:  no file name specified in config file");
        }
        String string2 = JetTest.getConfigFile("Ace.EDTtype.auxFileName");
        if (string2 != null && (file = new File(string2)).exists() && !file.isDirectory()) {
            EDTtype.readTypeDict(string2);
        }
    }

    public static void readTypeDict(String string) {
        System.err.println("Loading type dictionary " + string);
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                EDTtypeData eDTtypeData = EDTtypeData.readLine(string2);
                if (eDTtypeData == null) continue;
                typeDataMap.put(eDTtypeData.word, eDTtypeData);
            }
            System.err.println("Type dictionary loaded.");
        }
        catch (IOException iOException) {
            System.err.print("Unable to load dictionary due to exception: ");
            System.err.println(iOException);
        }
    }

    public static boolean isDictLoaded() {
        return !typeDataMap.isEmpty();
    }

    static void writeGenericDict(PrintStream printStream) {
        for (EDTtypeData eDTtypeData : typeDataMap.values()) {
            if (eDTtypeData.genericCount <= 0 && eDTtypeData.nonGenericCount <= 0) continue;
            printStream.println(eDTtypeData.word + " | " + eDTtypeData.genericCount + " " + eDTtypeData.nonGenericCount);
        }
        printStream.close();
    }

    public static void emptyGenericDict() {
        genericHeads = new TreeSet();
    }

    public static void readGenericDict() {
        String string = JetTest.getConfigFile("Ace.generic.fileName");
        if (string != null) {
            EDTtype.readGenericDict(string);
        } else {
            System.err.println("EDTtype.readGenericDict:  no file name specified in config file");
        }
    }

    public static void readGenericDict(String string) {
        System.err.println("Loading generic dictionary.");
        genericHeads = new TreeSet();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                int n;
                int n2 = string2.indexOf(124);
                if (n2 <= 1) {
                    System.err.println("** error in generic dict: " + string2);
                    return;
                }
                String string3 = string2.substring(0, n2 - 1);
                String string4 = string2.substring(n2 + 2);
                StringTokenizer stringTokenizer = new StringTokenizer(string4);
                String string5 = stringTokenizer.nextToken();
                String string6 = stringTokenizer.nextToken();
                int n3 = Integer.valueOf(string5);
                if (n3 <= (n = Integer.valueOf(string6).intValue()) || n3 + n <= 2) continue;
                genericHeads.add(string3);
            }
            System.err.println("Generic dictionary loaded.");
        }
        catch (IOException iOException) {
            System.err.print("Unable to load dictionary due to exception: ");
            System.err.println(iOException);
        }
    }

    public static boolean hasGenericHead(Document document, Annotation annotation) {
        Annotation annotation2 = Resolve.getHeadC(annotation);
        String string = Resolve.normalizeName(document.text(annotation2).trim());
        return genericHeads.contains(string);
    }

    public static String getTypeSubtype(Document document, Annotation annotation, Annotation annotation2) {
        Object object;
        String string;
        String string2 = SynFun.getHead(document, annotation2).toLowerCase();
        String string3 = SynFun.getDet(annotation2);
        boolean bl = SynFun.getHuman(annotation2);
        Annotation annotation3 = Resolve.getHeadC(annotation2);
        if (Ace.perfectMentions) {
            string = PerfectAce.getTypeSubtype(annotation3);
            if (string != null && !string.equals("")) {
                return string;
            }
            System.err.println("*** no type info for " + document.text(annotation3));
        }
        if ((string = EDTtype.getGazetteerTypeSubtype(document, annotation2)) != null) {
            return string;
        }
        String string4 = Resolve.normalizeName(document.text(annotation3).trim());
        String string5 = SynFun.getName(document, annotation2);
        String string6 = (String)annotation3.get("cat");
        if (string6 == null) {
            string6 = "nn";
        }
        if (string5 != null) {
            if (string2 == null || string2.equalsIgnoreCase("otherName") || string2.equals("url")) {
                return "OTHER";
            }
            if (string2.equals("email")) {
                return AceDocument.ace2005 ? EDTtype.typeAndSubtype("PERSON", "Individual") : "PERSON";
            }
            String string7 = string2.toUpperCase().intern();
            if (EDTtype.sectionOfGPE(document, annotation2, string7, annotation3)) {
                return EDTtype.typeAndSubtype("LOCATION", AceDocument.ace2005 ? "Region-General" : "Region-National");
            }
            String string8 = null;
            Object object2 = SynFun.getPA(annotation2);
            if (object2 != null && object2 instanceof FeatureSet) {
                string8 = (String)((FeatureSet)object2).get("subtype");
            }
            if (string8 == null) {
                string8 = NameSubtyper.classify(string5, string7);
            }
            return EDTtype.typeAndSubtype(string7, string8);
        }
        if (EDTtype.in(string2, partitives) || annotation3.get("cat") == "q") {
            for (object = annotation2; object != null && ((Annotation)object).get("of") == null; object = (Annotation)((Annotation)object).get("headC")) {
            }
            if (object != null) {
                String string9;
                Annotation annotation4 = (Annotation)((Annotation)object).get("of");
                if (Ace.entityTrace) {
                    System.out.println("Using computed type for " + string2);
                }
                if (EDTtype.bareType(string9 = EDTtype.getTypeSubtype(document, null, annotation4)).equals("GPE") && (string2.equals("part") || string2.equals("portion"))) {
                    string9 = AceDocument.ace2005 ? "LOCATION:Region-General" : "LOCATION:Region-Subnational";
                }
                return string9;
            }
        }
        if (string6.equals("pro") || string6.equals("det") || string6.equals("q")) {
            return "OTHER";
        }
        object = EDTtype.handCodedEDTtype(string3, string4);
        if (object != null) {
            return object;
        }
        object = EDTtype.lookUpEDTtype(string4.toLowerCase());
        if (object != null) {
            return ((String)object).intern();
        }
        object = EDTtype.lookUpEDTtype(string2);
        if (object != null) {
            return ((String)object).replaceAll("Individual", "Group").intern();
        }
        String[] stringArray = new String[]{string2};
        String[] stringArray2 = EnglishLex.nounPlural(stringArray);
        object = EDTtype.lookUpEDTtype(stringArray2[0]);
        if (object != null) {
            return ((String)object).replaceAll("Group", "Individual").intern();
        }
        if (Ace.preferRelations && (bl || annotation != null && annotation.get("human") == "t")) {
            return "PERSON:Individual";
        }
        ++unknown;
        return "OTHER";
    }

    private static String getGazetteerTypeSubtype(Document document, Annotation annotation) {
        if (Ace.gazetteer == null) {
            return null;
        }
        String[] stringArray = Resolve.getHeadTokens(document, annotation);
        if (annotation.get("cat") == "np") {
            if (Ace.gazetteer.isNational(stringArray)) {
                return AceDocument.ace2005 ? "PERSON:Individual" : "PERSON";
            }
            if (Ace.gazetteer.isNationals(stringArray)) {
                return AceDocument.ace2005 ? "PERSON:Group" : "PERSON";
            }
        } else if (Ace.gazetteer.isNationality(stringArray)) {
            return "GPE:Nation";
        }
        return null;
    }

    private static boolean sectionOfGPE(Document document, Annotation annotation, String string, Annotation annotation2) {
        int n;
        if (string != "GPE") {
            return false;
        }
        int n2 = annotation.start();
        if (n2 == (n = annotation2.start())) {
            return false;
        }
        String string2 = document.text(new Span(n2, n));
        if (string2.contains("north") || string2.contains("south") || string2.contains("east") || string2.contains("west") || string2.contains("central")) {
            annotation.put("nameWithModifier", "t");
            return true;
        }
        return false;
    }

    static String handCodedEDTtype(String string, String string2) {
        String string3 = specifiedEDTtype.get(string2);
        if (string3 == null) {
            return null;
        }
        if (string == null) {
            return "OTHER";
        }
        return string3;
    }

    static String lookUpEDTtype(String string) {
        if (string == null) {
            return null;
        }
        EDTtypeData eDTtypeData = typeDataMap.get(string.toLowerCase());
        if (eDTtypeData == null) {
            return null;
        }
        return eDTtypeData.getBestTypeSubtype();
    }

    private static boolean in(Object object, Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null || !objectArray[i].equals(object)) continue;
            return true;
        }
        return false;
    }

    public static String bareType(String string) {
        int n = string.indexOf(58);
        if (n > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    static String subtype(String string) {
        int n = string.indexOf(58);
        if (n > 0) {
            return string.substring(n + 1);
        }
        return "";
    }

    static String typeAndSubtype(String string, String string2) {
        return string.toUpperCase() + ":" + string2;
    }

    static {
        typeDataMap = new TreeMap();
        trainingMentions = 0;
        correct = 0;
        incorrect = 0;
        unknown = 0;
        partitives = new String[]{"group", "part", "member", "portion", "center", "bunch", "couple", "remainder", "rest", "lot", "percent", "%", "dozen", "hundred", "thousand", "some", "either", "neither", "any", "each", "all", "both", "none", "most", "many", "afew", "one", "q"};
        governmentTitles = new String[]{"Vice-President", "Vice-Premier", "Prime-Minister", "Foreign-Minister", "Foreign-Secretary", "Secretary-of-State", "Attorney-General", "Justice-Minister", "Secretary-General"};
        specifiedEDTtype = new HashMap();
        specifiedEDTtype.put("force", "ORGANIZATION:Government");
        specifiedEDTtype.put("board", "ORGANIZATION:Commercial");
        specifiedEDTtype.put("prison", "FACILITY:" + (AceDocument.ace2005 ? "Building-Grounds" : "Building"));
        specifiedEDTtype.put("room", "FACILITY:" + (AceDocument.ace2005 ? "Subarea-Facility" : "Subarea-Building"));
        specifiedEDTtype.put("home", "FACILITY:" + (AceDocument.ace2005 ? "Building-Grounds" : "Building"));
        specifiedEDTtype.put("state", "GPE:State-or-Province");
        specifiedEDTtype.put("land", "LOCATION:" + (AceDocument.ace2005 ? "Region-General" : "Region-Subnational"));
        specifiedEDTtype.put("minister", "PERSON" + (AceDocument.ace2005 ? ":Individual" : ""));
    }
}

