/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.AceDocument;
import AceJet.AceEntityMention;
import AceJet.AceEntityName;
import AceJet.AceEventArgumentValue;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AceEntity
extends AceEventArgumentValue {
    public String type;
    public String subtype;
    public String entClass;
    public boolean generic;
    public ArrayList<AceEntityMention> mentions = new ArrayList();
    public ArrayList<AceEntityName> names = new ArrayList();
    static HashMap standardType = new HashMap();

    public AceEntity(String string, String string2, String string3, boolean bl) {
        this.id = string;
        this.type = string2;
        this.subtype = string3;
        this.generic = bl;
    }

    public AceEntity(Element element, String string) {
        Object object;
        int n;
        Object object2;
        NodeList nodeList;
        this.id = element.getAttribute("ID");
        if (AceDocument.ace2004) {
            this.type = element.getAttribute("TYPE");
            this.subtype = element.getAttribute("SUBTYPE");
            this.entClass = element.getAttribute("CLASS");
            this.generic = !this.entClass.equals("SPC");
        } else {
            nodeList = element.getElementsByTagName("entity_type");
            Element element2 = (Element)nodeList.item(0);
            object2 = element2.getAttribute("GENERIC");
            this.generic = ((String)object2).equals("TRUE");
            this.entClass = null;
            this.type = AceDocument.getElementText(element, "entity_type");
        }
        if (standardType.containsKey(this.type)) {
            this.type = (String)standardType.get(this.type);
        }
        nodeList = element.getElementsByTagName("entity_mention");
        for (n = 0; n < nodeList.getLength(); ++n) {
            object2 = (Element)nodeList.item(n);
            object = new AceEntityMention((Element)object2, string);
            this.addMention((AceEntityMention)object);
        }
        for (n = 0; n < this.mentions.size() - 1; ++n) {
            for (int i = n + 1; i < this.mentions.size(); ++i) {
                object = this.mentions.get(n);
                AceEntityMention aceEntityMention = this.mentions.get(i);
                if (((AceEntityMention)object).head.end() <= aceEntityMention.head.end()) continue;
                this.mentions.set(n, aceEntityMention);
                this.mentions.set(i, (AceEntityMention)object);
            }
        }
        NodeList nodeList2 = element.getElementsByTagName("entity_attributes");
        if (nodeList2.getLength() > 0) {
            object2 = (Element)nodeList2.item(0);
            object = object2.getElementsByTagName("name");
            for (int i = 0; i < object.getLength(); ++i) {
                Element element3 = (Element)object.item(i);
                AceEntityName aceEntityName = new AceEntityName(element3, string);
                this.addName(aceEntityName);
            }
        }
    }

    void addMention(AceEntityMention aceEntityMention) {
        this.mentions.add(aceEntityMention);
        aceEntityMention.entity = this;
    }

    void addName(AceEntityName aceEntityName) {
        this.names.add(aceEntityName);
    }

    AceEntityMention findMention(String string) {
        for (int i = 0; i < this.mentions.size(); ++i) {
            AceEntityMention aceEntityMention = this.mentions.get(i);
            if (!aceEntityMention.id.equals(string)) continue;
            return aceEntityMention;
        }
        return null;
    }

    void write(PrintWriter printWriter) {
        Object object;
        int n;
        if (AceDocument.ace2004) {
            printWriter.print("  <entity ID=\"" + this.id + "\"");
            if (this.type != null && !this.type.equals("")) {
                printWriter.print(" TYPE=\"" + this.type.substring(0, 3) + "\"");
            }
            if (this.subtype != null && !this.subtype.equals("")) {
                printWriter.print(" SUBTYPE=\"" + this.subtype + "\"");
            }
            if (this.entClass != null) {
                printWriter.println(" CLASS=\"" + this.entClass + "\">");
            } else {
                printWriter.println(" CLASS=\"" + (this.generic ? "GEN" : "SPC") + "\">");
            }
        } else {
            printWriter.println("  <entity ID=\"" + this.id + "\">");
            printWriter.println("    <entity_type GENERIC=\"" + (this.generic ? "TRUE" : "FALSE") + "\">" + this.type + "</entity_type>");
        }
        for (n = 0; n < this.mentions.size(); ++n) {
            object = this.mentions.get(n);
            ((AceEntityMention)object).write(printWriter);
        }
        printWriter.println("    <entity_attributes>");
        for (n = 0; n < this.names.size(); ++n) {
            object = this.names.get(n);
            ((AceEntityName)object).write(printWriter);
        }
        printWriter.println("    </entity_attributes>");
        printWriter.println("  </entity>");
    }

    static {
        standardType.put("GSP", "GPE");
        standardType.put("PER", "PERSON");
        standardType.put("ORG", "ORGANIZATION");
        standardType.put("LOC", "LOCATION");
        standardType.put("FAC", "FACILITY");
    }
}

