/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.AceDocument;
import AceJet.AceEntity;
import AceJet.AceEntityMention;
import Jet.Lisp.FeatureSet;
import Jet.Tipster.Document;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

class APFtoCorefXML {
    static String ACEdir;
    static String outputDir;
    static String apfExtension;
    static boolean showTypes;

    APFtoCorefXML() {
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 4 && stringArray.length != 5) {
            System.err.println("APFtoCorefXML requires 4 or 5 arguments:");
            System.err.println("  year apf-directory  output-directory  filelist [showTypes]");
            System.exit(1);
        }
        String string = stringArray[0];
        apfExtension = ".apf.xml";
        AceDocument.ace2004 = false;
        AceDocument.ace2005 = false;
        if (string.equals("2002")) {
            apfExtension = ".sgm.tmx.rdc.xml";
        } else if (!string.equals("2003")) {
            if (string.equals("2004")) {
                AceDocument.ace2004 = true;
            } else if (string.equals("2005")) {
                AceDocument.ace2004 = true;
                AceDocument.ace2005 = true;
            } else {
                System.err.println("Invalid year:  must be 2002-2005");
                System.exit(1);
            }
        }
        ACEdir = stringArray[1];
        if (!ACEdir.endsWith("/")) {
            ACEdir = ACEdir + "/";
        }
        if (!(outputDir = stringArray[2]).endsWith("/")) {
            outputDir = outputDir + "/";
        }
        String string2 = stringArray[3];
        showTypes = stringArray.length == 5;
        APFtoCorefXML.processFileList(string2);
    }

    private static void processFileList(String string) throws IOException {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        int n = 0;
        while ((string2 = bufferedReader.readLine()) != null) {
            System.out.println("\nProcessing document " + ++n + ": " + string2);
            String string3 = ACEdir + string2 + ".sgm";
            ExternalDocument externalDocument = new ExternalDocument("sgml", string3);
            externalDocument.setAllTags(true);
            externalDocument.open();
            String string4 = ACEdir + string2 + apfExtension;
            AceDocument aceDocument = new AceDocument(string3, string4);
            APFtoCorefXML.addMentionTags(externalDocument, aceDocument);
            externalDocument.setSGMLwrapMargin(0);
            externalDocument.saveAs(outputDir, string2 + ".co.txt");
        }
    }

    static void addMentionTags(Document document, AceDocument aceDocument) {
        ArrayList<AceEntity> arrayList = aceDocument.entities;
        for (int i = 0; i < arrayList.size(); ++i) {
            AceEntity aceEntity = arrayList.get(i);
            ArrayList<AceEntityMention> arrayList2 = aceEntity.mentions;
            for (int j = 0; j < arrayList2.size(); ++j) {
                AceEntityMention aceEntityMention = arrayList2.get(j);
                Span span = aceEntityMention.head;
                Span span2 = new Span(span.start(), span.end() + 1);
                FeatureSet featureSet = new FeatureSet("entity", new Integer(i));
                if (showTypes) {
                    featureSet.put("type", aceEntity.type.substring(0, 3));
                    if (aceEntity.subtype != null) {
                        featureSet.put("subtype", aceEntity.subtype);
                    }
                }
                document.annotate("mention", span2, featureSet);
            }
        }
    }
}

