/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import java.io.FileReader;
import java.io.IOException;
import opennlp.maxent.BasicContextGenerator;
import opennlp.maxent.ContextGenerator;
import opennlp.maxent.DataStream;
import opennlp.maxent.PlainTextByLineDataStream;
import opennlp.model.AbstractEventStream;
import opennlp.model.Event;
import opennlp.model.RealValueFileEventStream;

public class RealBasicEventStream
extends AbstractEventStream {
    ContextGenerator cg = new BasicContextGenerator();
    DataStream ds;
    Event next;

    public RealBasicEventStream(DataStream dataStream) {
        this.ds = dataStream;
        if (this.ds.hasNext()) {
            this.next = this.createEvent((String)this.ds.nextToken());
        }
    }

    public Event next() {
        while (this.next == null && this.ds.hasNext()) {
            this.next = this.createEvent((String)this.ds.nextToken());
        }
        Event event = this.next;
        this.next = this.ds.hasNext() ? this.createEvent((String)this.ds.nextToken()) : null;
        return event;
    }

    public boolean hasNext() {
        while (this.next == null && this.ds.hasNext()) {
            this.next = this.createEvent((String)this.ds.nextToken());
        }
        return this.next != null;
    }

    private Event createEvent(String string) {
        int n = string.lastIndexOf(32);
        if (n == -1) {
            return null;
        }
        String[] stringArray = string.substring(0, n).split("\\s+");
        float[] fArray = RealValueFileEventStream.parseContexts(stringArray);
        return new Event(string.substring(n + 1), stringArray, fArray);
    }

    public static void main(String[] stringArray) throws IOException {
        RealBasicEventStream realBasicEventStream = new RealBasicEventStream(new PlainTextByLineDataStream(new FileReader(stringArray[0])));
        while (realBasicEventStream.hasNext()) {
            System.out.println(realBasicEventStream.next());
        }
    }
}

