/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.princeton.data;

import java.util.ArrayList;
import java.util.StringTokenizer;
import net.didion.jwnl.JWNLRuntimeException;
import net.didion.jwnl.data.DictionaryElementFactory;
import net.didion.jwnl.data.Exc;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Pointer;
import net.didion.jwnl.data.PointerType;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.data.SynsetProxy;
import net.didion.jwnl.data.Verb;
import net.didion.jwnl.data.Word;
import net.didion.jwnl.util.TokenizerParser;
import net.didion.jwnl.util.logging.Level;
import net.didion.jwnl.util.logging.LogPublishingService;

public abstract class AbstractPrincetonDictionaryElementFactory
extends DictionaryElementFactory {
    protected AbstractPrincetonDictionaryElementFactory() {
    }

    public IndexWord createIndexWord(POS pOS, String string) {
        try {
            TokenizerParser tokenizerParser = new TokenizerParser(string, " ");
            String string2 = tokenizerParser.nextToken().replace('_', ' ');
            tokenizerParser.nextToken();
            tokenizerParser.nextToken();
            int n = tokenizerParser.nextInt();
            int n2 = 0;
            while (n2 < n) {
                tokenizerParser.nextToken();
                ++n2;
            }
            int n3 = tokenizerParser.nextInt();
            tokenizerParser.nextInt();
            long[] lArray = new long[n3];
            int n4 = 0;
            while (n4 < n3) {
                lArray[n4] = tokenizerParser.nextLong();
                ++n4;
            }
            LogPublishingService.getInstance().log(Level.FINEST, "PRINCETON_INFO_003", new Object[]{string2, pOS});
            return new IndexWord(string2, pOS, lArray);
        }
        catch (Exception exception) {
            throw new JWNLRuntimeException("PRINCETON_EXCEPTION_005", string, (Throwable)exception);
        }
    }

    public Synset createSynset(POS pOS, String string) {
        try {
            int n;
            Object object;
            TokenizerParser tokenizerParser = new TokenizerParser(string, " ");
            long l = tokenizerParser.nextLong();
            tokenizerParser.nextToken();
            String string2 = tokenizerParser.nextToken();
            boolean bl = false;
            if (string2.equals("s")) {
                bl = true;
            }
            FactorySynsetProxy factorySynsetProxy = new FactorySynsetProxy(pOS);
            int n2 = tokenizerParser.nextHexInt();
            Word[] wordArray = new Word[n2];
            int n3 = 0;
            while (n3 < n2) {
                String string3 = tokenizerParser.nextToken();
                tokenizerParser.nextHexInt();
                wordArray[n3] = this.createWord(factorySynsetProxy, n3, string3);
                ++n3;
            }
            int n4 = tokenizerParser.nextInt();
            Pointer[] pointerArray = new Pointer[n4];
            int n5 = 0;
            while (n5 < n4) {
                object = PointerType.getPointerTypeForKey(tokenizerParser.nextToken());
                long l2 = tokenizerParser.nextLong();
                POS pOS2 = POS.getPOSForKey(tokenizerParser.nextToken());
                n = tokenizerParser.nextHexInt();
                int n6 = n / 256;
                int n7 = n & 0xFF;
                FactorySynsetProxy factorySynsetProxy2 = n6 == 0 ? factorySynsetProxy : wordArray[n6 - 1];
                pointerArray[n5] = new Pointer(factorySynsetProxy2, n5, (PointerType)object, pOS2, l2, n7);
                ++n5;
            }
            if (pOS == POS.VERB) {
                int n8 = tokenizerParser.nextInt();
                int n9 = 0;
                while (n9 < n8) {
                    tokenizerParser.nextToken();
                    int n10 = tokenizerParser.nextInt();
                    int n11 = tokenizerParser.nextHexInt();
                    if (n11 > 0) {
                        ((MutableVerb)wordArray[n11 - 1]).setVerbFrameFlag(n10);
                    } else {
                        n = 0;
                        while (n < wordArray.length) {
                            ((MutableVerb)wordArray[n]).setVerbFrameFlag(n10);
                            ++n;
                        }
                    }
                    ++n9;
                }
            }
            object = null;
            int n12 = string.indexOf(124);
            if (n12 > 0) {
                object = string.substring(n12 + 2).trim();
            }
            long l3 = 0L;
            n = 0;
            while (n < wordArray.length) {
                if (wordArray[n] instanceof Verb) {
                    l3 |= ((Verb)wordArray[n]).getVerbFrameFlags();
                }
                ++n;
            }
            Synset synset = new Synset(pOS, l, wordArray, pointerArray, (String)object, l3, bl);
            factorySynsetProxy.setSource(synset);
            LogPublishingService.getInstance().log(Level.FINEST, "PRINCETON_INFO_002", new Object[]{pOS, new Long(l)});
            return factorySynsetProxy;
        }
        catch (Exception exception) {
            throw new JWNLRuntimeException("PRINCETON_EXCEPTION_004", string, (Throwable)exception);
        }
    }

    protected Word createWord(Synset synset, int n, String string) {
        if (synset.getPOS().equals(POS.VERB)) {
            return new MutableVerb(synset, n, string);
        }
        return new Word(synset, n, string);
    }

    public Exc createExc(POS pOS, String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string2 = stringTokenizer.nextToken().replace('_', ' ');
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken().replace('_', ' '));
            }
            LogPublishingService.getInstance().log(Level.FINEST, "PRINCETON_INFO_001", new Object[]{pOS, string2});
            return new Exc(pOS, string2, arrayList);
        }
        catch (Exception exception) {
            throw new JWNLRuntimeException("PRINCETON_EXCEPTION_003", string, (Throwable)exception);
        }
    }

    private static final class FactorySynsetProxy
    extends SynsetProxy {
        private Synset _source;

        public FactorySynsetProxy(POS pOS) {
            super(pOS);
        }

        protected Synset getSource() {
            if (this._source == null) {
                throw new JWNLRuntimeException("PRINCETON_EXCEPTION_006");
            }
            return this._source;
        }

        private void setSource(Synset synset) {
            this._source = synset;
        }
    }

    protected static final class MutableVerb
    extends Verb {
        private long _verbFrameFlags = 0L;

        public MutableVerb(Synset synset, int n, String string) {
            super(synset, n, string, 0L);
        }

        public long getVerbFrameFlags() {
            return this._verbFrameFlags;
        }

        public void setVerbFrameFlag(int n) {
            this._verbFrameFlags |= (long)(1 << n);
        }
    }
}

