/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.mallet.base.minimize;

import edu.umass.cs.mallet.base.minimize.BackTrackLineSearch;
import edu.umass.cs.mallet.base.minimize.LineMinimizer;
import edu.umass.cs.mallet.base.minimize.Minimizable;
import edu.umass.cs.mallet.base.minimize.Minimizer;
import edu.umass.cs.mallet.base.types.Matrix;
import edu.umass.cs.mallet.base.util.MalletLogger;
import java.util.LinkedList;
import java.util.Vector;
import java.util.logging.Logger;

public class LimitedMemoryBFGS
implements Minimizer.ByGradient {
    final double initialStepSize = 0.01;
    final int maxIterations = 300;
    final double tolerance = 1.0E-4;
    final double gradientTolerance = 0.001;
    final double eps = 1.0E-5;
    final int m = 4;
    private static Logger logger = MalletLogger.getLogger(LimitedMemoryBFGS.class.getName());
    LineMinimizer lineMinimizer = new BackTrackLineSearch();
    Matrix g;
    Matrix oldg;
    Matrix direction;
    Matrix parameters;
    Matrix oldParameters;
    LinkedList s;
    LinkedList y;
    LinkedList rho;
    Vector temp;
    double step = 1.0;
    int iterations;

    public double getGradient() {
        return this.g.twoNorm();
    }

    public boolean minimize(Minimizable.ByGradient minable) {
        return this.minimize(minable, Integer.MAX_VALUE);
    }

    public boolean minimize(Minimizable.ByGradient minable, int numIterations) {
        double initialCost = minable.getCost();
        logger.fine("Entering L-BFGS.minimize(). Initial Cost=" + initialCost);
        if (this.g == null) {
            logger.fine("First time through");
            this.iterations = 0;
            this.s = new LinkedList();
            this.y = new LinkedList();
            this.rho = new LinkedList();
            this.temp = new Vector(4);
            this.oldParameters = minable.getNewMatrix();
            this.g = minable.getNewMatrix();
            this.parameters = minable.getNewMatrix();
            minable.getParameters(this.oldParameters);
            this.oldg = (Matrix)this.oldParameters.cloneMatrix();
            minable.getCostGradient(this.oldg);
            this.direction = (Matrix)this.oldg.cloneMatrix();
            if (this.direction.absNormalize() == 0.0) {
                logger.info("L-BFGS initial gradient is zero; saying converged");
                return true;
            }
            int i = 0;
            while (i < 4) {
                this.temp.add(new Double(0.0));
                ++i;
            }
            this.direction.timesEquals(-1.0 * this.direction.twoNorm());
            logger.fine("enter initial line search");
            int unsuccessfulLineSearch = (int)this.lineMinimizer.minimize(minable, this.direction, this.step);
            logger.fine("exit initial line search");
            minable.getParameters(this.parameters);
            minable.getCostGradient(this.g);
            if (unsuccessfulLineSearch == 1) {
                logger.warning("Line Search exited abnormally. Giving up L-BFGS.");
                this.g = null;
                return true;
            }
        }
        int iterationCount = 0;
        while (iterationCount < numIterations) {
            double cost = minable.getCost();
            logger.fine("In L-BFGS, iteration=" + iterationCount + ", cost=" + cost);
            this.oldParameters.equalsPlus(-1.0, this.parameters);
            this.push(this.s, this.oldParameters);
            this.oldg.equalsPlus(-1.0, this.g);
            this.push(this.y, this.oldg);
            double sy = ((Matrix)this.s.getLast()).dotProduct((Matrix)this.y.getLast());
            assert (sy > 0.0) : "sy: " + sy;
            double gamma = sy / ((Matrix)this.y.getLast()).dotProduct((Matrix)this.y.getLast());
            assert (gamma >= 0.0) : "Gamma:" + gamma;
            this.push(this.rho, 1.0 / sy);
            this.direction.set(this.g);
            int i = this.s.size() - 1;
            while (i >= 0) {
                double rhoTemp = (Double)this.rho.get(i);
                double factor = ((Matrix)this.s.get(i)).dotProduct(this.direction);
                this.temp.set(i, new Double(rhoTemp * factor));
                Matrix yTemp = (Matrix)this.y.get(i);
                this.direction.plusEquals(yTemp, -1.0 * rhoTemp * factor);
                --i;
            }
            this.direction.timesEquals(gamma);
            i = 0;
            while (i < this.s.size()) {
                double tmp = (Double)this.rho.get(i) * ((Matrix)this.y.get(i)).dotProduct(this.direction);
                Matrix sTemp = (Matrix)this.s.get(i);
                this.direction.plusEquals(sTemp, (Double)this.temp.get(i) - tmp);
                ++i;
            }
            this.oldg.set(this.g);
            this.oldParameters.set(this.parameters);
            this.direction.timesEquals(-1.0);
            logger.info("enter line search");
            int unsuccessfulLineSearch = (int)this.lineMinimizer.minimize(minable, this.direction, this.step);
            logger.info("exit line search");
            if (unsuccessfulLineSearch == 1) {
                logger.warning("Line Search exited abnormally. Giving up L-BFGS.");
                return true;
            }
            minable.getParameters(this.parameters);
            minable.getCostGradient(this.g);
            double newCost = minable.getCost();
            if (2.0 * Math.abs(newCost - cost) <= 1.0E-4 * (Math.abs(newCost) + Math.abs(cost) + 1.0E-5)) {
                logger.info("Exiting L-BFGS on termination #1:\ncost difference below tolerance");
                return true;
            }
            double gg = this.g.twoNorm();
            if (gg < 0.001) {
                logger.info("Exiting L-BFGS on termination #2: \ngradient=" + gg + " < " + 0.001);
                return true;
            }
            if (gg == 0.0) {
                logger.info("Exiting L-BFGS on termination #3: \ngradient==0.0");
                return true;
            }
            logger.fine("Gradient = " + gg);
            ++this.iterations;
            if (this.iterations > 300) {
                System.err.println("Too many iterations in L-BFGS.java. Continuing with current parameters.");
                return true;
            }
            ++iterationCount;
        }
        return false;
    }

    private void push(LinkedList l, Matrix toadd) {
        assert (l.size() <= 4);
        if (l.size() == 4) {
            Matrix last = (Matrix)l.get(0);
            last.set(toadd);
            Matrix ptr = last;
            int i = 0;
            while (i < l.size() - 1) {
                l.set(i, (Matrix)l.get(i + 1));
                ++i;
            }
            l.set(3, ptr);
        } else {
            l.addLast(toadd.cloneMatrix());
        }
    }

    private void push(LinkedList l, double toadd) {
        assert (l.size() <= 4);
        if (l.size() == 4) {
            l.removeFirst();
            l.addLast(new Double(toadd));
        } else {
            l.addLast(new Double(toadd));
        }
    }
}

