/*
 * Decompiled with CFR 0.152.
 */
package Jet.Time;

import Jet.Lisp.FeatureSet;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberAnnotator {
    private static TObjectIntHashMap numberNames;
    private static TObjectIntHashMap ordinalNumberNames;

    public void annotate(Document document) {
        Span span = new Span(0, document.length());
        this.annotate(document, span);
    }

    public void annotate(Document document, Span span) {
        Object object;
        int n;
        Vector<Annotation> vector = document.annotationsOfType("token", span);
        if (vector == null) {
            return;
        }
        int n2 = vector.size();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<NumberInformation> arrayList2 = new ArrayList<NumberInformation>();
        int n3 = span.start();
        for (n = 0; n < n2; ++n) {
            FeatureSet featureSet;
            Annotation annotation = vector.get(n);
            object = document.text(annotation).trim();
            if (((String)object).equals("-")) continue;
            NumberInformation numberInformation = null;
            if (annotation.get("intvalue") != null) {
                Integer n4;
                Object object2 = annotation.get("intvalue");
                if (object2 instanceof Integer) {
                    n4 = (Integer)object2;
                } else if (object2 instanceof String) {
                    try {
                        n4 = new Integer((String)object2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("*** invalid intvalue " + annotation);
                        n4 = new Integer(0);
                    }
                } else {
                    System.out.println("*** invalid intvalue " + annotation);
                    n4 = new Integer(0);
                }
                featureSet = new FeatureSet("value", n4);
                document.annotate("number", annotation.span(), featureSet);
            } else {
                numberInformation = this.resolveNumber((String)object);
            }
            if (numberInformation != null) {
                if (arrayList2.isEmpty()) {
                    n3 = annotation.start();
                    arrayList.clear();
                }
                arrayList2.add(numberInformation);
                arrayList.add((String)object);
                continue;
            }
            if (arrayList2.isEmpty()) continue;
            if (!this.checkPhoneNumber(arrayList)) {
                int n5 = this.calcNumber(arrayList2);
                int n6 = vector.get(n - 1).end();
                featureSet = new FeatureSet();
                featureSet.put("value", new Integer(n5));
                if (((NumberInformation)arrayList2.get(arrayList2.size() - 1)).isOrdinal()) {
                    featureSet.put("ordinal", true);
                }
                document.annotate("number", new Span(n3, n6), featureSet);
            }
            arrayList2.clear();
        }
        if (!arrayList2.isEmpty()) {
            n = this.calcNumber(arrayList2);
            int n7 = vector.lastElement().end();
            object = new FeatureSet();
            ((FeatureSet)object).put("value", new Integer(n));
            if (((NumberInformation)arrayList2.get(arrayList2.size() - 1)).isOrdinal()) {
                ((FeatureSet)object).put("ordinal", true);
            }
            document.annotate("number", new Span(n3, n7), (FeatureSet)object);
        }
    }

    private int calcNumber(List<NumberInformation> list) {
        int n = 0;
        int n2 = 0;
        for (NumberInformation numberInformation : list) {
            int n3 = numberInformation.getValue();
            if (n3 >= 1000) {
                n += (n2 > 0 ? n2 : 1) * n3;
                n2 = 0;
                continue;
            }
            if (n3 == 100) {
                n2 = (n2 > 0 ? n2 : 1) * n3;
                continue;
            }
            n2 += n3;
        }
        return n += n2;
    }

    private NumberInformation resolveNumber(String string) {
        String string2 = string.toLowerCase().trim();
        if (string2.endsWith(".")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        Pattern pattern = Pattern.compile("[+-]?\\d*(?:1st|2nd|3rd|[04-9]th)", 2);
        if (numberNames.containsKey(string2)) {
            return new NumberInformation(string, numberNames.get(string2), false);
        }
        NumberInformation numberInformation = this.resolveOrdinalNumber(string);
        if (numberInformation != null) {
            return numberInformation;
        }
        if (pattern.matcher(string2).matches()) {
            int n = Integer.parseInt(string2.substring(0, string2.length() - 2));
            return new NumberInformation(string, n, true);
        }
        try {
            int n = Integer.parseInt(string2);
            return new NumberInformation(string, n, false);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private boolean checkPhoneNumber(List<String> list) {
        if (list.size() == 1) {
            return false;
        }
        Pattern pattern = Pattern.compile("\\d+");
        for (String string : list) {
            if (pattern.matcher(string).matches()) continue;
            return false;
        }
        return true;
    }

    private NumberInformation resolveOrdinalNumber(String string) {
        String string2;
        String string3 = string.toLowerCase();
        if (ordinalNumberNames.containsKey(string3)) {
            return new NumberInformation(string, ordinalNumberNames.get(string3), true);
        }
        if (string.endsWith("th") && numberNames.contains(string2 = string.substring(0, string.length() - 2))) {
            int n = numberNames.get(string2);
            return new NumberInformation(string2, n, true);
        }
        return null;
    }

    static {
        ordinalNumberNames = new TObjectIntHashMap();
        TObjectIntHashMap tObjectIntHashMap = new TObjectIntHashMap();
        tObjectIntHashMap.put("zero", 0);
        tObjectIntHashMap.put("one", 1);
        tObjectIntHashMap.put("two", 2);
        tObjectIntHashMap.put("three", 3);
        tObjectIntHashMap.put("four", 4);
        tObjectIntHashMap.put("five", 5);
        tObjectIntHashMap.put("six", 6);
        tObjectIntHashMap.put("seven", 7);
        tObjectIntHashMap.put("eight", 8);
        tObjectIntHashMap.put("nine", 9);
        tObjectIntHashMap.put("ten", 10);
        tObjectIntHashMap.put("eleven", 11);
        tObjectIntHashMap.put("twelve", 12);
        tObjectIntHashMap.put("thirteen", 13);
        tObjectIntHashMap.put("fourteen", 14);
        tObjectIntHashMap.put("fifteen", 15);
        tObjectIntHashMap.put("sixteen", 16);
        tObjectIntHashMap.put("seventeen", 17);
        tObjectIntHashMap.put("eighteen", 18);
        tObjectIntHashMap.put("nineteen", 19);
        tObjectIntHashMap.put("twenty", 20);
        tObjectIntHashMap.put("thirty", 30);
        tObjectIntHashMap.put("forty", 40);
        tObjectIntHashMap.put("fifty", 50);
        tObjectIntHashMap.put("sixty", 60);
        tObjectIntHashMap.put("seventy", 70);
        tObjectIntHashMap.put("eighty", 80);
        tObjectIntHashMap.put("ninety", 90);
        tObjectIntHashMap.put("hundred", 100);
        tObjectIntHashMap.put("thousand", 1000);
        tObjectIntHashMap.put("million", 100000);
        numberNames = tObjectIntHashMap;
        TObjectIntHashMap tObjectIntHashMap2 = new TObjectIntHashMap();
        tObjectIntHashMap2.put("first", 1);
        tObjectIntHashMap2.put("second", 2);
        tObjectIntHashMap2.put("third", 3);
        tObjectIntHashMap2.put("fifth", 5);
        tObjectIntHashMap2.put("eighth", 8);
        tObjectIntHashMap2.put("twelfth", 12);
        ordinalNumberNames = tObjectIntHashMap2;
    }

    private static class NumberInformation {
        private boolean ordinal;
        private int value;
        private String token;

        public NumberInformation(String string, int n, boolean bl) {
            this.token = string;
            this.value = n;
            this.ordinal = bl;
        }

        public boolean isOrdinal() {
            return this.ordinal;
        }

        public void setOrdinal(boolean bl) {
            this.ordinal = bl;
        }

        public String getToken() {
            return this.token;
        }

        public void setToken(String string) {
            this.token = string;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int n) {
            this.value = n;
        }
    }
}

