/*
 * Decompiled with CFR 0.152.
 */
package Jet.NE;

import Jet.NE.ClassHierarchyResolver;
import Jet.Util.IOUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleClassHierarchyResolver
implements ClassHierarchyResolver {
    private Map<String, Set<String>> subClassMap = new HashMap<String, Set<String>>();

    private SimpleClassHierarchyResolver(Map<String, Set<String>> map) {
        this.subClassMap = map;
    }

    @Override
    public boolean isSubClassOf(String string, String string2) {
        if (string2 == string || string2.equals(string)) {
            return true;
        }
        Set<String> set = this.subClassMap.get(string2);
        if (set == null) {
            return false;
        }
        return set.contains(string);
    }

    public static ClassHierarchyResolver getInstance(Reader reader) throws IOException {
        if (reader instanceof BufferedReader) {
            return SimpleClassHierarchyResolver.getInstance((BufferedReader)reader);
        }
        return SimpleClassHierarchyResolver.getInstance(new BufferedReader(reader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassHierarchyResolver getInstance(File file) throws IOException {
        ClassHierarchyResolver classHierarchyResolver;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            classHierarchyResolver = SimpleClassHierarchyResolver.getInstance(bufferedReader);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedReader);
            throw throwable;
        }
        IOUtils.closeQuietly(bufferedReader);
        return classHierarchyResolver;
    }

    private static ClassHierarchyResolver getInstance(BufferedReader bufferedReader) throws IOException {
        String string;
        Stack stack = new Stack();
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        while ((string = bufferedReader.readLine()) != null) {
            if (string.startsWith("#")) continue;
            String string2 = string.trim().intern();
            int n = SimpleClassHierarchyResolver.countHeadingSpace(string);
            if (hashMap.containsKey(string2)) {
                throw new RuntimeException(string2 + " appeared twice.");
            }
            if (n > stack.size()) {
                throw new RuntimeException("invalid indent");
            }
            while (stack.size() > n) {
                stack.pop();
            }
            HashSet hashSet = new HashSet();
            hashMap.put(string2, hashSet);
            stack.push(hashSet);
            for (Set set : stack) {
                set.add(string2);
            }
        }
        return new SimpleClassHierarchyResolver(hashMap);
    }

    private static int countHeadingSpace(String string) {
        int n;
        for (n = 0; n < string.length() && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        return n;
    }
}

