/*
 * Decompiled with CFR 0.152.
 */
package Jet.HMM;

import Jet.HMM.HMMemitter;
import Jet.Lisp.FeatureSet;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class BasicHMMemitter
extends HMMemitter {
    private static final float VOCAB_SIZE = 40000.0f;
    int count;
    HashMap tokenCount;
    HashMap tokenProbability;
    double unseenTokenProbability;

    public void resetForTraining() {
        this.count = 0;
        this.tokenCount = new HashMap();
    }

    public void trainOnInstances(String string, String string2, int n) {
        this.count += n;
        Integer n2 = (Integer)this.tokenCount.get(string);
        int n3 = n2 == null ? 0 : n2;
        this.tokenCount.put(string, new Integer(n3 + n));
    }

    public void computeProbabilities() {
        this.tokenProbability = new HashMap();
        int n = 0;
        for (Map.Entry entry : this.tokenCount.entrySet()) {
            String string = (String)entry.getKey();
            int n2 = (Integer)entry.getValue();
            double d = Math.log((double)n2 / (double)this.count);
            this.tokenProbability.put(string, new Double(d));
            if (n2 != 1) continue;
            ++n;
        }
        this.unseenTokenProbability = Math.log((double)n / (double)this.count / 40000.0);
    }

    public double getProbability(String string, String string2, FeatureSet featureSet) {
        Double d = (Double)this.tokenProbability.get(string);
        if (d == null) {
            return this.unseenTokenProbability;
        }
        return d;
    }

    public void print() {
        for (Map.Entry entry : this.tokenProbability.entrySet()) {
            String string = (String)entry.getKey();
            double d = (Double)entry.getValue();
            System.out.println("EMIT " + string + " " + d);
        }
    }

    public void store(PrintWriter printWriter) {
        for (Map.Entry entry : this.tokenCount.entrySet()) {
            String string = (String)entry.getKey();
            int n = (Integer)entry.getValue();
            printWriter.println("EMIT " + string + " " + n);
        }
    }
}

