/*
 * Decompiled with CFR 0.152.
 */
package tratz.parse.featgen;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import tratz.featgen.InitException;
import tratz.parse.featgen.ParseFeatureGenerator;
import tratz.parse.ml.ParseModel;
import tratz.parse.types.Arc;
import tratz.parse.types.Token;
import tratz.parse.types.TokenPointer;
import tratz.types.ChecksumMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEnParseFeatureGenerator
implements Serializable,
ParseFeatureGenerator {
    public static final long serialVersionUID = 1L;
    private static final String DUMMY_PART_OF_SPEECH = "na";
    transient TokenPointer mDummy = new TokenPointer(new Token(null, "na", 0), null, null);
    private List<String> mBCs;
    private ChecksumMap<String> mFeatMap2 = new ChecksumMap();
    private static final int L2 = 0;
    private static final int L1 = 1;
    private static final int L0 = 2;
    private static final int R0 = 3;
    private static final int R1 = 4;
    private static final int R2 = 5;
    private static final int NTOK = 6;
    private static final Set<String> inbetweenWordsOfInterest = new HashSet<String>(Arrays.asList(",", "``", ";", ":", "--", "(", ")"));
    private final String[] tt = new String[]{"\u2f3f", "\u2f40", "\u2f41", "\u2f42", "\u2f43"};
    private final String[] ww = new String[]{"\u2f44", "\u2f55", "\u2f56", "\u2f57", "\u2f58"};
    private final String[] wt = new String[]{"\u2f59", "\u2f5a", "\u2f5b", "\u2f5c", "\u2f6d"};
    private final String[] tw = new String[]{"\u2f6e", "\u2f6f", "\u2f70", "\u2f71", "\u2f72"};
    private final String[] ttlclc = new String[]{"\u2f73", "\u2f74", "\u2f85", "\u2f86", "\u2f87"};
    private final String[] ttlcrc = new String[]{"\u2f88", "\u2f89", "\u2f8a", "\u2f8b", "\u2f8c"};
    private final String[] ttrclc = new String[]{"\u2f9d", "\u2f9e", "\u2f9f", "\u2fa0", "\u2fa1"};
    private final String[] ttrcrc = new String[]{"\u2fa2", "\u2fa3", "\u2fa4", "\u2fb5", "\u2fb6"};
    private final int[] lseq = new int[]{1, 1, 2, 3, 2};
    private final int[] rseq = new int[]{3, 2, 3, 4, 4};
    private final String[] uniFrmPrefixes = new String[]{"\u2eef", "\u2ef0", "\u2f0d", "\u2f0e", "\u2f0f", "\u2f10"};
    private final String[] uniCposPrefixes = new String[]{"\u2f29", "\u2f2a", "\u2f2b", "\u2f2c", "\u2f3d", "\u2f3e"};
    private final String[] NCP = new String[]{"\u2eb4", "\u2eb5", "\u2eb6", "\u2eb7", "\u2eb8", "\u2eb9"};
    private final String[] lenP = new String[]{"\u2eba", "\u2ebb", "\u2ebc", "\u2ebd", "\u2ebe", "\u2ebf"};
    private final String[] deltaP = new String[]{"\u2ec0", "\u2ed1", "\u2ed2", "\u2ed3", "\u2ed4"};
    private final String[] dt = new String[]{"\u2ed5", "\u2ed6", "\u2ed7", "\u2ed8", "\u2ee9"};
    private final String[] uniTagPrefixes = new String[]{"\u2f11", "\u2f12", "\u2f13", "\u2f14", "\u2f25", "\u2f26"};
    private Set<String> definiteDeterminers = new HashSet<String>(Arrays.asList("the", "these", "those", "this", "that", "'s", "'", "what", "whose"));
    private static final Set<String> COMMON_RELATIVE_PRON_POSITIONS = new HashSet<String>(Arrays.asList("nsubj", "dobj", "iobj", "prep"));

    public DefaultEnParseFeatureGenerator() throws Exception {
        this.loadMap();
    }

    private void loadMap() throws Exception {
        this.mFeatMap2 = new ChecksumMap();
        int minOccurrence = 1;
        int maxDepth = Integer.MAX_VALUE;
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream("data/brownClusters175.gz"))));
            String line = null;
            this.mBCs = new ArrayList<String>();
            String lastClass = null;
            while ((line = reader.readLine()) != null) {
                String[] split = line.split("\\t+");
                String path = split[0];
                String token = split[1];
                int occurrences = Integer.parseInt(split[2]);
                if (occurrences < minOccurrence) continue;
                String clazz = Integer.toHexString(Integer.parseInt(path.substring(0, Math.min(path.length(), maxDepth)), 2));
                if (!clazz.equals(lastClass)) {
                    this.mBCs.add(clazz);
                    lastClass = clazz;
                }
                this.mFeatMap2.put(token, this.mBCs.size() - 1);
            }
            reader.close();
        }
        catch (IOException ioe) {
            throw new InitException(ioe);
        }
    }

    private String getBC(String s) {
        String retValue;
        if (this.mFeatMap2 == null) {
            try {
                this.loadMap();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (s == null) {
            retValue = "-2";
        } else {
            String lower;
            String numericized = s.replaceAll("[0-9]", "\u019e");
            if (s.equals("an")) {
                s = "a";
            }
            retValue = !this.mFeatMap2.containsKey(numericized) ? (!this.mFeatMap2.containsKey(lower = numericized.toLowerCase()) ? "-1" : this.mBCs.get(this.mFeatMap2.get(lower))) : this.mBCs.get(this.mFeatMap2.get(numericized));
        }
        return retValue;
    }

    private String getTag(TokenPointer ptr) {
        return this.getTag(ptr.tok);
    }

    private String getTag(Token tok) {
        String tag = tok.getPos();
        if (tag.equals("IN") || tag.equals("WRB") || tag.equals("WP")) {
            tag = tag + this.getForm(tok);
        }
        return tag;
    }

    private String getForm(TokenPointer ptr) {
        return this.getForm(ptr.tok);
    }

    private String getForm(Token tok) {
        String text = tok.getText();
        if ("\"".equals(text)) {
            text = tok.getPos();
        }
        return text == null ? text : text.toLowerCase();
    }

    private int length(TokenPointer ptr, Token[] kids) {
        int leftside = kids[0] == this.mDummy.tok ? ptr.tok.getIndex() : kids[0].getIndex();
        int rightside = kids[1] == this.mDummy.tok ? ptr.tok.getIndex() : kids[1].getIndex();
        return rightside - leftside;
    }

    private String getCpos(Token t) {
        String pos = t.getPos();
        return pos.length() > 2 && !pos.endsWith("$") ? pos.substring(0, 2) : pos;
    }

    @Override
    public void genFeats(Set<String> fts, ParseModel model, List<Token> tokens, TokenPointer ptr, List[] currentArcs) {
        int numr0Deprels;
        int numl0Deprels;
        Arc r1whadvmod;
        Arc r0whadvmod;
        int i;
        if (this.mDummy == null) {
            this.mDummy = new TokenPointer(new Token(null, DUMMY_PART_OF_SPEECH, 0), null, null);
        }
        String[] frm = new String[6];
        String[] tag = new String[6];
        String[] pos = new String[6];
        String[] cpos = new String[6];
        Token[][] kids = new Token[6][];
        String[] lcpos = new String[6];
        String[] rcpos = new String[6];
        String[] rcfrm = new String[6];
        String[] rccpos = new String[6];
        String[] bc = new String[6];
        String[] bcrc = new String[6];
        TokenPointer[] tp = new TokenPointer[]{ptr.prev != null && ptr.prev.prev != null ? ptr.prev.prev : this.mDummy, ptr.prev != null ? ptr.prev : this.mDummy, ptr, ptr.next != null ? ptr.next : this.mDummy, ptr.next != null && ptr.next.next != null ? ptr.next.next : this.mDummy, ptr.next != null && ptr.next.next != null && ptr.next.next.next != null ? ptr.next.next.next : this.mDummy};
        for (i = 0; i < 6; ++i) {
            frm[i] = this.getForm(tp[i]);
            tag[i] = this.getTag(tp[i]);
            pos[i] = tp[i].tok.getPos();
            cpos[i] = this.getCpos(tp[i].tok);
            kids[i] = this.getLRchildren(tp[i].tok, currentArcs);
            lcpos[i] = kids[i][0].getPos();
            rcpos[i] = kids[i][1].getPos();
            rcfrm[i] = this.getForm(kids[i][1]);
            rccpos[i] = this.getCpos(kids[i][1]);
            bc[i] = this.getBC(frm[i]);
            bcrc[i] = this.getBC(rcfrm[i]);
            String posi = pos[i];
            if (posi.equals("NNS") || posi.equals("VBZ")) {
                fts.add("\u2f29nz" + i);
            }
            if (posi.equals("NN") || posi.equals("VB")) {
                fts.add("\u2f29nv" + i);
            }
            if (posi.equals("VBN") || posi.equals("VBD")) {
                fts.add("\u2f111" + i);
            } else {
                fts.add("\u2f112" + i);
            }
            if (posi.equals("DT")) {
                if (frm[i].equals("the") || frm[i].equals("a") || frm[i].equals("an")) {
                    fts.add("\u2f131" + i);
                } else {
                    fts.add("\u2f132" + i);
                }
            }
            if (posi.equals("RBS") || posi.equals("JJS")) {
                fts.add(i + "\u2f29s");
            }
            if (posi.equals("RBR") || posi.equals("JJR")) {
                fts.add(i + "\u2f29c");
            }
            if (posi.equals("WP$") || posi.equals("PRP$")) {
                fts.add(i + "\u2f29p");
            }
            fts.add(tag[i] + this.uniTagPrefixes[i]);
            fts.add(cpos[i] + this.uniCposPrefixes[i]);
            fts.add(bc[i] + this.uniTagPrefixes[i]);
            if (frm[i] != null) {
                fts.add(frm[i] + this.uniFrmPrefixes[i]);
            }
            fts.add(tag[i] + (kids[i][0] == this.mDummy.tok && kids[i][1] == this.mDummy.tok) + this.NCP[i]);
            fts.add(tag[i] + this.lenP[i] + this.length(tp[i], kids[i]));
        }
        for (i = 0; i < 5; ++i) {
            boolean delta = Math.abs(tp[i].tok.getIndex() - tp[i + 1].tok.getIndex()) > 1;
            fts.add(this.deltaP[i] + delta);
            fts.add(delta + "+" + tag[i] + this.dt[i] + tag[i + 1]);
        }
        Set<String> deprelsl2 = this.addAllDeprels("\u32df", tp[0].tok, currentArcs);
        Set<String> deprelsl1 = this.addAllDeprels("\u2eea", tp[1].tok, currentArcs);
        Set<String> deprelsl0 = this.addAllDeprels("\u2eeb", tp[2].tok, currentArcs);
        Set<String> deprelsr0 = this.addAllDeprels("\u2eec", tp[3].tok, currentArcs);
        Set<String> deprelsr1 = this.addAllDeprels("\u2eed", tp[4].tok, currentArcs);
        Set<String> deprelsr2 = this.addAllDeprels("\u32e0", tp[5].tok, currentArcs);
        for (String s : deprelsl2) {
            fts.add(s);
        }
        for (String s : deprelsl1) {
            fts.add(s);
        }
        for (String s : deprelsl0) {
            fts.add(s);
        }
        for (String s : deprelsr0) {
            fts.add(s);
        }
        for (String s : deprelsr1) {
            fts.add(s);
        }
        for (String s : deprelsr2) {
            fts.add(s);
        }
        int l0i = tp[2].tok.getIndex();
        int r0i = tp[3].tok.getIndex();
        int rldiff = r0i - l0i;
        if (l0i != 0 && r0i != 0 && rldiff > 0) {
            int minIndex = Math.max(l0i, r0i - 10);
            for (int i2 = r0i; i2 > minIndex; --i2) {
                Token t = tokens.get(i2 - 1);
                String text = this.getForm(t);
                fts.add(this.getTag(t) + "\u2e8e");
                if (!inbetweenWordsOfInterest.contains(text)) continue;
                fts.add(text + "\u2e8e");
            }
        }
        if ("CC".equals(pos[1])) {
            this.addL1CCFeats(kids[1][1], fts, frm, pos, cpos, tag, rcpos, lcpos);
        }
        if ("CC".equals(pos[2])) {
            this.addL0CCFeats(kids[2][1], fts, frm, pos, cpos, rcpos);
        }
        if ("CC".equals(pos[3])) {
            this.addR0CCFeats(kids[3][1], fts, currentArcs, deprelsl2, deprelsl1, deprelsl0, frm, pos, cpos, rcpos, rccpos, rcfrm, tp);
        }
        if ("CC".equals(pos[4])) {
            this.addR1CCFeats(kids[4][1], fts, currentArcs, deprelsl1, deprelsl0, deprelsr0, tag, frm, rcpos, rccpos, cpos, pos, rcfrm);
        }
        if ("CC".equals(pos[5])) {
            this.addR2CCFeats(kids[5][1], fts, currentArcs, deprelsl0, deprelsr0, frm, rcfrm[5], rccpos[5], rcpos[5], cpos, pos);
        }
        if ((r0whadvmod = this.getDeprel(tp[3].tok, currentArcs, "whadvmod")) != null) {
            String prefix = this.getForm(r0whadvmod.getChild()) + "\u9b35";
            fts.add(prefix + frm[2]);
            fts.add(prefix + tag[2]);
            fts.add(prefix + bc[2]);
            fts.add(frm[2] + "\u2fc9");
            fts.add(tag[2] + "\u9b3b");
            fts.add(bc[2] + "\u9b34");
        }
        if ((r1whadvmod = this.getDeprel(tp[4].tok, currentArcs, "whadvmod")) != null) {
            String prefix = this.getForm(r1whadvmod.getChild()) + "\u9841";
            fts.add(prefix + frm[3]);
            fts.add(prefix + tag[3]);
            fts.add(prefix + bc[3]);
            fts.add(frm[3] + "\u2fcb");
            fts.add(tag[3] + "\u9b59");
            fts.add(bc[3] + "\u9b2e");
        }
        if ((numl0Deprels = deprelsl0.size()) > 1) {
            ArrayList<String> deprelsListl0 = new ArrayList<String>(deprelsl0);
            Collections.sort(deprelsListl0);
            for (int i3 = 0; i3 < numl0Deprels; ++i3) {
                String newFeat = "\u2fc5" + (String)deprelsListl0.get(i3);
                fts.add("\u1144" + tag[2] + "+" + (String)deprelsListl0.get(i3));
                fts.add("\u1144" + bc[2] + "+" + (String)deprelsListl0.get(i3));
                for (int j = 0; j < numl0Deprels; ++j) {
                    if (i3 == j) continue;
                    fts.add(newFeat + (String)deprelsListl0.get(j));
                }
            }
        }
        if ((numr0Deprels = deprelsr0.size()) > 1) {
            ArrayList<String> deprelsListr0 = new ArrayList<String>(deprelsr0);
            Collections.sort(deprelsListr0);
            for (int i4 = 0; i4 < numr0Deprels; ++i4) {
                String newFeat = "\u2fc6" + (String)deprelsListr0.get(i4);
                fts.add("\u1139" + tag[3] + "+" + (String)deprelsListr0.get(i4));
                fts.add("\u1139" + bc[3] + "+" + (String)deprelsListr0.get(i4));
                for (int j = 0; j < numr0Deprels; ++j) {
                    if (i4 == j) continue;
                    fts.add(newFeat + (String)deprelsListr0.get(j));
                }
            }
        }
        for (String deprell0 : deprelsl0) {
            String newFeat = deprell0 + "\u2fc1";
            fts.add(deprell0 + tag[3] + "\u2fc7");
            fts.add(deprell0 + bc[3] + "\u2fc7");
            String l0tdr0 = tag[2] + "\u2fc8";
            for (String deprelr0 : deprelsr0) {
                fts.add(l0tdr0 + deprelr0);
                fts.add(bc[2] + "+" + deprelr0);
                fts.add(newFeat + deprelr0);
            }
            String newFeat2 = deprell0 + "\u2fc2";
            for (String deprell1 : deprelsl1) {
                fts.add(newFeat2 + deprell1);
            }
        }
        for (String deprelr1 : deprelsr1) {
            String prefix = deprelr1 + "\u2fc3";
            for (String deprelr0 : deprelsr0) {
                fts.add(prefix + deprelr0);
            }
        }
        if (r0i < tokens.size() - 1) {
            String tag1 = this.getTag(tokens.get(r0i));
            String tag2 = this.getTag(tokens.get(r0i + 1));
            String twotags = tag1 + "+" + tag2;
            fts.add("\u3446r" + tag1);
            fts.add("\u3446r" + twotags);
        }
        fts.add("X" + tag[2] + "+" + tag[3] + "+" + bcrc[3]);
        fts.add("Y" + tag[2] + "+" + tag[3] + "+" + bcrc[2]);
        fts.add("\u2f27" + cpos[0]);
        fts.add(bc[0] + "\u2f27");
        fts.add("\u2f27" + cpos[1]);
        fts.add(bc[1] + "\u2f27");
        fts.add("\u2f28" + cpos[4]);
        fts.add(bc[4] + "\u2f28");
        fts.add("\u2f28" + cpos[5]);
        fts.add(bc[5] + "\u2f28");
        if (!(cpos[0].equals("VB") || cpos[1].equals("VB") || cpos[4].equals("VB") || cpos[5].equals("VB"))) {
            if (!cpos[2].equals("VB") && cpos[3].equals("VB")) {
                fts.add("r0LonelyVerb");
            } else if (cpos[2].equals("VB") && !cpos[3].equals("VB")) {
                fts.add("l0LonelyVerb");
            }
        }
        if ((tag[2].equals("JJ") || tag[2].equals("NN") || tag[2].equals("NNS") || tag[2].equals("NNP") || tag[2].equals("NNPS")) && this.hasTooModifier(tp[2].tok, currentArcs)) {
            fts.add("\u1143");
        }
        for (int i5 = 0; i5 < 5; ++i5) {
            int lseqi = this.lseq[i5];
            int rseqi = this.rseq[i5];
            String lf = frm[lseqi];
            String rf = frm[rseqi];
            String lt = tag[lseqi];
            String rt = tag[rseqi];
            String t2 = lt + "+" + rt + "+";
            fts.add(this.tt[i5] + t2);
            fts.add(lf + this.ww[i5] + rf);
            fts.add(lf + this.wt[i5] + rt);
            fts.add(rf + this.tw[i5] + lt);
            fts.add(this.tt[i5] + bc[lseqi] + "+" + bc[rseqi]);
            fts.add(t2 + lcpos[lseqi] + this.ttlclc[i5] + lcpos[rseqi]);
            fts.add(t2 + lcpos[lseqi] + this.ttlcrc[i5] + rcpos[rseqi]);
            fts.add(t2 + rcpos[lseqi] + this.ttrclc[i5] + lcpos[rseqi]);
            fts.add(t2 + rcpos[lseqi] + this.ttrcrc[i5] + rcpos[rseqi]);
        }
        fts.add("\u2fcc" + tag[1] + "+" + tag[4]);
        if (tag[1].equals(DUMMY_PART_OF_SPEECH) && tag[4].equals(DUMMY_PART_OF_SPEECH)) {
            fts.add("VR" + bc[2] + "+" + bc[3]);
            fts.add("\u2fcd" + tag[2] + "+" + tag[3]);
        }
        this.addPrepositionFeats(fts, cpos, tag, frm, rcpos, rcfrm, bc, bcrc);
    }

    private void addL1CCFeats(Token kidL1_1, Set<String> fts, String[] frm, String[] pos, String[] cpos, String[] tag, String[] rcpos, String[] lcpos) {
        fts.add(frm[1] + "\u2e92" + rcpos[1]);
        fts.add("l1CChasChild" + (kidL1_1 == this.mDummy.tok));
        fts.add(pos[2].equals(pos[0]) + "\u2fd0" + tag[3]);
        fts.add(cpos[2].equals(cpos[0]) + "\u2fd1" + tag[3]);
        fts.add(frm[2].equals(frm[0]) + "\u2fd2" + tag[3]);
        fts.add(pos[3].equals(pos[0]) + "\u2fd0" + tag[3]);
        fts.add(cpos[3].equals(cpos[0]) + "\u2fd1" + tag[3]);
        if (frm[3] != null) {
            fts.add(frm[3].equals(frm[0]) + "\u2fd2" + tag[3]);
        }
        fts.add(tag[0] + "+" + tag[2] + "+" + tag[3] + "+" + rcpos[0] + "\u2e96" + lcpos[0]);
        fts.add("\u2e99" + tag[0] + "+" + tag[2] + "+" + tag[3]);
    }

    private void addL0CCFeats(Token kidL0_1, Set<String> fts, String[] frm, String[] pos, String[] cpos, String[] rcpos) {
        fts.add(frm[2] + "\u2e93" + rcpos[2]);
        fts.add("l0HasChild" + (kidL0_1 == this.mDummy.tok));
        fts.add(pos[0] + "+" + pos[1] + "+" + pos[3]);
        fts.add(cpos[0] + "\u2ea2" + cpos[3]);
        fts.add(pos[3].equals(pos[1]) + "\u2fd4");
        fts.add(cpos[3].equals(cpos[1]) + "\u9824");
        fts.add((frm[3] != null && frm[3].equals(frm[1])) + "\u9824\u9824");
        fts.add(pos[3].equals(pos[0]) + "\u2fd3");
        fts.add(cpos[3].equals(cpos[0]) + "\u9826");
        fts.add((frm[3] != null && frm[3].equals(frm[0])) + "\u2fd3\u2fd3");
        fts.add(pos[4].equals(pos[1]) + "\u2fd5");
        fts.add(cpos[4].equals(cpos[1]) + "\u2fd52");
        fts.add((frm[4] != null && frm[4].equals(frm[1])) + "\u2fd53");
        fts.add(pos[4].equals(pos[0]) + "\u3005");
        fts.add(cpos[4].equals(cpos[0]) + "\u30052");
        fts.add((frm[4] != null && frm[4].equals(frm[0])) + "\u30053");
        fts.add(pos[5].equals(pos[1]) + "\u3007");
        fts.add(cpos[5].equals(cpos[1]) + "\u9823");
        fts.add((frm[5] != null && frm[5].equals(frm[1])) + "\u98233");
        fts.add(pos[5].equals(pos[0]) + "\u3023");
        fts.add(cpos[5].equals(cpos[0]) + "\u9821");
        fts.add((frm[5] != null && frm[5].equals(frm[0])) + "\u98213");
    }

    private void addR0CCFeats(Token kidR0_1, Set<String> fts, List[] currentArcs, Set<String> deprelsl2, Set<String> deprelsl1, Set<String> deprelsl0, String[] frm, String[] pos, String[] cpos, String[] rcpos, String[] rccpos, String[] rcfrm, TokenPointer[] tp) {
        boolean reql2;
        fts.add(frm[3] + "\u2e94" + rcpos[3]);
        fts.add((kidR0_1 != this.mDummy.tok) + "\u9829");
        if (kidR0_1 != this.mDummy.tok) {
            HashSet d = new HashSet();
            Set<String> r0cDeprels = this.addAllDeprels("", kidR0_1, currentArcs);
            for (String dep : r0cDeprels) {
                for (String l0deprel : deprelsl0) {
                    fts.add(dep + "\u3432" + l0deprel);
                }
                for (String l1deprel : deprelsl1) {
                    fts.add(dep + "\u3401" + l1deprel);
                }
                for (String l2deprel : deprelsl2) {
                    fts.add(dep + "\u3434" + l2deprel);
                }
            }
        }
        if (rcpos[3].equals(pos[2])) {
            fts.add("ZC==");
        }
        if (rccpos[3].equals(cpos[2])) {
            fts.add("ZC~~");
        }
        if (frm[2].equals(rcfrm[3])) {
            fts.add("ZC11");
        }
        if (frm[1] != null && frm[1].equals(rcfrm[3])) {
            fts.add("ZC7");
        }
        Token r0RCd = this.getDeterminer(kidR0_1, currentArcs);
        Token l0d = this.getDeterminer(tp[2].tok, currentArcs);
        Token l2d = this.getDeterminer(tp[0].tok, currentArcs);
        boolean isDefiniter0RCd = this.isDefinite(r0RCd);
        boolean isDefinitel0d = this.isDefinite(l0d);
        boolean isDefinitel2d = this.isDefinite(l2d);
        boolean reql0 = r0RCd != null && l0d != null && r0RCd.getText() != null && r0RCd.getText().equalsIgnoreCase(l0d.getText());
        boolean bl = reql2 = r0RCd != null && l2d != null && r0RCd.getText() != null && r0RCd.getText().equalsIgnoreCase(l2d.getText());
        if (reql0) {
            fts.add("\u2e9e" + reql0);
        }
        if (reql2) {
            fts.add("\u2e9f" + reql2);
        }
        if (reql2 && !reql0) {
            fts.add("\u2ea0");
        }
        fts.add("\u2ea1" + isDefinitel2d + "+" + isDefinitel0d + "+" + isDefiniter0RCd);
    }

    private void addR1CCFeats(Token kidsR1_1, Set<String> fts, List[] currentArcs, Set<String> deprelsl1, Set<String> deprelsl0, Set<String> deprelsr0, String[] tag, String[] frm, String[] rcpos, String[] rccpos, String[] cpos, String[] pos, String[] rcfrm) {
        fts.add(frm[4] + "\u2e95" + rcpos[4]);
        fts.add((kidsR1_1 != this.mDummy.tok) + "\u9834");
        if (kidsR1_1 != this.mDummy.tok) {
            Set<String> r1cDeprels = this.addAllDeprels("", kidsR1_1, currentArcs);
            for (String dep : r1cDeprels) {
                for (String r0deprel : deprelsr0) {
                    fts.add(dep + "\u3440" + r0deprel);
                }
                for (String l0deprel : deprelsl0) {
                    fts.add(dep + "\u3441" + l0deprel);
                }
                for (String l1deprel : deprelsl1) {
                    fts.add(dep + "\u3443" + l1deprel);
                }
            }
        }
        if (rcfrm[4] != null && rcfrm[4].equals(frm[1])) {
            fts.add("ZC10");
        }
        if (rcpos[4].equals(pos[2])) {
            fts.add("ZC==2");
        }
        if (rccpos[4].equals(cpos[2])) {
            fts.add("ZC~~2");
        }
        fts.add("ZC8" + frm[3].equals(frm[5]));
        fts.add("ZC9" + frm[3].equals(rcfrm[4]));
        fts.add(tag[2] + "+" + tag[3] + "+" + rcpos[4] + "\u2e9b" + tag[5]);
        if (frm[2].equals(frm[5])) {
            fts.add("ZC5");
        }
        if (frm[2].equals(rcfrm[4])) {
            fts.add("ZC6");
        }
        fts.add(pos[2] + "+" + pos[3] + "\u2fcf" + pos[5]);
    }

    private void addR2CCFeats(Token kidsR2_1, Set<String> fts, List[] currentArcs, Set<String> deprelsl0, Set<String> deprelsr0, String[] frm, String rcfrmR2, String rccposR2, String rcposR2, String[] cpos, String[] pos) {
        if (kidsR2_1 != this.mDummy.tok) {
            Set<String> r2cDeprels = this.addAllDeprels("", kidsR2_1, currentArcs);
            for (String dep : r2cDeprels) {
                for (String r0deprel : deprelsr0) {
                    fts.add(dep + "\u9842" + r0deprel);
                }
                for (String l0deprel : deprelsl0) {
                    fts.add(dep + "\u9844" + l0deprel);
                }
            }
            if (rcfrmR2.equals(frm[2])) {
                fts.add("ZC12frml0");
            }
            if (rcfrmR2.equals(frm[3])) {
                fts.add("ZC12");
            }
            if (rcfrmR2.equals(frm[4])) {
                fts.add("ZC12frm1");
            }
            if (cpos[4].equals(rccposR2)) {
                fts.add("dCCcpos1");
                if (pos[4].equals(rcposR2)) {
                    fts.add("dCCpos1");
                }
            }
            if (rccposR2.equals(cpos[3])) {
                fts.add("dCCcpos0");
                if (rcposR2.equals(pos[3])) {
                    fts.add("dCCpos0");
                }
            }
            if (rccposR2.equals(cpos[2])) {
                fts.add("dCCcposl0");
                if (rcposR2.equals(pos[2])) {
                    fts.add("dCCposl0");
                }
            }
        } else {
            fts.add("dCCr1");
        }
    }

    private void addPrepositionFeats(Collection<String> fts, String[] cpos, String[] tag, String[] frm, String[] rcpos, String[] rcfrm, String[] bc, String[] bcrc) {
        if (tag[2].startsWith("IN")) {
            fts.add(this.getSubstring(frm[1], 4) + "+" + frm[2] + "\u2fb7" + rcpos[2]);
            fts.add(frm[2] + "+" + tag[1] + "\u2fb8" + rcfrm[2]);
            fts.add("\u2fb7" + bc[1] + "+" + bc[2] + "+" + bcrc[2]);
            fts.add(tag[1] + "+" + bc[2] + "\u2fb8" + bcrc[2]);
        }
        if (tag[3].startsWith("IN")) {
            fts.add(this.getSubstring(frm[0], 4) + "+" + frm[3] + "\u2fb9" + rcpos[3]);
            fts.add(frm[3] + "+" + tag[0] + "\u2fba" + rcfrm[3]);
            fts.add(this.getSubstring(frm[1], 4) + "+" + frm[3] + "\u2fb9" + rcpos[3]);
            fts.add(frm[3] + "+" + tag[1] + "\u2fba" + rcfrm[3]);
            fts.add(this.getSubstring(frm[2], 4) + "+" + frm[3] + "\u2fbb" + rcpos[3]);
            fts.add(frm[3] + "+" + tag[2] + "\u2fbc" + rcfrm[3]);
            fts.add("\u2fbb" + bc[2] + "+" + bc[3] + "+" + bcrc[3]);
            fts.add("\u2fbc" + tag[2] + "+" + bc[3] + "+" + bcrc[3]);
            if (!rcpos[3].equals(DUMMY_PART_OF_SPEECH)) {
                fts.add(this.getSubstring(frm[1], 4) + "+" + cpos[2] + "\u114d" + frm[3]);
                fts.add(this.getSubstring(frm[1], 4) + "+" + tag[2] + "\u114e" + frm[3]);
                fts.add("haschild\u114f");
                fts.add(this.getSubstring(frm[2], 4) + "+" + frm[3] + "\u1150" + tag[4]);
                fts.add(this.getSubstring(frm[0], 4) + "\u2fb9" + frm[3]);
                fts.add(tag[0] + "\u2fba" + frm[3]);
                fts.add(this.getSubstring(frm[1], 4) + "\u2fb9" + frm[3]);
                fts.add(tag[1] + "\u2fba" + frm[3]);
                fts.add(frm[2] + "\u2fbb" + frm[3]);
                fts.add(tag[2] + "\u2fbc" + frm[3]);
            }
        }
        if (tag[4].startsWith("IN")) {
            fts.add(this.getSubstring(frm[3], 4) + "+" + frm[4] + "\u2fbd" + rcpos[4]);
            fts.add(frm[4] + "+" + tag[3] + "\u2fbe" + rcfrm[4]);
            fts.add(this.getSubstring(frm[2], 4) + "+" + frm[4] + "\u2fbf" + rcpos[4]);
            fts.add(frm[4] + "+" + tag[2] + "\u2fc0" + rcfrm[4]);
            fts.add("\u2fbf" + bc[2] + "+" + bc[4]);
            fts.add(tag[2] + "\u2fc0" + bc[4]);
            fts.add(bc[2] + "\u2fbf" + bc[4] + "+" + bcrc[4]);
            fts.add(tag[2] + "\u2fc0" + bc[4] + "+" + bcrc[4]);
        }
    }

    private String getSubstring(String s, int size) {
        if (s == null) {
            return null;
        }
        return s.length() > 0 ? s.substring(0, Math.min(size, s.length())) : " ";
    }

    private boolean hasTooModifier(Token t, List[] currentArcs) {
        boolean hasTooModifier = false;
        List arcs = currentArcs[t.getIndex()];
        if (arcs != null) {
            for (Arc arc : arcs) {
                String text = arc.getChild().getText().toLowerCase();
                if (!text.equals("too") && !text.equals("enough")) continue;
                hasTooModifier = true;
                break;
            }
        }
        return hasTooModifier;
    }

    private Arc getDeprel(Token t, List[] currentArcs, String deprelString) {
        Arc deprel = null;
        List arcs = currentArcs[t.getIndex()];
        if (arcs != null) {
            for (Arc a : arcs) {
                if (!a.getDependency().equals(deprelString)) continue;
                deprel = a;
                break;
            }
        }
        return deprel;
    }

    private boolean isDefinite(Token t) {
        return t == null ? false : this.definiteDeterminers.contains(t.getText().toLowerCase()) || t.getPos().equals("PRP$");
    }

    private Token getDeterminer(Token t, List[] currentArcs) {
        Token determiner = null;
        List arcs = currentArcs[t.getIndex()];
        int ti = t.getIndex();
        if (arcs != null) {
            block0: for (Arc arc : arcs) {
                Token child;
                String arcDependency = arc.getDependency();
                if (!arcDependency.equals("det") && !arcDependency.equals("poss") || (child = arc.getChild()).getIndex() >= ti) continue;
                String childPos = child.getPos();
                if (childPos.endsWith("DT")) {
                    determiner = child;
                    break;
                }
                if (childPos.equals("PRP$") || childPos.equals("WP$")) {
                    determiner = child;
                    break;
                }
                List grandChildArcs = currentArcs[child.getIndex()];
                if (grandChildArcs == null) continue;
                for (Arc grandDependent : grandChildArcs) {
                    if (!grandDependent.getDependency().equals("possessive")) continue;
                    determiner = grandDependent.getChild();
                    continue block0;
                }
            }
        }
        return determiner;
    }

    private Set<String> addAllDeprels(String prefix, Token t, List[] tokenToArcs) {
        HashSet<String> additions = new HashSet<String>();
        List arcs = tokenToArcs[t.getIndex()];
        if (arcs != null) {
            String ldep = "l" + prefix;
            String rdep = "r" + prefix;
            int tIndex = t.getIndex();
            for (Arc arc : arcs) {
                String childForm;
                String dep = arc.getDependency();
                Token child = arc.getChild();
                String childPos = child.getPos();
                String feat = (tIndex < arc.getChild().getIndex() ? rdep : ldep) + dep;
                if (dep.equals("punct") || dep.equals("prep")) {
                    feat = feat + this.getForm(child);
                } else if (dep.equals("advmod")) {
                    feat = feat + this.getBC(this.getForm(child));
                } else if (dep.equals("nsubj") && (childForm = this.getForm(child)).equalsIgnoreCase("it")) {
                    feat = feat + "it";
                }
                if (COMMON_RELATIVE_PRON_POSITIONS.contains(dep) && (childPos.equals("WP") || childPos.equals("WDT") || this.hasSecondLevelRelativePronoun(child, tokenToArcs))) {
                    additions.add(prefix + "\u2fce");
                }
                additions.add(feat);
            }
        }
        return additions;
    }

    private boolean hasSecondLevelRelativePronoun(Token t, List[] tokenToArcs) {
        boolean hasSecondLevelRelativePronoun = false;
        List arcs = tokenToArcs[t.getIndex()];
        if (arcs != null) {
            block0: for (Arc a : arcs) {
                List subarcs;
                String dependency = a.getDependency();
                if (dependency.equals("poss")) {
                    if (!a.getChild().getPos().equals("WP$")) break;
                    hasSecondLevelRelativePronoun = true;
                    break;
                }
                if (!dependency.equals("prep") || (subarcs = tokenToArcs[a.getChild().getIndex()]) == null) continue;
                for (Arc subarc : subarcs) {
                    String subArcChildPos = subarc.getChild().getPos();
                    if (!subArcChildPos.equals("WP") && !subArcChildPos.equals("WDT")) continue;
                    hasSecondLevelRelativePronoun = true;
                    break block0;
                }
            }
        }
        return hasSecondLevelRelativePronoun;
    }

    private Token[] getLRchildren(Token t, List[] tokenToArcs) {
        Token[] result = new Token[]{this.mDummy.tok, this.mDummy.tok};
        List arcs = tokenToArcs[t.getIndex()];
        Arc leftmostArc = null;
        Arc rightmostArc = null;
        if (arcs != null && arcs.size() > 0) {
            int tokenIndex = t.getIndex();
            for (Arc arc : arcs) {
                int arcChildIndex = arc.getChild().getIndex();
                if (arcChildIndex < tokenIndex) {
                    if (leftmostArc != null && arcChildIndex >= leftmostArc.getChild().getIndex()) continue;
                    leftmostArc = arc;
                    continue;
                }
                if (rightmostArc != null && arcChildIndex <= rightmostArc.getChild().getIndex()) continue;
                rightmostArc = arc;
            }
        }
        if (leftmostArc != null) {
            result[0] = leftmostArc.getChild();
        }
        if (rightmostArc != null) {
            result[1] = rightmostArc.getChild();
        }
        return result;
    }

    @Override
    public int getContextWidth() {
        return 6;
    }
}

