/*
 * Decompiled with CFR 0.152.
 */
package tratz.featgen.fer;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tratz.featgen.fer.AbstractFeatureRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClosedClassFER
extends AbstractFeatureRule {
    public static final long serialVersionUID = 1L;
    private static final String CORRELATIVE_CONJUNCTIVES = "either|neither|both";
    private static final String PERSONAL_PRONOUN = "he|she|me|i|we|us|him|'im|her|'er|they|them|'em";
    private static final String RELATIVE_PRONOUN = "that|who|which";
    private static final String INDEFINITE_PRONOUN = "something|anything|nothing|everythingsomebody|anybody|nobody|everybodysomeone|anyone|none|everyoneanother|other|few|several|both|others|some|none|most|more|any|all";
    private static final String WHPRONOUN = "whoever|whatever|whichever|who|what|where|how|which|whose";
    private static final String WHADVERB = "how|when|wherever|whenever|whence|whither|where|why|whereof";
    private static final String CURRENCY_SYMBOLS = "(A|H|HK|C|NZ)?\\$|\u00a2|\u00a3|#|\u00a4|\u00a5|\u20a0|\u20a1|\u20a2|\u20a3|\u20a4|\u20a6|\u20a7|\u20a8|\u20a9|\u20aa|\u20ab|\u20ac|\u20ad|\u20ae|\u20af|\u20b0|\u20b1|\u20b2|\u20b3|\u20b4|\u20b5";
    private static final String AUXILLARIES = "being|be|been|was|were|is|ai|are|am|'s|'re|do|did|does|doth|has|have|'ve|had|having|'d|hath";
    private static final String MODALS = "can|could|will|'ll|wo|would|'d|shall|shalt|should|may|might|must";
    private static final String PREPOSITIONS = "unto|cum|circa|aside|en|above|aboard|about|absent|across|after|against|along|alongside|amid|amidst|among|amongst|around|as|astride|at|atop|athwart|before|behind|below|beneath|beside|between|beyond|by|despite|down|during|except|pending|for|from|like|in|inside|into|minus|modulo|near|notwithstanding|of|off|on|onboard|onto|opposite|out|outside|outwith|over|pace|past|per|round|sans|than|through|thru|throughout|to|toward|towards|unlike|under|underneath|until|up|upon|upside|versus|via|with|within|without";
    private static final String ARTICLE = "a|the|an";
    private static final String DEMONSTRATIVE = "this|that|these|those|which";
    private static final String PERSONAL_POSSESSIVE = "my|our|your|his|her|thy|its";
    private static final String UNIVERSAL_DETERMINER = "all|both";
    private static final String DISTRIBUTIVE_DETERMINER = "every|each";
    private static final String DEGREE_DETERMINER = "many|much|few|little";
    private static final String EXISTENTIAL_DETERMINER = "some|several|any|no";
    private static final String DISJUNCTIVE_DETERMINER = "either|neither";
    private static final String ALTERNATIVEADDITIONAL_DETERMINER = "another|other";
    private static final String QUANTIFIER_DETERMINER = "all|both|every|each|many|much|few|little|some|several|any|no";
    private Matcher mCoordinatingConj = Pattern.compile("minus|plus|times|and|or|but|yet|so|\\&", 2).matcher("");
    private Matcher mSubordinatingConj = Pattern.compile("that|for|wherein|whereby|whereas|whereupon|wherewith|wherefore|lest|whether|than|when|where|'till|'til|till|til|until|if|unless|since|because|while|though|although|so|before|after|cos|'cos|'cause|whilst|whenever|lest", 2).matcher("");
    private Matcher mCorrelativeConjunctives = Pattern.compile("either|neither|both", 2).matcher("");
    private Matcher mFirstPerson = Pattern.compile("I|we|us|my|myself|our|ourselves|ours", 2).matcher("");
    private Matcher mSecondPerson = Pattern.compile("you|your|yourself|yourselves|yours|thyself", 2).matcher("");
    private Matcher mThirdPerson = Pattern.compile("he|she|they|it|him|'m|her|hers|them|'em|herself|'imself|himself|themselves|ourselves", 2).matcher("");
    private Matcher mAccusative = Pattern.compile("you|thee|me|us|him|'im|her|'er|them|'em|yourself|yourselves|thyself|myself|herself|'imself|himself|themselves|ourselves|it|itself", 2).matcher("");
    private Matcher mNominative = Pattern.compile("you|thou|ye|i|he|she|they|we|it", 2).matcher("");
    private Matcher mPronouns = Pattern.compile("he|she|me|i|we|us|him|'im|her|'er|they|them|'em|that|who|which|something|anything|nothing|everythingsomebody|anybody|nobody|everybodysomeone|anyone|none|everyoneanother|other|few|several|both|others|some|none|most|more|any|all", 2).matcher("");
    private Matcher mPersonalPronoun = Pattern.compile("he|she|me|i|we|us|him|'im|her|'er|they|them|'em", 2).matcher("");
    private Matcher mRelativePronouns = Pattern.compile("that|who|which", 2).matcher("");
    private Matcher mWHPronoun = Pattern.compile("whoever|whatever|whichever|who|what|where|how|which|whose", 2).matcher("");
    private Matcher mWHAdverb = Pattern.compile("how|when|wherever|whenever|whence|whither|where|why|whereof", 2).matcher("");
    private Matcher mPrepositions = Pattern.compile("unto|cum|circa|aside|en|above|aboard|about|absent|across|after|against|along|alongside|amid|amidst|among|amongst|around|as|astride|at|atop|athwart|before|behind|below|beneath|beside|between|beyond|by|despite|down|during|except|pending|for|from|like|in|inside|into|minus|modulo|near|notwithstanding|of|off|on|onboard|onto|opposite|out|outside|outwith|over|pace|past|per|round|sans|than|through|thru|throughout|to|toward|towards|unlike|under|underneath|until|up|upon|upside|versus|via|with|within|without", 2).matcher("");
    private Matcher mDeterminer = Pattern.compile("a|the|an|this|that|these|those|which|either|neither|all|both|every|each|many|much|few|little|some|several|any|no|another|other|my|our|your|his|her|thy|its|their|its|", 2).matcher("");
    private Matcher mArticle = Pattern.compile("a|the|an", 2).matcher("");
    private Matcher mDemonstratives = Pattern.compile("this|that|these|those|which", 2).matcher("");
    private Matcher mDisjunctiveDeterminer = Pattern.compile("either|neither", 2).matcher("");
    private Matcher mAlternativeAdditive = Pattern.compile("another|other", 2).matcher("");
    private Matcher mPossessiveDeterminer = Pattern.compile("my|our|your|his|her|thy|its|their|its", 2).matcher("");
    private Matcher mQuantifierDeterminer = Pattern.compile("all|both|every|each|many|much|few|little|some|several|any|no", 2).matcher("");
    private Matcher mDistributiveDeterminer = Pattern.compile("every|each", 2).matcher("");
    private Matcher mUniversalDeterminer = Pattern.compile("all|both", 2).matcher("");
    private Matcher mExistentialDeterminer = Pattern.compile("some|several|any|no", 2).matcher("");
    private Matcher mDegreeDeterminer = Pattern.compile("many|much|few|little", 2).matcher("");
    private Matcher mModal = Pattern.compile("can|could|will|'ll|wo|would|'d|shall|shalt|should|may|might|must", 2).matcher("");
    private Matcher mAux = Pattern.compile("being|be|been|was|were|is|ai|are|am|'s|'re|do|did|does|doth|has|have|'ve|had|having|'d|hath", 2).matcher("");
    private Matcher mPersonalPossessive = Pattern.compile("my|our|your|his|her|thy|its", 2).matcher("");
    private Matcher mCurrencySymbol = Pattern.compile("(A|H|HK|C|NZ)?\\$|\u00a2|\u00a3|#|\u00a4|\u00a5|\u20a0|\u20a1|\u20a2|\u20a3|\u20a4|\u20a6|\u20a7|\u20a8|\u20a9|\u20aa|\u20ab|\u20ac|\u20ad|\u20ae|\u20af|\u20b0|\u20b1|\u20b2|\u20b3|\u20b4|\u20b5").matcher("");

    private static final boolean match(String text, Matcher matcher) {
        matcher.reset(text);
        return matcher.matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getProductions(String input, String type, Set<String> fs) {
        ClosedClassFER closedClassFER = this;
        synchronized (closedClassFER) {
            if (ClosedClassFER.match(input, this.mPrepositions)) {
                fs.add("IN");
            }
            if (ClosedClassFER.match(input, this.mCurrencySymbol)) {
                fs.add("$");
            }
            if (ClosedClassFER.match(input, this.mModal)) {
                fs.add("MOD");
            }
            if (ClosedClassFER.match(input, this.mAux)) {
                fs.add("AUX");
            }
            if (ClosedClassFER.match(input, this.mSubordinatingConj)) {
                fs.add("sc");
            }
            if (ClosedClassFER.match(input, this.mAccusative)) {
                fs.add("acc");
            } else if (ClosedClassFER.match(input, this.mNominative)) {
                fs.add("nom");
            }
            if (ClosedClassFER.match(input, this.mPronouns) && !ClosedClassFER.match(input, this.mRelativePronouns)) {
                if (ClosedClassFER.match(input, this.mPersonalPronoun)) {
                    fs.add("pprn");
                } else if (ClosedClassFER.match(input, this.mWHPronoun)) {
                    // empty if block
                }
            }
            if (ClosedClassFER.match(input, this.mPersonalPossessive)) {
                fs.add("pposs");
            }
            if (input.equalsIgnoreCase("n't") || input.equalsIgnoreCase("not")) {
                fs.add("not");
            }
        }
        return fs;
    }
}

