/*
 * Decompiled with CFR 0.152.
 */
package tratz.featgen.fer;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import tratz.featgen.InitException;
import tratz.featgen.fer.AbstractFeatureRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrownClusterFER
extends AbstractFeatureRule {
    public static final long serialVersionUID = 1L;
    public static final String PARAM_DATA_FILE = "dataFile";
    public static final String PARAM_MIN_WORD_OCCURRENCE = "minOccurrence";
    public static final String PARAM_MAX_DEPTH = "maxDepth";
    private Map<String, String> mFeatMap = new HashMap<String, String>();

    @Override
    public void init(Map<String, String> params) throws InitException {
        String dataFile = params.get(PARAM_DATA_FILE);
        String maxDepthS = params.get(PARAM_MAX_DEPTH);
        String minOccurrenceS = params.get(PARAM_MIN_WORD_OCCURRENCE);
        int minOccurrence = minOccurrenceS == null ? 1 : Integer.parseInt(minOccurrenceS);
        int maxDepth = maxDepthS == null ? Integer.MAX_VALUE : Integer.parseInt(maxDepthS);
        try {
            BufferedReader reader = new BufferedReader(new FileReader(dataFile));
            String line = null;
            while ((line = reader.readLine()) != null) {
                String[] split = line.split("\\t+");
                String path = split[0];
                String token = split[1];
                int occurrences = Integer.parseInt(split[2]);
                if (occurrences < minOccurrence) continue;
                this.mFeatMap.put(token, path.substring(0, Math.min(path.length(), maxDepth)));
            }
            reader.close();
        }
        catch (IOException ioe) {
            throw new InitException(ioe);
        }
    }

    @Override
    public Set<String> getProductions(String text, String pos, Set<String> productions) {
        String path = this.mFeatMap.get(text);
        if (path != null) {
            productions.add(path);
        }
        return productions;
    }
}

