/*
 * Decompiled with CFR 0.152.
 */
package tratz.parse;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import tratz.jwni.WordNet;
import tratz.ml.ClassScoreTuple;
import tratz.parse.NLParser;
import tratz.parse.transform.VchTransformer;
import tratz.parse.types.Arc;
import tratz.parse.types.Parse;
import tratz.parse.types.Sentence;
import tratz.parse.types.Token;
import tratz.pos.PosTagger;
import tratz.semantics.ClassificationBundle;

public class FullSystemWrapper {
    public static final String[] POSSESSIVE_DEPENDENCY_RELATIONS = new String[]{"poss"};
    public static final String[] NOUN_COMPOUND_DEPENDENCY_RELATIONS = new String[]{"nn"};
    public static final String[] PREPOSITION_DEPENDENCY_RELATIONS = new String[]{"prep", "agent", "cop"};
    private NLParser mParser;
    private PosTagger mPosTagger;
    private ClassificationBundle mPsdWrapper = null;
    private ClassificationBundle mNnWrapper = null;
    private ClassificationBundle mPossWrapper = null;
    private ClassificationBundle mSrlArgsWrapper = null;
    private ClassificationBundle mSrlPredicatesWrapper = null;

    public FullSystemWrapper(String prepositionModelFile, String nounCompoundModelFile, String possessivesModelFile, String srlArgsModelFile, String srlPredicatesModelFile, String posModelFile, String parseModelFile, String wnDir) throws IOException, ClassNotFoundException {
        if (prepositionModelFile != null) {
            this.mPsdWrapper = FullSystemWrapper.readBundle(new File(prepositionModelFile), "preposition disambiguation models");
        }
        if (nounCompoundModelFile != null) {
            this.mNnWrapper = FullSystemWrapper.readBundle(new File(nounCompoundModelFile), "noun compound interpretation model");
        }
        if (possessivesModelFile != null) {
            this.mPossWrapper = FullSystemWrapper.readBundle(new File(possessivesModelFile), "possessives interpretation model");
        }
        if (srlArgsModelFile != null) {
            this.mSrlArgsWrapper = FullSystemWrapper.readBundle(new File(srlArgsModelFile), "semantic role labeling models (arguments and adjuncts)");
        }
        if (srlPredicatesModelFile != null) {
            this.mSrlPredicatesWrapper = FullSystemWrapper.readBundle(new File(srlPredicatesModelFile), "semantic role labeling models (predicate disambiguation)");
        }
        if (wnDir != null) {
            System.err.print("Loading WordNet...");
            new WordNet(new File(wnDir));
            System.err.println("Done");
        }
        if (posModelFile != null) {
            System.err.print("Loading POS-tagging model...");
            this.mPosTagger = FullSystemWrapper.readPosTagger(posModelFile);
            System.err.println("Done");
        }
        System.err.print("Loading parsing model...");
        this.mParser = new NLParser(parseModelFile);
        System.err.println("Done");
    }

    public FullSystemWrapper(NLParser parser, PosTagger posTagger, ClassificationBundle psdWrapper, ClassificationBundle nnWrapper, ClassificationBundle possWrapper, ClassificationBundle srlArgsWrapper, ClassificationBundle srlPredicatesWrapper) {
        this.mParser = parser;
        this.mPosTagger = posTagger;
        this.mNnWrapper = nnWrapper;
        this.mPossWrapper = possWrapper;
        this.mSrlArgsWrapper = srlArgsWrapper;
        this.mSrlPredicatesWrapper = srlPredicatesWrapper;
    }

    public FullSystemResult process(Sentence sentence, boolean doPosTag, boolean doParse, boolean doPrepDisambiguation, boolean doNnDisambiguation, boolean doPossInterp, boolean doSrl) {
        List<Token> tokens = sentence.getTokens();
        int numTokens = tokens.size();
        if (doPosTag && this.mPosTagger != null) {
            this.mPosTagger.posTag(tokens);
        }
        Parse parse = null;
        Parse srlLabeledParse = null;
        if (doParse) {
            parse = this.mParser.parseSentence(sentence);
            if (doPrepDisambiguation) {
                FullSystemWrapper.performSemanticAnnotation(this.mPsdWrapper, sentence, parse, PREPOSITION_DEPENDENCY_RELATIONS);
            }
            if (doNnDisambiguation) {
                FullSystemWrapper.performSemanticAnnotation(this.mNnWrapper, sentence, parse, NOUN_COMPOUND_DEPENDENCY_RELATIONS);
            }
            if (doPossInterp) {
                FullSystemWrapper.performSemanticAnnotation(this.mPossWrapper, sentence, parse, POSSESSIVE_DEPENDENCY_RELATIONS);
            }
            if (doSrl) {
                srlLabeledParse = FullSystemWrapper.performSrlAnnotation(this.mSrlArgsWrapper, this.mSrlPredicatesWrapper, sentence, parse);
            }
        } else {
            parse = new Parse(sentence, null, null);
        }
        return new FullSystemResult(parse, srlLabeledParse);
    }

    private static void performSemanticAnnotation(ClassificationBundle classifier, Sentence sentence, Parse parse, String[] dependencyTypes) {
        if (classifier != null) {
            List<Token> tokens = sentence.getTokens();
            Arc[] tokenToHeadArc = parse.getHeadArcs();
            int numTokens = tokens.size();
            block0: for (int i = 0; i < numTokens; ++i) {
                Token tok = tokens.get(i);
                Arc arc = tokenToHeadArc[tok.getIndex()];
                if (arc == null) continue;
                String dep = arc.getDependency();
                for (String depType : dependencyTypes) {
                    if (!dep.equals(depType)) continue;
                    Token t = arc.getChild();
                    ClassScoreTuple[] decision = classifier.getPredictions(dep, sentence.getTokens(), parse, t.getIndex() - 1);
                    if (decision == null || decision.length <= 0) continue block0;
                    t.setLexSense(decision[0].clazz);
                    continue block0;
                }
            }
        }
    }

    private static Parse performSrlAnnotation(ClassificationBundle srlArgsWrapper, ClassificationBundle srlPredicatesWrapper, Sentence sentence, Parse parse) {
        Parse vchTransformedParse = null;
        List<Token> tokens = sentence.getTokens();
        int numTokens = tokens.size();
        Arc[] tokenToHead = parse.getHeadArcs();
        if (srlArgsWrapper != null && srlPredicatesWrapper != null) {
            int t;
            ArrayList<Arc> arcsCopy = new ArrayList<Arc>();
            for (t = 0; t < numTokens; ++t) {
                Arc orig = tokenToHead[t];
                if (orig == null) continue;
                Arc newArc = new Arc(orig.getChild(), orig.getHead(), orig.getDependency());
                newArc.setCreationNum(orig.getCreationNum());
                arcsCopy.add(newArc);
            }
            vchTransformedParse = new Parse(parse.getSentence(), parse.getRoot(), arcsCopy);
            new VchTransformer().performTransformation(vchTransformedParse);
            for (t = 0; t < numTokens; ++t) {
                Token tok;
                ClassScoreTuple[] predictions;
                ClassScoreTuple[] predictions2;
                Arc arc = vchTransformedParse.getHeadArcs()[t];
                if (arc != null && (predictions2 = srlArgsWrapper.getPredictions(arc.getDependency(), tokens, vchTransformedParse, arc.getChild().getIndex() - 1)) != null && predictions2.length > 0) {
                    arc.setSemanticAnnotation(predictions2[0].clazz);
                }
                if ((predictions = srlPredicatesWrapper.getPredictions(null, tokens, vchTransformedParse, (tok = tokens.get(t)).getIndex() - 1)) == null || predictions.length <= 0) continue;
                tok.setLexSense(predictions[0].clazz);
            }
        }
        return vchTransformedParse;
    }

    public static ClassificationBundle readBundle(File inputFile, String name) throws IOException, ClassNotFoundException {
        System.err.print("Loading " + name + "...");
        ObjectInputStream ois = new ObjectInputStream(new GZIPInputStream(new FileInputStream(inputFile)));
        ClassificationBundle bundle = (ClassificationBundle)ois.readObject();
        ois.close();
        System.err.println("Done");
        return bundle;
    }

    public static PosTagger readPosTagger(String posModelFile) throws IOException, ClassNotFoundException {
        return new PosTagger(new File(posModelFile)){

            @Override
            public void posTag(List<Token> sentenceTokens) {
                int numTokens = sentenceTokens.size();
                for (int j = 0; j < numTokens; ++j) {
                    Token t = sentenceTokens.get(j);
                    String tText = t.getText();
                    if (tText.equals(".")) {
                        t.setPos(".");
                        continue;
                    }
                    if (tText.equals(",")) {
                        t.setPos(",");
                        continue;
                    }
                    Set<String> feats = this.mFeatureGenerator.getFeats(sentenceTokens, j);
                    ClassScoreTuple[] classRankings = this.mDecisionModule.getDecision(feats);
                    t.setPos(classRankings[0].clazz);
                }
            }
        };
    }

    public static class FullSystemResult
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Parse mParse;
        private Parse mSrlParse;

        public FullSystemResult(Parse parse, Parse srlParse) {
            this.mParse = parse;
            this.mSrlParse = srlParse;
        }

        public Parse getParse() {
            return this.mParse;
        }

        public Parse getSrlParse() {
            return this.mSrlParse;
        }
    }
}

