/*
 * Decompiled with CFR 0.152.
 */
package tratz.featgen.fer;

import java.util.Set;
import tratz.featgen.fer.AbstractFeatureRule;
import tratz.jwni.IndexEntry;
import tratz.jwni.POS;
import tratz.jwni.WordNet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsLexicalizedFER
extends AbstractFeatureRule {
    private static final long serialVersionUID = 1L;

    @Override
    public Set<String> getProductions(String input, String type, Set<String> productions) {
        String[] parts = input.split("\\s+");
        if (parts.length == 2) {
            String pl = parts[0];
            String pr = parts[1];
            IndexEntry e1 = null;
            if (WordNet.getInstance().lookupIndexEntry(POS.NOUN, pl + pr) != null || (e1 = WordNet.getInstance().lookupIndexEntry(POS.NOUN, pl + " " + pr)) != null && e1.getLemma().contains("_")) {
                productions.add("islexicalized");
            }
        }
        return productions;
    }
}

