/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.lang;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.pnuts.lang.UnparseVisitor;
import pnuts.lang.ParseException;
import pnuts.lang.Runtime;
import pnuts.lang.SimpleNode;

public class NodeUtil {
    static String ENCODING = "UTF-8";

    public static void writeNode(ObjectOutputStream o, SimpleNode node) throws IOException {
        ByteArray ba = new ByteArray();
        NodeUtil.save(node, ba);
        byte[] bytes = ba.getByteArray();
        int count = ba.size();
        o.writeInt(count);
        o.write(bytes, 0, count);
        o.flush();
    }

    public static SimpleNode readNode(ObjectInputStream in) throws IOException, ParseException {
        int len = in.readInt();
        byte[] buf = new byte[len];
        in.readFully(buf);
        return NodeUtil.parseNode(new ByteArrayInputStream(buf));
    }

    static SimpleNode parseNode(InputStream in) throws IOException, ParseException {
        return NodeUtil.parseNode(new BufferedReader(new InputStreamReader(in, ENCODING)));
    }

    public static SimpleNode parseNode(String str) {
        try {
            return NodeUtil.parseNode(new StringReader(str));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static SimpleNode parseNode(Reader in) throws IOException, ParseException {
        int i;
        int id = 0;
        int line = 0;
        int column = 0;
        String image = null;
        String info = null;
        Character c = null;
        ArrayList<SimpleNode> nodes = new ArrayList<SimpleNode>();
        int ch = in.read();
        int state = 0;
        StringBuffer sb = new StringBuffer();
        block9: while (ch != -1) {
            switch (state) {
                case 0: {
                    if (ch == 40) {
                        state = 1;
                        break;
                    }
                    if (ch == 41) {
                        return null;
                    }
                    throw new RuntimeException(String.valueOf(ch));
                }
                case 1: {
                    if (ch == 44) {
                        id = Integer.parseInt(sb.toString());
                        sb.setLength(0);
                        if (id == 27) {
                            int len = NodeUtil.readInt(in);
                            for (i = 0; i < len; ++i) {
                                sb.append((char)in.read());
                            }
                            image = sb.toString();
                            sb.setLength(0);
                            in.read();
                            state = 3;
                            break;
                        }
                        state = 2;
                        break;
                    }
                    sb.append((char)ch);
                    break;
                }
                case 2: {
                    if (ch == 44) {
                        image = sb.toString();
                        sb.setLength(0);
                        state = 3;
                        break;
                    }
                    sb.append((char)ch);
                    break;
                }
                case 3: {
                    if (ch == 44) {
                        line = Integer.parseInt(sb.toString());
                        sb.setLength(0);
                        state = 4;
                        break;
                    }
                    sb.append((char)ch);
                    break;
                }
                case 4: {
                    if (ch == 44) {
                        column = Integer.parseInt(sb.toString());
                        sb.setLength(0);
                        state = 5;
                        break;
                    }
                    sb.append((char)ch);
                    break;
                }
                case 5: {
                    if (id == 26) {
                        c = new Character((char)ch);
                        in.read();
                        state = 6;
                        break;
                    }
                    if (ch == 44) {
                        String str = sb.toString();
                        if (!str.startsWith("{")) {
                            info = str;
                        }
                        sb.setLength(0);
                        state = 6;
                    } else {
                        sb.append((char)ch);
                        break;
                    }
                }
                case 6: {
                    SimpleNode n;
                    if (ch == 41 || (n = NodeUtil.parseNode(in)) == null) break block9;
                    nodes.add(n);
                }
            }
            ch = in.read();
        }
        SimpleNode n = new SimpleNode(id);
        n.str = image;
        if (id == 24) {
            n.info = Runtime.parseInt(image);
        } else if (id == 25) {
            n.info = Runtime.parseFloat(image);
        } else if (id == 26) {
            n.info = c;
        }
        n.beginLine = line;
        n.beginColumn = column;
        i = 0;
        Iterator it = ((AbstractList)nodes).iterator();
        while (it.hasNext()) {
            SimpleNode cn = (SimpleNode)it.next();
            cn.jjtSetParent(n);
            n.jjtAddChild(cn, i++);
        }
        return n;
    }

    public static String saveNode(SimpleNode node, StringBuffer sb) {
        try {
            sb.setLength(0);
            ByteArray ba = new ByteArray();
            NodeUtil.save(node, ba);
            byte[] bytes = ba.getByteArray();
            int count = ba.size();
            return NodeUtil.byteArrayToString(bytes, count, sb);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String saveNode(SimpleNode node) {
        return NodeUtil.saveNode(node, new StringBuffer());
    }

    static void writeDigits(OutputStream os, int d) throws IOException {
        NodeUtil.writeString(os, Integer.toString(d));
    }

    static void writeInt(OutputStream out, int v) throws IOException {
        out.write(v >>> 24 & 0xFF);
        out.write(v >>> 16 & 0xFF);
        out.write(v >>> 8 & 0xFF);
        out.write(v >>> 0 & 0xFF);
    }

    static int readInt(Reader in) throws IOException {
        int ch1 = in.read();
        int ch2 = in.read();
        int ch3 = in.read();
        int ch4 = in.read();
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    static void writeString(OutputStream os, String s) throws IOException {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c < '\u0080') {
                os.write(c);
                continue;
            }
            if (c < '\u0800') {
                os.write(192 + (c >> 6));
                os.write(128 + (c & 0x3F));
                continue;
            }
            os.write(224 + (c >> 12));
            os.write(128 + (c >> 6 & 0x3F));
            os.write(128 + (c & 0x3F));
        }
    }

    static void save(SimpleNode node, OutputStream w) throws IOException {
        w.write(40);
        NodeUtil.writeDigits(w, node.id);
        w.write(44);
        if (node.str != null) {
            if (node.id == 27) {
                NodeUtil.writeInt(w, node.str.length());
                NodeUtil.writeString(w, node.str);
            } else if (node.id != 26) {
                NodeUtil.writeString(w, node.str);
            }
        }
        w.write(44);
        NodeUtil.writeDigits(w, node.beginLine);
        w.write(44);
        NodeUtil.writeDigits(w, node.beginColumn);
        w.write(44);
        if (node.info instanceof String) {
            NodeUtil.writeString(w, (String)node.info);
        } else if (node.id == 24 || node.id == 25) {
            Object[] info = (Object[])node.info;
            Number n = (Number)info[0];
            int[] offset = (int[])info[1];
            w.write(123);
            NodeUtil.writeString(w, n.toString());
            w.write(58);
            if (offset != null) {
                NodeUtil.writeDigits(w, offset[0]);
            }
            w.write(125);
        } else if (node.id == 26) {
            Character ch = (Character)node.info;
            NodeUtil.writeString(w, String.valueOf(ch.charValue()));
        }
        w.write(44);
        int nchildren = node.jjtGetNumChildren();
        if (nchildren > 0) {
            NodeUtil.save(node.jjtGetChild(0), w);
        }
        for (int i = 1; i < nchildren; ++i) {
            w.write(44);
            NodeUtil.save(node.jjtGetChild(i), w);
        }
        w.write(41);
    }

    public static SimpleNode loadNode(String str) {
        byte[] b = NodeUtil.stringToByteArray(str);
        ByteArrayInputStream in = new ByteArrayInputStream(b);
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)in, ENCODING));
            return NodeUtil.parseNode(r);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static String byteArrayToString(byte[] array, int len, StringBuffer sbuf) {
        int i = 0;
        if (len % 2 == 0) {
            sbuf.append('\u0000');
        } else {
            sbuf.append('\uffff');
        }
        while (i < len / 2) {
            sbuf.append((char)(array[i * 2] << 8 | array[i * 2 + 1] & 0xFF));
            ++i;
        }
        if (i * 2 < len) {
            sbuf.append((char)(array[i * 2] << 8));
        }
        return sbuf.toString();
    }

    public static String byteArrayToString(byte[] array, int len) {
        StringBuffer sbuf = new StringBuffer(len / 2 + 1);
        int i = 0;
        if (len % 2 == 0) {
            sbuf.append('\u0000');
        } else {
            sbuf.append('\uffff');
        }
        while (i < len / 2) {
            sbuf.append((char)(array[i * 2] << 8 | array[i * 2 + 1] & 0xFF));
            ++i;
        }
        if (i * 2 < len) {
            sbuf.append((char)(array[i * 2] << 8));
        }
        return sbuf.toString();
    }

    public static byte[] stringToByteArray(String s) {
        return NodeUtil.charArrayToByteArray(s.toCharArray());
    }

    static byte[] charArrayToByteArray(char[] c) {
        int i;
        int j = 0;
        int len = c.length;
        if (c[0] == '\u0000') {
            byte[] bytes = new byte[(len - 1) * 2];
            for (i = 1; i < len; ++i) {
                char ch = c[i];
                bytes[j++] = (byte)(ch >> 8 & 0xFF);
                bytes[j++] = (byte)(ch & 0xFF);
            }
            return bytes;
        }
        byte[] bytes = new byte[(len - 1) * 2 - 1];
        while (i < len - 1) {
            char ch = c[i];
            bytes[j++] = (byte)(ch >> 8 & 0xFF);
            bytes[j++] = (byte)(ch & 0xFF);
            ++i;
        }
        bytes[j++] = (byte)((c[i] >> 8) % 255);
        return bytes;
    }

    public static String unparseNode(SimpleNode node) {
        StringBuffer sbuf = new StringBuffer();
        node.accept(new UnparseVisitor(sbuf), null);
        return sbuf.toString();
    }

    public static void setPackage(String pkg, SimpleNode ss) {
        SimpleNode sn;
        SimpleNode el = new SimpleNode(3);
        ss.jjtAddChild(el, ss.jjtGetNumChildren());
        el.jjtSetParent(ss);
        SimpleNode an = new SimpleNode(22);
        el.jjtAddChild(an, 0);
        an.jjtSetParent(el);
        SimpleNode in = new SimpleNode(5);
        in.str = "package".intern();
        an.jjtAddChild(in, 0);
        in.jjtSetParent(an);
        SimpleNode le = new SimpleNode(6);
        an.jjtAddChild(le, 1);
        if (pkg != null) {
            sn = new SimpleNode(27);
            sn.str = pkg;
        } else {
            sn = new SimpleNode(30);
        }
        le.jjtAddChild(sn, 0);
        sn.jjtSetParent(le);
    }

    public static void addImportNode(String def, SimpleNode ss) {
        SimpleNode el = new SimpleNode(3);
        ss.jjtAddChild(el, ss.jjtGetNumChildren());
        el.jjtSetParent(ss);
        SimpleNode im = new SimpleNode(76);
        el.jjtAddChild(im, 0);
        im.jjtSetParent(el);
        SimpleNode sn = new SimpleNode(27);
        im.jjtAddChild(sn, 0);
        sn.jjtSetParent(im);
        sn.str = def;
    }

    public static void addFunction(SimpleNode fnode, SimpleNode ss) {
        SimpleNode el = new SimpleNode(3);
        ss.jjtAddChild(el, ss.jjtGetNumChildren());
        el.jjtSetParent(ss);
        el.jjtAddChild(fnode, 0);
        fnode.jjtSetParent(el);
    }

    static class ByteArray
    extends OutputStream {
        protected byte[] buf;
        protected int count;

        public ByteArray() {
            this(1024);
        }

        public ByteArray(int size) {
            if (size < 0) {
                throw new IllegalArgumentException("Negative initial size: " + size);
            }
            this.buf = new byte[size];
        }

        public void write(int b) {
            int newcount = this.count + 1;
            if (newcount > this.buf.length) {
                byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
                System.arraycopy(this.buf, 0, newbuf, 0, this.count);
                this.buf = newbuf;
            }
            this.buf[this.count] = (byte)b;
            this.count = newcount;
        }

        public void write(byte[] b, int off, int len) {
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            int newcount = this.count + len;
            if (newcount > this.buf.length) {
                byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
                System.arraycopy(this.buf, 0, newbuf, 0, this.count);
                this.buf = newbuf;
            }
            System.arraycopy(b, off, this.buf, this.count, len);
            this.count = newcount;
        }

        public void writeTo(OutputStream out) throws IOException {
            out.write(this.buf, 0, this.count);
        }

        public void reset() {
            this.count = 0;
        }

        public byte[] toByteArray() {
            byte[] newbuf = new byte[this.count];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            return newbuf;
        }

        public int size() {
            return this.count;
        }

        public String toString() {
            return new String(this.buf, 0, this.count);
        }

        public String toString(String enc) throws UnsupportedEncodingException {
            return new String(this.buf, 0, this.count, enc);
        }

        public void close() throws IOException {
        }

        public byte[] getByteArray() {
            return this.buf;
        }
    }
}

