/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data;

import java.util.Collection;
import java.util.Iterator;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.PointerTarget;
import net.didion.jwnl.data.PointerType;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.data.list.PointerTargetNode;
import net.didion.jwnl.data.list.PointerTargetNodeList;
import net.didion.jwnl.data.list.PointerTargetTree;
import net.didion.jwnl.data.list.PointerTargetTreeNode;
import net.didion.jwnl.data.list.PointerTargetTreeNodeList;

public final class PointerUtils {
    public static final int INFINITY = Integer.MAX_VALUE;
    private static int _defaultDepth = Integer.MAX_VALUE;
    private static int _defaultPointerDepth = Integer.MAX_VALUE;

    private PointerUtils() {
    }

    public static void setDefaultDepth(int n) {
        if (n >= 0) {
            _defaultDepth = n;
        }
    }

    public static void setDefaultPointerDepth(int n) {
        if (n >= 0) {
            _defaultPointerDepth = n;
        }
    }

    public static PointerTargetNodeList getDirectHypernyms(Synset synset) throws JWNLException {
        return PointerUtils.getPointerTargets(synset, PointerType.HYPERNYM);
    }

    public static PointerTargetTree getHypernymTree(Synset synset) throws JWNLException {
        return PointerUtils.getHypernymTree(synset, _defaultDepth);
    }

    public static PointerTargetTree getHypernymTree(Synset synset, int n) throws JWNLException {
        return new PointerTargetTree(synset, PointerUtils.makePointerTargetTreeList(synset, PointerType.HYPERNYM, n));
    }

    public static PointerTargetNodeList getDirectHyponyms(Synset synset) throws JWNLException {
        return PointerUtils.getPointerTargets(synset, PointerType.HYPONYM);
    }

    public static PointerTargetTree getHyponymTree(Synset synset) throws JWNLException {
        return PointerUtils.getHyponymTree(synset, _defaultDepth);
    }

    public static PointerTargetTree getHyponymTree(Synset synset, int n) throws JWNLException {
        return new PointerTargetTree(synset, PointerUtils.makePointerTargetTreeList(synset, PointerType.HYPONYM, n));
    }

    public static PointerTargetNodeList getCoordinateTerms(Synset synset) throws JWNLException {
        PointerTargetNodeList pointerTargetNodeList = new PointerTargetNodeList();
        Iterator iterator = PointerUtils.getDirectHypernyms(synset).iterator();
        while (iterator.hasNext()) {
            pointerTargetNodeList.addAll((Collection)PointerUtils.getPointerTargets(((PointerTargetNode)iterator.next()).getSynset(), PointerType.HYPONYM));
        }
        return pointerTargetNodeList;
    }

    public static PointerTargetNodeList getAntonyms(Synset synset) throws JWNLException {
        return PointerUtils.getPointerTargets(synset, PointerType.ANTONYM);
    }

    public static PointerTargetTree getExtendedAntonyms(Synset synset) throws JWNLException {
        return PointerUtils.getExtendedAntonyms(synset, 1);
    }

    public static PointerTargetTree getExtendedAntonyms(Synset synset, int n) throws JWNLException {
        PointerTargetTreeNodeList pointerTargetTreeNodeList = new PointerTargetTreeNodeList();
        if (synset.getPOS() == POS.ADJECTIVE) {
            PointerTargetNodeList pointerTargetNodeList = PointerUtils.getAntonyms(synset);
            pointerTargetTreeNodeList = PointerUtils.makePointerTargetTreeList(pointerTargetNodeList, PointerType.SIMILAR_TO, PointerType.ANTONYM, n, false);
        }
        return new PointerTargetTree(new PointerTargetTreeNode((PointerTarget)synset, pointerTargetTreeNodeList, null));
    }

    public static PointerTargetTree getIndirectAntonyms(Synset synset) throws JWNLException {
        return PointerUtils.getIndirectAntonyms(synset, 1);
    }

    public static PointerTargetTree getIndirectAntonyms(Synset synset, int n) throws JWNLException {
        PointerTargetTreeNodeList pointerTargetTreeNodeList = new PointerTargetTreeNodeList();
        if (synset.getPOS() == POS.ADJECTIVE) {
            PointerTargetNodeList pointerTargetNodeList = PointerUtils.getSynonyms(synset);
            pointerTargetTreeNodeList = PointerUtils.makePointerTargetTreeList(pointerTargetNodeList, PointerType.ANTONYM, PointerType.ANTONYM, n, false);
        }
        return new PointerTargetTree(new PointerTargetTreeNode((PointerTarget)synset, pointerTargetTreeNodeList, null));
    }

    public static PointerTargetNodeList getAttributes(Synset synset) throws JWNLException {
        return PointerUtils.getPointerTargets(synset, PointerType.ATTRIBUTE);
    }

    public static PointerTargetNodeList getAlsoSees(Synset synset) throws JWNLException {
        return PointerUtils.getPointerTargets(synset, PointerType.SEE_ALSO);
    }

    public static PointerTargetTree getAlsoSeeTree(Synset synset, int n) throws JWNLException {
        return new PointerTargetTree(synset, PointerUtils.makePointerTargetTreeList(synset, PointerType.SEE_ALSO, n));
    }

    public static PointerTargetNodeList getMeronyms(Synset synset) throws JWNLException {
        PointerTargetNodeList pointerTargetNodeList = new PointerTargetNodeList();
        pointerTargetNodeList.addAll((Collection)PointerUtils.getPartMeronyms(synset));
        pointerTargetNodeList.addAll((Collection)PointerUtils.getMemberMeronyms(synset));
        pointerTargetNodeList.addAll((Collection)PointerUtils.getSubstanceMeronyms(synset));
        return pointerTargetNodeList;
    }

    public static PointerTargetNodeList getPartMeronyms(Synset synset) throws JWNLException {
        return PointerUtils.getPointerTargets(synset, PointerType.PART_MERONYM);
    }

    public static PointerTargetNodeList getMemberMeronyms(Synset synset) throws JWNLException {
        return PointerUtils.getPointerTargets(synset, PointerType.MEMBER_MERONYM);
    }

    public static PointerTargetNodeList getSubstanceMeronyms(Synset synset) throws JWNLException {
        return PointerUtils.getPointerTargets(synset, PointerType.SUBSTANCE_MERONYM);
    }

    public static PointerTargetTree getInteritedMeronyms(Synset synset) throws JWNLException {
        return PointerUtils.getInheritedMeronyms(synset, _defaultPointerDepth, _defaultDepth);
    }

    public static PointerTargetTree getInheritedMeronyms(Synset synset, int n, int n2) throws JWNLException {
        PointerType[] pointerTypeArray = new PointerType[]{PointerType.PART_MERONYM, PointerType.MEMBER_MERONYM, PointerType.SUBSTANCE_MERONYM};
        return PointerUtils.makeInheritedTree(synset, pointerTypeArray, null, n, n2, false);
    }

    public static PointerTargetTree getInheritedPartMeronyms(Synset synset) throws JWNLException {
        return PointerUtils.getInheritedPartMeronyms(synset, _defaultPointerDepth, _defaultDepth);
    }

    public static PointerTargetTree getInheritedPartMeronyms(Synset synset, int n, int n2) throws JWNLException {
        return PointerUtils.makeInheritedTree(synset, PointerType.PART_MERONYM, null, n, n2);
    }

    public static PointerTargetTree getInheritedMemberMeronyms(Synset synset) throws JWNLException {
        return PointerUtils.getInheritedMemberMeronyms(synset, _defaultPointerDepth, _defaultDepth);
    }

    public static PointerTargetTree getInheritedMemberMeronyms(Synset synset, int n, int n2) throws JWNLException {
        return PointerUtils.makeInheritedTree(synset, PointerType.MEMBER_MERONYM, null, n, n2);
    }

    public static PointerTargetTree getInheritedSubstanceMeronyms(Synset synset) throws JWNLException {
        return PointerUtils.getInheritedSubstanceMeronyms(synset, _defaultPointerDepth, _defaultDepth);
    }

    public static PointerTargetTree getInheritedSubstanceMeronyms(Synset synset, int n, int n2) throws JWNLException {
        return PointerUtils.makeInheritedTree(synset, PointerType.SUBSTANCE_MERONYM, null, n, n2);
    }

    public static PointerTargetNodeList getHolonyms(Synset synset) throws JWNLException {
        PointerTargetNodeList pointerTargetNodeList = new PointerTargetNodeList();
        pointerTargetNodeList.addAll((Collection)PointerUtils.getPartHolonyms(synset));
        pointerTargetNodeList.addAll((Collection)PointerUtils.getMemberHolonyms(synset));
        pointerTargetNodeList.addAll((Collection)PointerUtils.getSubstanceHolonyms(synset));
        return pointerTargetNodeList;
    }

    public static PointerTargetNodeList getPartHolonyms(Synset synset) throws JWNLException {
        return PointerUtils.getPointerTargets(synset, PointerType.PART_HOLONYM);
    }

    public static PointerTargetNodeList getMemberHolonyms(Synset synset) throws JWNLException {
        return PointerUtils.getPointerTargets(synset, PointerType.MEMBER_HOLONYM);
    }

    public static PointerTargetNodeList getSubstanceHolonyms(Synset synset) throws JWNLException {
        return PointerUtils.getPointerTargets(synset, PointerType.SUBSTANCE_HOLONYM);
    }

    public static PointerTargetTree getInheritedHolonyms(Synset synset) throws JWNLException {
        return PointerUtils.getInheritedHolonyms(synset, _defaultPointerDepth, _defaultDepth);
    }

    public static PointerTargetTree getInheritedHolonyms(Synset synset, int n, int n2) throws JWNLException {
        PointerType[] pointerTypeArray = new PointerType[]{PointerType.PART_HOLONYM, PointerType.MEMBER_HOLONYM, PointerType.SUBSTANCE_HOLONYM};
        return PointerUtils.makeInheritedTree(synset, pointerTypeArray, null, n, n2, false);
    }

    public static PointerTargetTree getInheritedPartHolonyms(Synset synset) throws JWNLException {
        return PointerUtils.getInheritedPartHolonyms(synset, _defaultPointerDepth, _defaultDepth);
    }

    public static PointerTargetTree getInheritedPartHolonyms(Synset synset, int n, int n2) throws JWNLException {
        return PointerUtils.makeInheritedTree(synset, PointerType.PART_HOLONYM, null, n, n2);
    }

    public static PointerTargetTree getInheritedMemberHolonyms(Synset synset) throws JWNLException {
        return PointerUtils.getInheritedMemberHolonyms(synset, _defaultPointerDepth, _defaultDepth);
    }

    public static PointerTargetTree getInheritedMemberHolonyms(Synset synset, int n, int n2) throws JWNLException {
        return PointerUtils.makeInheritedTree(synset, PointerType.MEMBER_HOLONYM, null, n, n2);
    }

    public static PointerTargetTree getInheritedSubstanceHolonyms(Synset synset) throws JWNLException {
        return PointerUtils.getInheritedSubstanceHolonyms(synset, _defaultPointerDepth, _defaultDepth);
    }

    public static PointerTargetTree getInheritedSubstanceHolonyms(Synset synset, int n, int n2) throws JWNLException {
        return PointerUtils.makeInheritedTree(synset, PointerType.SUBSTANCE_HOLONYM, null, n, n2);
    }

    public static PointerTargetNodeList getEntailments(Synset synset) throws JWNLException {
        return PointerUtils.getPointerTargets(synset, PointerType.ENTAILMENT);
    }

    public static PointerTargetTree getEntailmentTree(Synset synset) throws JWNLException {
        return PointerUtils.getEntailmentTree(synset, _defaultDepth);
    }

    public static PointerTargetTree getEntailmentTree(Synset synset, int n) throws JWNLException {
        return new PointerTargetTree(synset, PointerUtils.makePointerTargetTreeList(synset, PointerType.ENTAILMENT, n));
    }

    public static PointerTargetNodeList getEntailedBy(Synset synset) throws JWNLException {
        return PointerUtils.getPointerTargets(synset, PointerType.ENTAILED_BY);
    }

    public static PointerTargetTree getEntailedByTree(Synset synset) throws JWNLException {
        return PointerUtils.getEntailedByTree(synset, _defaultDepth);
    }

    public static PointerTargetTree getEntailedByTree(Synset synset, int n) throws JWNLException {
        return new PointerTargetTree(synset, PointerUtils.makePointerTargetTreeList(synset, PointerType.ENTAILED_BY, n));
    }

    public static PointerTargetNodeList getCauses(Synset synset) throws JWNLException {
        return PointerUtils.getPointerTargets(synset, PointerType.CAUSE);
    }

    public static PointerTargetTree getCauseTree(Synset synset) throws JWNLException {
        return PointerUtils.getCauseTree(synset, _defaultDepth);
    }

    public static PointerTargetTree getCauseTree(Synset synset, int n) throws JWNLException {
        return new PointerTargetTree(synset, PointerUtils.makePointerTargetTreeList(synset, PointerType.CAUSE, n));
    }

    public static PointerTargetNodeList getVerbGroup(Synset synset) throws JWNLException {
        PointerTargetNodeList pointerTargetNodeList = new PointerTargetNodeList();
        pointerTargetNodeList.add(new PointerTargetNode(synset, PointerType.VERB_GROUP));
        int n = 0;
        int n2 = -1;
        do {
            PointerTargetNode pointerTargetNode = (PointerTargetNode)pointerTargetNodeList.get(++n2);
            Iterator iterator = PointerUtils.getPointerTargets(pointerTargetNode.getSynset(), PointerType.VERB_GROUP).iterator();
            while (iterator.hasNext()) {
                PointerTargetNode pointerTargetNode2 = (PointerTargetNode)iterator.next();
                if (pointerTargetNodeList.contains(pointerTargetNode2)) continue;
                pointerTargetNodeList.add(pointerTargetNode2);
                ++n;
            }
        } while (n2 < n);
        return pointerTargetNodeList;
    }

    public static PointerTargetNodeList getParticipleOf(Synset synset) throws JWNLException {
        return PointerUtils.getPointerTargets(synset, PointerType.PARTICIPLE_OF);
    }

    public static PointerTargetNodeList getDerived(Synset synset) throws JWNLException {
        return PointerUtils.getPointerTargets(synset, PointerType.DERIVED);
    }

    public static PointerTargetNodeList getSynonyms(Synset synset) throws JWNLException {
        return PointerUtils.getPointerTargets(synset, PointerType.SIMILAR_TO);
    }

    public static PointerTargetTree getSynonymTree(Synset synset, int n) throws JWNLException {
        return new PointerTargetTree(synset, PointerUtils.makePointerTargetTreeList(synset, PointerType.SIMILAR_TO, null, n, false));
    }

    private static PointerTargetNodeList getPointerTargets(Synset synset, PointerType pointerType) throws JWNLException {
        return new PointerTargetNodeList(synset.getTargets(pointerType));
    }

    public static PointerTargetTreeNodeList makePointerTargetTreeList(Synset synset, PointerType pointerType) throws JWNLException {
        return PointerUtils.makePointerTargetTreeList(synset, pointerType, _defaultDepth);
    }

    public static PointerTargetTreeNodeList makePointerTargetTreeList(Synset synset, PointerType pointerType, int n) throws JWNLException {
        return PointerUtils.makePointerTargetTreeList(synset, pointerType, null, n, true);
    }

    public static PointerTargetTreeNodeList makePointerTargetTreeList(Synset synset, PointerType pointerType, PointerType pointerType2, int n, boolean bl) throws JWNLException {
        PointerType[] pointerTypeArray = new PointerType[]{pointerType};
        return PointerUtils.makePointerTargetTreeList(synset, pointerTypeArray, pointerType2, n, bl);
    }

    public static PointerTargetTreeNodeList makePointerTargetTreeList(Synset synset, PointerType[] pointerTypeArray) throws JWNLException {
        return PointerUtils.makePointerTargetTreeList(synset, pointerTypeArray, _defaultDepth);
    }

    public static PointerTargetTreeNodeList makePointerTargetTreeList(Synset synset, PointerType[] pointerTypeArray, int n) throws JWNLException {
        return PointerUtils.makePointerTargetTreeList(synset, pointerTypeArray, null, n, true);
    }

    public static PointerTargetTreeNodeList makePointerTargetTreeList(Synset synset, PointerType[] pointerTypeArray, PointerType pointerType, int n, boolean bl) throws JWNLException {
        return PointerUtils.makePointerTargetTreeList(synset, pointerTypeArray, pointerType, n, bl, null);
    }

    public static PointerTargetTreeNodeList makePointerTargetTreeList(PointerTargetNodeList pointerTargetNodeList, PointerType pointerType, PointerType pointerType2, int n, boolean bl) throws JWNLException {
        PointerType[] pointerTypeArray = new PointerType[]{pointerType};
        return PointerUtils.makePointerTargetTreeList(pointerTargetNodeList, pointerTypeArray, pointerType2, n, bl);
    }

    public static PointerTargetTreeNodeList makePointerTargetTreeList(PointerTargetNodeList pointerTargetNodeList, PointerType[] pointerTypeArray, PointerType pointerType, int n, boolean bl) throws JWNLException {
        PointerTargetTreeNodeList pointerTargetTreeNodeList = new PointerTargetTreeNodeList();
        Iterator iterator = pointerTargetNodeList.iterator();
        while (iterator.hasNext()) {
            PointerTargetNode pointerTargetNode = (PointerTargetNode)iterator.next();
            pointerTargetTreeNodeList.add(pointerTargetNode.getPointerTarget(), PointerUtils.makePointerTargetTreeList(pointerTargetNode.getSynset(), pointerTypeArray, pointerType, n, bl), pointerType);
        }
        return pointerTargetTreeNodeList;
    }

    private static PointerTargetTreeNodeList makePointerTargetTreeList(Synset synset, PointerType[] pointerTypeArray, PointerType pointerType, int n, boolean bl, PointerTargetTreeNode pointerTargetTreeNode) throws JWNLException {
        --n;
        PointerTargetTreeNodeList pointerTargetTreeNodeList = new PointerTargetTreeNodeList();
        int n2 = 0;
        while (n2 < pointerTypeArray.length) {
            PointerType pointerType2 = pointerTypeArray[n2];
            PointerTargetNodeList pointerTargetNodeList = new PointerTargetNodeList(synset.getTargets(pointerType2));
            if (pointerTargetNodeList.size() > 0) {
                Iterator iterator = pointerTargetNodeList.iterator();
                while (iterator.hasNext()) {
                    PointerTargetTreeNode pointerTargetTreeNode2 = new PointerTargetTreeNode(((PointerTargetNode)iterator.next()).getPointerTarget(), pointerType == null ? pointerType2 : pointerType, pointerTargetTreeNode);
                    if (!bl && pointerTargetTreeNodeList.contains(pointerTargetTreeNode2)) continue;
                    if (n != 0) {
                        pointerTargetTreeNode2.setChildTreeList(PointerUtils.makePointerTargetTreeList(pointerTargetTreeNode2.getSynset(), pointerTypeArray, pointerType, n, bl, pointerTargetTreeNode2));
                    }
                    pointerTargetTreeNodeList.add(pointerTargetTreeNode2);
                }
            }
            ++n2;
        }
        return pointerTargetTreeNodeList;
    }

    public static PointerTargetTree makeInheritedTree(Synset synset, PointerType pointerType) throws JWNLException {
        return PointerUtils.makeInheritedTree(synset, pointerType, null, _defaultPointerDepth, _defaultDepth);
    }

    public static PointerTargetTree makeInheritedTree(Synset synset, PointerType pointerType, PointerType pointerType2, int n, int n2) throws JWNLException {
        return PointerUtils.makeInheritedTree(synset, pointerType, pointerType2, n, n2, true);
    }

    public static PointerTargetTree makeInheritedTree(Synset synset, PointerType pointerType, PointerType pointerType2, int n, int n2, boolean bl) throws JWNLException {
        PointerType[] pointerTypeArray = new PointerType[]{pointerType};
        return PointerUtils.makeInheritedTree(synset, pointerTypeArray, pointerType2, n, n2, bl);
    }

    public static PointerTargetTree makeInheritedTree(Synset synset, PointerType[] pointerTypeArray) throws JWNLException {
        return PointerUtils.makeInheritedTree(synset, pointerTypeArray, null, _defaultPointerDepth, _defaultDepth);
    }

    public static PointerTargetTree makeInheritedTree(Synset synset, PointerType[] pointerTypeArray, PointerType pointerType, int n, int n2) throws JWNLException {
        return PointerUtils.makeInheritedTree(synset, pointerTypeArray, pointerType, n, n2, true);
    }

    public static PointerTargetTree makeInheritedTree(Synset synset, PointerType[] pointerTypeArray, PointerType pointerType, int n, int n2, boolean bl) throws JWNLException {
        PointerTargetTree pointerTargetTree = PointerUtils.getHypernymTree(synset, Integer.MAX_VALUE);
        return PointerUtils.makeInheritedTree(pointerTargetTree, pointerTypeArray, pointerType, n, n2, bl);
    }

    public static PointerTargetTree makeInheritedTree(PointerTargetTree pointerTargetTree, PointerType[] pointerTypeArray, PointerType pointerType, int n, int n2, boolean bl) throws JWNLException {
        PointerTargetTreeNode pointerTargetTreeNode = pointerTargetTree.getRootNode();
        pointerTargetTreeNode.setPointerTreeList(PointerUtils.makePointerTargetTreeList(pointerTargetTreeNode.getSynset(), pointerTypeArray, pointerType, n, bl));
        pointerTargetTreeNode.setChildTreeList(PointerUtils.makeInheritedTreeList(pointerTargetTreeNode.getChildTreeList(), pointerTypeArray, pointerType, n, n2, bl));
        return new PointerTargetTree(pointerTargetTreeNode);
    }

    public static PointerTargetTreeNodeList makeInheritedTreeList(PointerTargetTreeNodeList pointerTargetTreeNodeList, PointerType[] pointerTypeArray, PointerType pointerType, int n, int n2, boolean bl) throws JWNLException {
        --n2;
        PointerTargetTreeNodeList pointerTargetTreeNodeList2 = new PointerTargetTreeNodeList();
        Iterator iterator = pointerTargetTreeNodeList.iterator();
        while (iterator.hasNext()) {
            PointerTargetTreeNode pointerTargetTreeNode = (PointerTargetTreeNode)iterator.next();
            if (!bl && pointerTargetTreeNodeList2.contains(pointerTargetTreeNode)) continue;
            if (n2 == 0) {
                pointerTargetTreeNodeList2.add(pointerTargetTreeNode.getPointerTarget(), null, PointerUtils.makePointerTargetTreeList(pointerTargetTreeNode.getSynset(), pointerTypeArray, pointerType, n, bl), PointerType.HYPERNYM);
                continue;
            }
            pointerTargetTreeNodeList2.add(pointerTargetTreeNode.getPointerTarget(), PointerUtils.makeInheritedTreeList(pointerTargetTreeNode.getChildTreeList(), pointerTypeArray, pointerType, n, n2, bl), PointerUtils.makePointerTargetTreeList(pointerTargetTreeNode.getSynset(), pointerTypeArray, pointerType, n, bl), PointerType.HYPERNYM);
        }
        return pointerTargetTreeNodeList2;
    }
}

