/*
 * Decompiled with CFR 0.152.
 */
package Jet.Tipster;

import Jet.Parser.ParseView;
import Jet.Tipster.Annotation;
import Jet.Tipster.AnnotationColor;
import Jet.Tipster.Document;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class View
extends JFrame {
    protected Document document;
    protected JSplitPane jSplitPaneTop = new JSplitPane();
    private JSplitPane jSplitPaneMain = new JSplitPane(0);
    protected JTextPaneX jTextPane = new JTextPaneX();
    private JTextArea jTextArea = new JTextArea();
    private JScrollPane jScrollPaneLeft = new JScrollPane();
    private JScrollPane jScrollPaneRight = new JScrollPane();
    private JScrollPane jScrollPaneBottom = new JScrollPane();
    private JPanel jPanelLeft = new JPanel();
    private JPanel jPanelRight = new JPanel();
    private JPanel jPanelBottom = new JPanel();
    private Annotation parse = null;

    public View(Document document, int n) {
        this.document = document;
        try {
            this.jbInit(this.document.getAnnotationTypes(), "types");
            this.setTitle("Jet Document " + n);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = this.getSize();
            int n2 = (dimension.width - dimension2.width) / 30;
            this.setLocation(30 * (n % n2), 20 * (n % n2));
            this.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected View() {
    }

    protected void jbInit(Object[] objectArray, String string) throws Exception {
        JList<Object> jList = new JList<Object>(objectArray);
        jList.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        jList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                View.this.jListValueChanged(listSelectionEvent);
            }
        });
        this.jScrollPaneLeft.getViewport().add(jList);
        this.jPanelLeft.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), string));
        this.jPanelLeft.setLayout(new BorderLayout());
        this.jPanelLeft.add((Component)this.jScrollPaneLeft, "Center");
        this.jTextPane.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.jTextPane.setEditable(false);
        this.jTextPane.setFont(new Font("dialog", 0, 12));
        this.jTextPane.setText(this.document.text().toString());
        this.jTextPane.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                View.this.jTextPaneCaretUpdate(caretEvent);
            }
        });
        Keymap keymap = JTextComponent.addKeymap("AnnotationToolMap", null);
        KeyStroke keyStroke = KeyStroke.getKeyStroke('p');
        keymap.addActionForKeyStroke(keyStroke, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                View.this.displayParse();
            }
        });
        this.jTextPane.setKeymap(keymap);
        this.jScrollPaneRight.getViewport().add(this.jTextPane);
        this.jPanelRight.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Annotated Document"));
        this.jPanelRight.setLayout(new BorderLayout());
        this.jPanelRight.add((Component)this.jScrollPaneRight, "Center");
        this.jSplitPaneTop.setLeftComponent(this.jPanelLeft);
        this.jSplitPaneTop.setRightComponent(this.jPanelRight);
        this.jTextArea.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.jTextArea.setEditable(false);
        this.jTextArea.setText("Select a region to see annotations.");
        this.jScrollPaneBottom.getViewport().add(this.jTextArea);
        this.jPanelBottom.setPreferredSize(new Dimension(600, 80));
        this.jPanelBottom.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Annotations"));
        this.jPanelBottom.setLayout(new BorderLayout());
        this.jPanelBottom.add((Component)this.jScrollPaneBottom, "Center");
        this.jSplitPaneMain.setTopComponent(this.jSplitPaneTop);
        this.jSplitPaneMain.setBottomComponent(this.jPanelBottom);
        this.jSplitPaneMain.setResizeWeight(0.8);
        this.setSize(600, 400);
        this.getContentPane().add((Component)this.jSplitPaneMain, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                View.this.dispose();
            }
        });
    }

    private void jTextPaneCaretUpdate(CaretEvent caretEvent) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = caretEvent.getDot();
        int n2 = caretEvent.getMark();
        this.parse = null;
        for (int i = Math.min(n, n2); i < Math.max(n, n2); ++i) {
            Vector<Annotation> vector = this.document.annotationsAt(i);
            if (vector == null) continue;
            for (Annotation annotation : vector) {
                stringBuffer.append(annotation.toString() + "\n");
                if (this.parse != null || annotation.get("parse") == null) continue;
                this.parse = (Annotation)annotation.get("parse");
                stringBuffer.append("[type 'p' in document window to display parse]\n");
            }
        }
        String string = stringBuffer.toString();
        if (string.length() == 0) {
            string = "No annotations found in the selected region.";
        }
        this.jTextArea.setText(string);
    }

    private void displayParse() {
        if (this.parse != null) {
            new ParseView("parse", this.parse);
        }
    }

    protected void jListValueChanged(ListSelectionEvent listSelectionEvent) {
        int n;
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        JList jList = (JList)listSelectionEvent.getSource();
        Object[] objectArray = this.document.getAnnotationTypes();
        for (n = 0; n < objectArray.length; ++n) {
            if (jList.isSelectedIndex(n)) continue;
            this.bleach((String)objectArray[n]);
        }
        objectArray = jList.getSelectedValues();
        for (n = 0; n < objectArray.length; ++n) {
            this.highlight((String)objectArray[n]);
        }
    }

    public void highlight(String string) {
        AnnotationColor.addType(string);
        this.setAnnotationAttribute(string, null);
    }

    public void bleach(String string) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        this.setAnnotationAttribute(string, simpleAttributeSet);
    }

    public void setAnnotationAttribute(String string, SimpleAttributeSet simpleAttributeSet) {
        this.setAnnotationAttribute(this.document.annotationsOfType(string), simpleAttributeSet);
    }

    public void setAnnotationAttribute(Vector vector, SimpleAttributeSet simpleAttributeSet) {
        if (vector != null && !vector.isEmpty()) {
            StyledDocument styledDocument = this.jTextPane.getStyledDocument();
            for (Annotation annotation : vector) {
                SimpleAttributeSet simpleAttributeSet2;
                if (simpleAttributeSet != null) {
                    simpleAttributeSet2 = simpleAttributeSet;
                } else {
                    simpleAttributeSet2 = new SimpleAttributeSet();
                    Color color = AnnotationColor.getColor(annotation);
                    StyleConstants.setBackground(simpleAttributeSet2, color);
                    StyleConstants.setBold(simpleAttributeSet2, true);
                }
                int n = annotation.span().start();
                int n2 = annotation.span().endNoWS(this.document) - n;
                styledDocument.setCharacterAttributes(n, n2, simpleAttributeSet2, true);
            }
        }
    }

    protected class JTextPaneX
    extends JTextPane {
        private ArrayList startPoint = new ArrayList();
        private ArrayList endPoint = new ArrayList();
        private ArrayList color = new ArrayList();

        protected JTextPaneX() {
        }

        public void clearLines() {
            this.startPoint = new ArrayList();
            this.endPoint = new ArrayList();
            this.color = new ArrayList();
        }

        public void addLine(Point point, Point point2) {
            this.addLine(point, point2, Color.BLUE);
        }

        public void addLine(Point point, Point point2, Color color) {
            this.startPoint.add(point);
            this.endPoint.add(point2);
            this.color.add(color);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            for (int i = 0; i < this.startPoint.size(); ++i) {
                Point point = (Point)this.startPoint.get(i);
                Point point2 = (Point)this.endPoint.get(i);
                Color color = (Color)this.color.get(i);
                graphics.setColor(color);
                int n = color == Color.RED ? 2 : 0;
                graphics.drawLine(point.x + n, point.y, point2.x + n, point2.y);
                graphics.drawLine(point.x + 1 + n, point.y, point2.x + 1 + n, point2.y);
            }
        }
    }
}

