/*
 * Decompiled with CFR 0.152.
 */
package Jet.Tipster;

import Jet.JetTest;
import Jet.Lisp.FeatureSet;
import Jet.Scorer.SGMLProcessor;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.StringTokenizer;

public class ExternalDocument
extends Document {
    private boolean open;
    private String format;
    private String directory;
    private String fileName;
    private String[] SGMLtags = new String[0];
    private boolean allTags = false;
    private String[] emptyTags = null;

    public ExternalDocument(String string, String string2) {
        this.format = string;
        this.directory = null;
        this.fileName = string2;
        this.open = false;
    }

    public ExternalDocument(String string, String string2, String string3) {
        this.format = string;
        this.directory = string2;
        this.fileName = string3;
        this.open = false;
    }

    public void setSGMLtags(String[] stringArray) {
        this.SGMLtags = stringArray;
    }

    public void setAllTags(boolean bl) {
        this.allTags = bl;
    }

    public void setEmptyTags(String[] stringArray) {
        this.emptyTags = stringArray;
    }

    public boolean open() {
        if (!this.open) {
            try {
                if (this.format.equals("sgml")) {
                    String string;
                    File file = new File(this.fullFileName());
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), JetTest.encoding));
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((string = bufferedReader.readLine()) != null) {
                        stringBuffer.append(string + "\n");
                    }
                    String string2 = stringBuffer.toString();
                    SGMLProcessor.allTags = this.allTags;
                    SGMLProcessor.emptyTags = this.emptyTags;
                    Document document = SGMLProcessor.sgmlToDoc((Document)this, string2, this.SGMLtags);
                    this.open = true;
                    return true;
                }
                if (this.format.equals("pos")) {
                    this.posRead();
                    this.open = true;
                    return true;
                }
                System.out.println("Error opening document " + this.fileName);
                System.out.println("Unknown document format.");
                return false;
            }
            catch (IOException iOException) {
                System.out.println("Error opening document " + this.fileName);
                System.out.println(iOException);
                return false;
            }
        }
        return true;
    }

    private void posRead() throws IOException {
        String string;
        File file = new File(this.fullFileName());
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n = string2.lastIndexOf(47);
                if (n <= 0) {
                    throw new IOException("invalid data");
                }
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(1 + n).intern();
                int n2 = this.length();
                this.append(string3);
                if (stringTokenizer.hasMoreTokens()) {
                    this.append(" ");
                } else {
                    this.append(" \n");
                }
                int n3 = this.length();
                Span span = new Span(n2, n3);
                this.annotate("token", span, new FeatureSet());
                this.annotate("constit", span, new FeatureSet("cat", string4));
            }
        }
    }

    public void save() {
        if (!this.open) {
            System.out.println("ExternalDocument.save:  attempt to save unopened document " + this.fileName);
            return;
        }
        try {
            if (this.format.equals("sgml")) {
                String string;
                if (this.allTags) {
                    string = null;
                } else if (this.SGMLtags.length == 0) {
                    string = "***";
                } else if (this.SGMLtags.length == 1) {
                    string = this.SGMLtags[0];
                } else {
                    System.out.println("ExternalDocument.save:  cannot write more than 1 annotation type");
                    return;
                }
                String string2 = this.writeSGML(string).toString();
                File file = new File(this.fullFileName());
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), JetTest.encoding));
                ExternalDocument.writeWithSystemNewlines(bufferedWriter, string2);
                bufferedWriter.close();
            } else {
                System.out.println("Error saving document " + this.fileName);
                System.out.println("Unknown document format.");
            }
        }
        catch (IOException iOException) {
            System.out.println("Error opening document " + this.fileName);
            System.out.println(iOException);
        }
    }

    public static void writeWithSystemNewlines(BufferedWriter bufferedWriter, String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\n') {
                bufferedWriter.newLine();
                continue;
            }
            bufferedWriter.write(c);
        }
    }

    public void saveIn(String string) {
        this.directory = string;
        this.save();
    }

    public void saveAs(String string, String string2) {
        this.directory = string;
        this.fileName = string2;
        this.save();
    }

    public boolean isOpen() {
        return this.open;
    }

    public String format() {
        return this.format;
    }

    public String directory() {
        return this.directory;
    }

    public String fileName() {
        return this.fileName;
    }

    public String fullFileName() {
        if (this.directory == null || this.directory.equals("")) {
            return this.fileName;
        }
        return this.directory + File.separator + this.fileName;
    }
}

