/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent.io;

import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPOutputStream;
import opennlp.maxent.io.BinaryGISModelWriter;
import opennlp.maxent.io.GISModelWriter;
import opennlp.maxent.io.PlainTextGISModelWriter;
import opennlp.model.AbstractModel;

public class SuffixSensitiveGISModelWriter
extends GISModelWriter {
    private final GISModelWriter suffixAppropriateWriter;

    public SuffixSensitiveGISModelWriter(AbstractModel abstractModel, File file) throws IOException {
        super(abstractModel);
        FilterOutputStream filterOutputStream;
        String string = file.getName();
        if (string.endsWith(".gz")) {
            filterOutputStream = new GZIPOutputStream(new FileOutputStream(file));
            string = string.substring(0, string.length() - 3);
        } else {
            filterOutputStream = new DataOutputStream(new FileOutputStream(file));
        }
        this.suffixAppropriateWriter = string.endsWith(".bin") ? new BinaryGISModelWriter(abstractModel, new DataOutputStream(filterOutputStream)) : new PlainTextGISModelWriter(abstractModel, new BufferedWriter(new OutputStreamWriter(filterOutputStream)));
    }

    public void writeUTF(String string) throws IOException {
        this.suffixAppropriateWriter.writeUTF(string);
    }

    public void writeInt(int n) throws IOException {
        this.suffixAppropriateWriter.writeInt(n);
    }

    public void writeDouble(double d) throws IOException {
        this.suffixAppropriateWriter.writeDouble(d);
    }

    public void close() throws IOException {
        this.suffixAppropriateWriter.close();
    }
}

