/*
 * Decompiled with CFR 0.152.
 */
package Jet.HMM;

import AceJet.Ace;
import AceJet.AceDocument;
import AceJet.Datum;
import AceJet.EDTtype;
import AceJet.Gazetteer;
import AceJet.LearnRelations;
import Jet.Console;
import Jet.Control;
import Jet.HMM.BigramHMMemitter;
import Jet.HMM.HMM;
import Jet.HMM.HMMannotator;
import Jet.HMM.HMMemitter;
import Jet.HMM.WordFeatureHMMemitter;
import Jet.JetTest;
import Jet.Lex.Tokenizer;
import Jet.MaxEntModel;
import Jet.Pat.Pat;
import Jet.Refres.Resolve;
import Jet.Scorer.SGMLScorer;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.DocumentCollection;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import Jet.Tipster.View;
import Jet.Zoner.SentenceSplitter;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XNameTagger {
    public HMM nameHMM;
    public HMMannotator annotator;
    String[][] tagTable;
    String[] NEtypeTable;
    String[] tagsToRead;
    String[] tagsToCache;
    String[] tagsToScore;
    Class emitterClass;
    int N = 20;
    MaxEntModel model = new MaxEntModel("rerankTemp/features.log", "rerankTemp/model.log");
    static final String home = "C:/Documents and Settings/Ralph Grishman/My Documents/";
    static final boolean useAceBigrams = false;
    static final String oldACEdir = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/";
    static final String ACEdir = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE 05/V4/";
    static final String dictFile = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE 05/V4/EDT type dict.txt";
    static final String genericFile = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE 05/V4/generic dict.txt";
    static final String patternFile = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/relations/patterns04.log";
    HashMap<String, Double> Fscore;
    HashMap<String, Integer> corefMentionCount;
    HashMap<String, Integer> relationCount;
    HashMap<String, Integer> NEprob;
    HashMap<String, StringBuffer> NEstring;
    HashMap<String, String> relString;
    int MARGIN_TO_SKIP_RESCORING = 3;
    static int NE_PROBABILITY_WINDOW = 6;

    public XNameTagger(Class clazz) {
        if (!HMMemitter.class.isAssignableFrom(clazz)) {
            System.out.println("XNameTagger constructor invoked with invalid class " + clazz);
            return;
        }
        this.emitterClass = clazz;
        this.nameHMM = new HMM(clazz);
        this.annotator = new HMMannotator(this.nameHMM);
        this.annotator.setBItag(false);
        this.annotator.setAnnotateEachToken(false);
        this.nameHMM.setNbest();
    }

    private void readTagTable(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            this.readTagTable(bufferedReader);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void readTagTable(BufferedReader bufferedReader) {
        this.annotator.readTagTable(bufferedReader);
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        String[][] stringArray = this.annotator.getTagTable();
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i][0]);
            arrayList.add(stringArray[i][3]);
        }
        this.NEtypeTable = arrayList.toArray(new String[0]);
        this.tagsToCache = this.NEtypeTable;
        this.tagsToScore = hashSet.toArray(new String[0]);
        hashSet.add("SENT");
        hashSet.add("TURN");
        this.tagsToRead = hashSet.toArray(new String[0]);
    }

    public void load(String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), JetTest.encoding));
        this.readTagTable(bufferedReader);
        this.nameHMM.load(bufferedReader);
    }

    private void tagDocument(Document document) {
        Object object;
        document.annotateWithTag("TEXT");
        Vector<Annotation> vector = document.annotationsOfType("TEXT");
        for (Annotation annotation : vector) {
            object = annotation.span();
            Ace.monocase = Ace.allLowerCase(document);
            SentenceSplitter.split(document, (Span)object);
        }
        Vector<Annotation> vector2 = document.annotationsOfType("sentence");
        int n = 0;
        object = vector2.iterator();
        while (object.hasNext()) {
            Annotation annotation = (Annotation)object.next();
            Span span = annotation.span();
            Tokenizer.tokenize(document, span);
            this.tag(document, span, "H" + n);
            ++n;
        }
    }

    public ArrayList tag(Document document, Span span, String string) {
        return this.annotator.annotateSpanNbest(document, span, this.N, string);
    }

    public void scoreCollection(String string, String string2) {
        DocumentCollection documentCollection = new DocumentCollection(string);
        documentCollection.open();
        DocumentCollection documentCollection2 = new DocumentCollection(string2);
        documentCollection2.open();
        if (documentCollection.size() != documentCollection2.size()) {
            System.out.println(" ** Test and key collections have different sizes, cannot evaluate.");
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < documentCollection.size(); ++i) {
            ExternalDocument externalDocument = documentCollection.get(i);
            externalDocument.setAllTags(true);
            externalDocument.open();
            this.nameHMM.newDocument();
            System.out.println("Annotating document " + i + ": " + externalDocument.fileName());
            Set<String> set = this.NbestTagDocument(externalDocument);
            externalDocument.setActiveHypotheses(set);
            ExternalDocument externalDocument2 = documentCollection2.get(i);
            externalDocument2.setAllTags(true);
            externalDocument2.open();
            externalDocument2.stretch("ENAMEX");
            Vector<Annotation> vector = externalDocument2.annotationsOfType("TEXT");
            if (vector == null) {
                System.out.println("No <TEXT> in " + externalDocument.fileName() + ", cannot be scored.");
                continue;
            }
            SGMLScorer sGMLScorer = new SGMLScorer(externalDocument, externalDocument2);
            for (int j = 0; j < this.tagsToScore.length; ++j) {
                sGMLScorer.match(this.tagsToScore[j]);
                Console.println(sGMLScorer.report());
            }
            System.out.println("Tags in response:        " + sGMLScorer.totalTagsInDoc1);
            System.out.println("Tags in key:             " + sGMLScorer.totalTagsInDoc2);
            System.out.println("Matching tags:           " + sGMLScorer.totalMatchingTags);
            System.out.println("Matching attributes:     " + sGMLScorer.totalMatchingAttrs);
            System.out.println("Type recall:             " + (float)sGMLScorer.totalMatchingTags / (float)sGMLScorer.totalTagsInDoc2);
            System.out.println("Type precision:          " + (float)sGMLScorer.totalMatchingTags / (float)sGMLScorer.totalTagsInDoc1);
            System.out.println("Attribute recall:        " + (float)sGMLScorer.totalMatchingAttrs / (float)sGMLScorer.totalTagsInDoc2);
            System.out.println("Attribute precision:     " + (float)sGMLScorer.totalMatchingAttrs / (float)sGMLScorer.totalTagsInDoc1);
            n += sGMLScorer.totalTagsInDoc1;
            n2 += sGMLScorer.totalTagsInDoc2;
            n3 += sGMLScorer.totalMatchingTags;
            n4 += sGMLScorer.totalMatchingAttrs;
        }
        System.out.println("\nTotal counts:");
        System.out.println("      matchingTags =    " + n3);
        System.out.println("      matchingAttrs =   " + n4);
        System.out.println("      tagsInKeys =      " + n2);
        System.out.println("      tagsInResponses = " + n);
        System.out.println("Overall Type Recall:          " + (float)n3 / (float)n2);
        System.out.println("Overall Type Precision:       " + (float)n3 / (float)n);
        System.out.println("Overall Attribute Recall:     " + (float)n4 / (float)n2);
        System.out.println("Overall Attribute Precision:  " + (float)n4 / (float)n);
    }

    public void scoreCollectionWithOracle(String string, String string2) {
        DocumentCollection documentCollection = new DocumentCollection(string);
        documentCollection.open();
        DocumentCollection documentCollection2 = new DocumentCollection(string2);
        documentCollection2.open();
        if (documentCollection.size() != documentCollection2.size()) {
            System.out.println(" ** Test and key collections have different sizes, cannot evaluate.");
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < documentCollection.size(); ++i) {
            ExternalDocument externalDocument = documentCollection.get(i);
            externalDocument.setAllTags(true);
            externalDocument.open();
            externalDocument.stretchAll();
            this.nameHMM.newDocument();
            System.out.println("Annotating document " + i + ": " + externalDocument.fileName());
            this.tagDocument(externalDocument);
            if (i < 3) {
                new View(externalDocument, i);
            }
            ExternalDocument externalDocument2 = documentCollection2.get(i);
            externalDocument2.setAllTags(true);
            externalDocument2.open();
            externalDocument2.stretch("ENAMEX");
            Vector<Annotation> vector = externalDocument2.annotationsOfType("TEXT");
            if (vector == null) {
                System.out.println("No <TEXT> in " + externalDocument.fileName() + ", cannot be scored.");
                continue;
            }
            if (i < 3) {
                new View(externalDocument2, i + 100);
            }
            HashSet<String> hashSet = new HashSet<String>();
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            SGMLScorer sGMLScorer = new SGMLScorer(externalDocument, externalDocument2);
            for (int j = 0; j < this.tagsToScore.length; ++j) {
                Vector<Annotation> vector2 = externalDocument.annotationsOfType("sentence");
                if (vector2 == null) continue;
                for (int k = 0; k < vector2.size(); ++k) {
                    Annotation annotation = vector2.get(k);
                    Span span = annotation.span();
                    int n11 = -1;
                    int n12 = 0;
                    for (int i2 = 0; i2 < this.N; ++i2) {
                        String string3 = "H" + k + "-" + i2;
                        hashSet.clear();
                        hashSet.add(string3);
                        externalDocument.setActiveHypotheses(hashSet);
                        sGMLScorer.match(this.tagsToScore[j], this.tagsToScore[j], span);
                        externalDocument.setActiveHypotheses(null);
                        if (i2 == 0) {
                            n6 += sGMLScorer.numOfTagsInDoc1;
                            n7 += sGMLScorer.numOfTagsInDoc2;
                            n8 += sGMLScorer.numOfMatchingAttrs;
                        }
                        if (sGMLScorer.numOfMatchingAttrs <= n11) continue;
                        n12 = sGMLScorer.numOfTagsInDoc1;
                        n11 = sGMLScorer.numOfMatchingAttrs;
                    }
                    n9 += n12;
                    n10 += n11;
                }
            }
            System.out.println("Total tags in baseline response:    " + n6);
            System.out.println("Total tags in best of N response:   " + n9);
            System.out.println("Total tags in key:                  " + n7);
            System.out.println("Matching attributes (baseline):     " + n8);
            System.out.println("Matching attributes (best of N):    " + n10);
            System.out.println("Attribute recall (baseline):        " + (float)n8 / (float)n7);
            System.out.println("Attribute precision (baseline):     " + (float)n8 / (float)n6);
            System.out.println("Attribute recall (best of N):       " + (float)n10 / (float)n7);
            System.out.println("Attribute precision (best of N):    " + (float)n10 / (float)n9);
            n += n6;
            n2 += n9;
            n3 += n7;
            n4 += n8;
            n5 += n10;
        }
        System.out.println("\nTotal baseline counts:");
        System.out.println("      matchingAttrs =   " + n4);
        System.out.println("      tagsInKeys =      " + n3);
        System.out.println("      tagsInResponses = " + n);
        System.out.println("Overall Baseline Attribute Recall:           " + (float)n4 / (float)n3);
        System.out.println("Overall Baseline Attribute Precision:        " + (float)n4 / (float)n);
        System.out.println("Overall Best of N Attribute Recall:          " + (float)n5 / (float)n3);
        System.out.println("Overall Best of N Attribute Precision:       " + (float)n5 / (float)n2);
    }

    public static void main(String[] stringArray) throws IOException {
        JetTest.initializeFromConfig("props/Nbest.properties");
        Ace.gazetteer = new Gazetteer();
        Ace.gazetteer.load("data/loc.dict");
        EDTtype.readTypeDict(dictFile);
        EDTtype.readGenericDict(genericFile);
        Ace.setPatternSet(patternFile);
        Pat.trace = false;
        Resolve.trace = false;
        Resolve.ACE = true;
        Ace.entityTrace = false;
        LearnRelations.relationTrace = false;
        Resolve.nameTypeMatch = true;
        XNameTagger.NbestScore();
    }

    private static void NbestScore() throws IOException {
        XNameTagger xNameTagger = new XNameTagger(WordFeatureHMMemitter.class);
        xNameTagger.annotator.setRecordProb(true);
        xNameTagger.load("acedata/ACEname04HMM.txt");
        xNameTagger.model.loadModel();
        String string = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/training04 nwire 20 sgm.txt";
        String string2 = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/training04 nwire 20 ne.txt";
        BigramHMMemitter.useBigrams = false;
        System.out.println("\nBaseline / upper bound\n");
        xNameTagger.scoreCollectionWithOracle(string, string2);
        System.out.println("\nN-Best\n");
        xNameTagger.scoreCollection(string, string2);
    }

    private static void NbestTrain() throws IOException {
        String string = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/training04 nwire 20 sgm.txt";
        String string2 = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/training04 nwire 20 ne.txt";
        XNameTagger xNameTagger = new XNameTagger(WordFeatureHMMemitter.class);
        xNameTagger.annotator.setRecordProb(true);
        xNameTagger.load("acedata/ACEname04HMM.txt");
        BigramHMMemitter.useBigrams = false;
        xNameTagger.NbestTrainCollection(string, string2);
    }

    public void NbestTrainCollection(String string, String string2) throws IOException {
        DocumentCollection documentCollection = new DocumentCollection(string);
        documentCollection.open();
        DocumentCollection documentCollection2 = new DocumentCollection(string2);
        documentCollection2.open();
        for (int i = 0; i < documentCollection.size(); ++i) {
            ExternalDocument externalDocument = documentCollection.get(i);
            externalDocument.setSGMLtags(this.tagsToRead);
            externalDocument.open();
            this.nameHMM.newDocument();
            ExternalDocument externalDocument2 = documentCollection2.get(i);
            externalDocument2.setSGMLtags(this.tagsToRead);
            externalDocument2.open();
            externalDocument2.stretch("ENAMEX");
            System.out.println("Annotating document " + i + ": " + externalDocument.fileName());
            this.NbestTrainDocument(externalDocument, externalDocument2);
        }
        this.model.buildModel();
        this.model.saveModel();
    }

    private void NbestTrainDocument(Document document, Document document2) {
        ArrayList[] arrayListArray;
        this.Fscore = new HashMap();
        this.corefMentionCount = new HashMap();
        this.relationCount = new HashMap();
        this.NEstring = new HashMap();
        this.relString = new HashMap();
        this.NEprob = new HashMap();
        SGMLScorer sGMLScorer = new SGMLScorer(document, document2);
        document.annotateWithTag("TEXT");
        Vector<Annotation> vector = document.annotationsOfType("TEXT");
        for (Annotation object2 : vector) {
            arrayListArray = object2.span();
            Ace.monocase = Ace.allLowerCase(document);
            SentenceSplitter.split(document, (Span)arrayListArray);
        }
        Vector<Annotation> vector2 = document.annotationsOfType("sentence");
        arrayListArray = new ArrayList[vector2.size()];
        this.NEchunkNbest(document, vector2, arrayListArray, true, sGMLScorer);
        document.setActiveHypotheses(null);
        new View(document, 0);
        for (int i = 0; i < vector2.size(); ++i) {
            Object object;
            String string;
            int n;
            System.out.println("### Analyzing hypotheses for sentence " + i);
            this.refresNbest(document, i, vector2, arrayListArray, this.corefMentionCount);
            this.relationNbest(document, i, vector2, arrayListArray, this.relationCount);
            ArrayList arrayList = arrayListArray[i];
            String string2 = (String)arrayList.get(0);
            double d = -1.0;
            for (n = 0; n < arrayList.size(); ++n) {
                string = (String)arrayList.get(n);
                object = this.Fscore.get(string);
                d = Math.max(d, (Double)object);
            }
            for (n = 0; n < arrayList.size(); ++n) {
                string = (String)arrayList.get(n);
                object = this.rescoringFeatures(string2, string);
                Double d2 = this.Fscore.get(string);
                boolean bl = d2 + 0.01 > d;
                ((Datum)object).setOutcome(bl ? "best" : "notBest");
                this.model.addEvent((Datum)object);
            }
        }
        document.setActiveHypotheses(null);
    }

    private Datum rescoringFeatures(String string, String string2) {
        Datum datum = new Datum();
        int n = this.NEprob.get(string);
        int n2 = this.corefMentionCount.get(string);
        int n3 = this.relationCount.get(string);
        Integer n4 = this.NEprob.get(string2);
        int n5 = n4 - n;
        datum.addFV("NEprob", Integer.toString(n5));
        Integer n6 = this.corefMentionCount.get(string2);
        int n7 = n6 - n2;
        datum.addFV("coref", Integer.toString(n7));
        Integer n8 = this.relationCount.get(string2);
        int n9 = n8 - n3;
        if (n9 > 0) {
            System.out.println("reln = " + n9 + " ------------");
            System.out.println("base: " + this.NEstring.get(string));
            System.out.println("base: " + this.relString.get(string));
            System.out.println("hypo: " + this.NEstring.get(string2));
            System.out.println("hypo: " + this.relString.get(string2));
        }
        datum.addFV("reln", Integer.toString(n9));
        return datum;
    }

    private Set<String> NbestTagDocument(Document document) {
        this.corefMentionCount = new HashMap();
        this.relationCount = new HashMap();
        this.NEprob = new HashMap();
        this.NEstring = new HashMap();
        this.relString = new HashMap();
        HashSet<String> hashSet = new HashSet<String>();
        document.annotateWithTag("TEXT");
        Vector<Annotation> vector = document.annotationsOfType("TEXT");
        for (Annotation arrayListArray2 : vector) {
            Span i = arrayListArray2.span();
            Ace.monocase = Ace.allLowerCase(document);
            SentenceSplitter.split(document, i);
        }
        Vector<Annotation> vector2 = document.annotationsOfType("sentence");
        ArrayList[] arrayListArray = new ArrayList[vector2.size()];
        this.NEchunkNbest(document, vector2, arrayListArray, false, null);
        for (int i = 0; i < vector2.size(); ++i) {
            int n;
            System.out.println("### Analyzing hypotheses for sentence " + i);
            ArrayList arrayList = arrayListArray[i];
            String string = (String)arrayList.get(0);
            if (arrayList.size() == 1) {
                System.out.println("    Only one hypothesis.");
                hashSet.add(string);
                continue;
            }
            String string2 = (String)arrayList.get(1);
            int n2 = this.NEprob.get(string);
            int n3 = n2 - (n = this.NEprob.get(string2).intValue());
            if (n3 > this.MARGIN_TO_SKIP_RESCORING) {
                System.out.println("    Margin = " + n3 + " (no rescoring)");
                hashSet.add(string);
                continue;
            }
            this.refresNbest(document, i, vector2, arrayListArray, this.corefMentionCount);
            this.relationNbest(document, i, vector2, arrayListArray, this.relationCount);
            String string3 = string;
            double d = 0.0;
            for (int j = 0; j < arrayList.size(); ++j) {
                String string4 = (String)arrayList.get(j);
                Datum datum = this.rescoringFeatures(string, string4);
                double d2 = this.model.prob(datum, "best");
                System.out.println("    Hypothesis " + string4 + " score " + d2);
                if (!(d2 > d)) continue;
                d = d2;
                string3 = string4;
            }
            hashSet.add(string3);
            if (string3.equals(string)) continue;
            System.out.println("    Picked hypothesis " + string3);
        }
        document.setActiveHypotheses(null);
        return hashSet;
    }

    private void NEchunkNbest(Document document, Vector vector, ArrayList[] arrayListArray, boolean bl, SGMLScorer sGMLScorer) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = (Annotation)vector.get(i);
            Span span = annotation.span();
            Tokenizer.tokenize(document, span);
            ArrayList arrayList = this.tag(document, span, "H" + i);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            int n = 0;
            for (int j = 0; j < arrayList.size(); ++j) {
                String string = (String)arrayList.get(j);
                document.setCurrentHypothesis(string);
                hashSet.clear();
                hashSet.add(string);
                document.setActiveHypotheses(hashSet);
                Vector<Annotation> vector2 = document.annotationsAt(span.start(), "HMMtags");
                Annotation annotation2 = vector2.get(0);
                Integer n2 = (Integer)annotation2.get("prob");
                if (j == 0) {
                    n = n2;
                } else if (n2 <= n - NE_PROBABILITY_WINDOW) break;
                arrayList2.add(string);
                this.NEprob.put(string, n2);
                if (bl) {
                    this.Fscore.put(string, XNameTagger.scoreSentence(sGMLScorer, span));
                }
                Control.processSentence(document, span);
            }
            arrayListArray[i] = arrayList2;
        }
    }

    static Double scoreSentence(SGMLScorer sGMLScorer, Span span) {
        sGMLScorer.match("ENAMEX", "ENAMEX", span);
        double d = sGMLScorer.numOfTagsInDoc2 == 0 ? 1.0 : (double)sGMLScorer.numOfMatchingAttrs / (double)sGMLScorer.numOfTagsInDoc2;
        double d2 = sGMLScorer.numOfTagsInDoc1 == 0 ? 1.0 : (double)sGMLScorer.numOfMatchingAttrs / (double)sGMLScorer.numOfTagsInDoc1;
        double d3 = 2.0 / (1.0 / d + 1.0 / d2);
        return new Double(d3);
    }

    private void refresNbest(Document document, int n, Vector<Annotation> vector, ArrayList[] arrayListArray, HashMap<String, Integer> hashMap) {
        Annotation annotation = vector.get(n);
        ArrayList arrayList = arrayListArray[n];
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            int n2;
            String string = (String)arrayList.get(i);
            System.out.println("### coref for hypothesis " + string);
            hashSet.clear();
            for (n2 = 0; n2 < vector.size(); ++n2) {
                if (n2 == n) {
                    hashSet.add(string);
                    continue;
                }
                hashSet.add((String)arrayListArray[n2].get(0));
            }
            document.setActiveHypotheses(hashSet);
            document.setCurrentHypothesis(null);
            for (n2 = 0; n2 < vector.size(); ++n2) {
                Annotation annotation2 = vector.get(n2);
                Span span = annotation2.span();
                Resolve.references(document, span);
            }
            hashMap.put(string, new Integer(XNameTagger.corefCount(document, annotation.span())));
            document.removeAnnotationsOfType("entity");
        }
    }

    static int corefCount(Document document, Span span) {
        Vector<Annotation> vector = document.annotationsOfType("entity");
        int n = 0;
        for (Annotation annotation : vector) {
            Vector vector2 = (Vector)annotation.get("mentions");
            boolean bl = false;
            for (int i = 0; i < vector2.size(); ++i) {
                Annotation annotation2 = (Annotation)vector2.get(i);
                Annotation annotation3 = Resolve.getHeadC(annotation2);
                if (!annotation2.span().within(span) || annotation3.get("cat") != "name") continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            n += Math.min(vector2.size() - 2, 1);
        }
        return n;
    }

    private void relationNbest(Document document, int n, Vector<Annotation> vector, ArrayList[] arrayListArray, HashMap<String, Integer> hashMap) {
        Annotation annotation = vector.get(n);
        Span span = annotation.span();
        ArrayList arrayList = arrayListArray[n];
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            System.out.println("### relations for hypothesis " + string);
            hashSet.clear();
            hashSet.add(string);
            document.setActiveHypotheses(hashSet);
            document.setCurrentHypothesis(null);
            Resolve.references(document, span);
            AceDocument aceDocument = new AceDocument(null, null, "X", document.text());
            Ace.buildAceEntities(document, "X", aceDocument);
            LearnRelations.findRelations(null, document, aceDocument);
            int n2 = aceDocument.relations.size();
            hashMap.put(string, new Integer(n2));
            document.removeAnnotationsOfType("entity");
            this.NEstring.put(string, document.writeSGML("ENAMEX", span));
            String string2 = "";
            for (int j = 0; j < aceDocument.relations.size(); ++j) {
                string2 = string2 + aceDocument.relations.get(j).toString();
            }
            this.relString.put(string, string2);
        }
    }
}

