/*
 * Decompiled with CFR 0.152.
 */
package Jet.Chunk;

import Jet.Chunk.TreeBasedChunker;
import Jet.Parser.DependencyAnalyzer;
import Jet.Parser.ParseTreeNode;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkDependencyAnalyzer {
    private TreeBasedChunker chunker = new TreeBasedChunker();
    private DependencyAnalyzer dependencyAnalyzer = new DependencyAnalyzer();

    public void analyzeChunkDependency(Document document, ParseTreeNode parseTreeNode) {
        Annotation annotation;
        this.chunker.chunk(document, parseTreeNode);
        this.dependencyAnalyzer.resolveTerminalDependency(parseTreeNode);
        List<Annotation> list = ChunkDependencyAnalyzer.getHeadMarkedTerminals(parseTreeNode);
        Vector<Annotation> vector = document.annotationsOfType("chunk", parseTreeNode.ann.span());
        Map<Annotation, Annotation> map = ChunkDependencyAnalyzer.makeTerminalToChunkMap(vector, list);
        for (Annotation annotation2 : list) {
            if (annotation2.get("isHead") != Boolean.TRUE || (annotation = (Annotation)annotation2.get("dep")) == null) continue;
            Annotation annotation3 = map.get(annotation2);
            Annotation annotation4 = map.get(annotation);
            if (annotation3 == null || annotation4 == null || annotation3 == annotation4) continue;
            annotation3.put("dep", annotation4);
        }
        block1: for (Annotation annotation2 : vector) {
            annotation = (Annotation)annotation2.get("dep");
            if (annotation != null || ChunkDependencyAnalyzer.hasHeadTerminal(document, annotation2)) continue;
            for (Annotation annotation4 : document.annotationsOfType("constit", annotation2.span())) {
                Annotation annotation5 = (Annotation)annotation4.get("dep");
                if (annotation5 == null || annotation5 == annotation4 || (annotation = map.get(annotation5)) == null) continue;
                annotation2.put("dep", annotation);
                continue block1;
            }
        }
        ChunkDependencyAnalyzer.removeHeadMark(list);
    }

    private static Map<Annotation, Annotation> makeTerminalToChunkMap(List<Annotation> list, List<Annotation> list2) {
        IdentityHashMap<Annotation, Annotation> identityHashMap = new IdentityHashMap<Annotation, Annotation>();
        block0: for (Annotation annotation : list2) {
            for (Annotation annotation2 : list) {
                if (!annotation.span().within(annotation2.span())) continue;
                identityHashMap.put(annotation, annotation2);
                continue block0;
            }
        }
        return identityHashMap;
    }

    private static List<Annotation> getHeadMarkedTerminals(ParseTreeNode parseTreeNode) {
        if (parseTreeNode.children == null) {
            return Collections.singletonList(parseTreeNode.ann);
        }
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        int n = 1;
        for (ParseTreeNode parseTreeNode2 : parseTreeNode.children) {
            if (parseTreeNode2.children != null) {
                arrayList.addAll(ChunkDependencyAnalyzer.getHeadMarkedTerminals(parseTreeNode2));
            } else {
                Annotation annotation = parseTreeNode2.ann;
                boolean bl = n == parseTreeNode.head;
                annotation.put("isHead", bl);
                arrayList.add(annotation);
            }
            ++n;
        }
        return arrayList;
    }

    private static void removeHeadMark(List<Annotation> list) {
        for (Annotation annotation : list) {
            annotation.remove("isHead");
        }
    }

    private static boolean hasHeadTerminal(Document document, Annotation annotation) {
        Vector<Annotation> vector = document.annotationsOfType("constit", annotation.span());
        if (vector == null) {
            return false;
        }
        for (Annotation annotation2 : vector) {
            if (annotation2.get("isHead") != Boolean.TRUE) continue;
            return true;
        }
        return false;
    }
}

