/*
 * Decompiled with CFR 0.152.
 */
package tratz.pos;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import tratz.ml.ClassScoreTuple;
import tratz.ml.LinearClassificationModel;
import tratz.parse.types.Token;
import tratz.pos.featgen.PosFeatureGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PosTagger {
    protected PosFeatureGenerator mFeatureGenerator;
    protected LinearClassificationModel mDecisionModule;

    public PosTagger(File modelFile) throws IOException, ClassNotFoundException {
        InputStream is = new FileInputStream(modelFile);
        if (modelFile.getName().endsWith(".gz")) {
            is = new GZIPInputStream(is);
        }
        ObjectInputStream ois = new ObjectInputStream(is);
        this.mDecisionModule = (LinearClassificationModel)ois.readObject();
        this.mFeatureGenerator = (PosFeatureGenerator)ois.readObject();
        ois.close();
    }

    public static List<Token> makeMeSomeTokens(String[] wordsInSentence) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        for (int i = 0; i < wordsInSentence.length; ++i) {
            tokens.add(new Token(wordsInSentence[i], i + 1));
        }
        return tokens;
    }

    public void posTag(List<Token> sentenceTokens) {
        this.posTag(sentenceTokens, false);
    }

    public void posTag(List<Token> sentenceTokens, boolean reverseDirection) {
        int numTokens = sentenceTokens.size();
        if (reverseDirection) {
            for (int j = numTokens - 1; j >= 0; --j) {
                this.posTag(sentenceTokens, j);
            }
        } else {
            for (int j = 0; j < numTokens; ++j) {
                this.posTag(sentenceTokens, j);
            }
        }
    }

    private void posTag(List<Token> sentenceTokens, int index) {
        Token t = sentenceTokens.get(index);
        Set<String> feats = this.mFeatureGenerator.getFeats(sentenceTokens, index);
        ClassScoreTuple[] classRankings = this.mDecisionModule.getDecision(feats);
        t.setPos(classRankings[0].clazz);
    }
}

