/*
 * Decompiled with CFR 0.152.
 */
package tratz.parse.transform;

import java.util.ArrayList;
import java.util.List;
import tratz.parse.transform.ParseTransform;
import tratz.parse.types.Arc;
import tratz.parse.types.Parse;
import tratz.parse.types.Token;

public class CopTransformer
implements ParseTransform {
    public void performTransformation(Parse parse) {
        Arc[] tokenToHead = parse.getHeadArcs();
        List[] tokenToArcs = parse.getDependentArcLists();
        boolean[] modified = new boolean[tokenToHead.length];
        for (int i = tokenToHead.length - 1; i >= 0; --i) {
            Arc arc = tokenToHead[i];
            if (arc == null || !arc.getDependency().equals("cop") || modified[i]) continue;
            Token arcHead = arc.getHead();
            Token arcChild = arc.getChild();
            List siblings = tokenToArcs[arcHead.getIndex()];
            boolean hasExpl = false;
            for (Arc sibling : siblings) {
                if (!sibling.getDependency().equals("expl")) continue;
                hasExpl = true;
                break;
            }
            if (hasExpl) {
                arc.setDependency("nsubj");
                continue;
            }
            siblings.remove(arc);
            ArrayList<Arc> kids = tokenToArcs[arcChild.getIndex()];
            if (kids == null) {
                tokenToArcs[arcChild.getIndex()] = kids = new ArrayList<Arc>();
            }
            for (Arc sibling : siblings) {
                sibling.setHead(arcChild);
            }
            for (Arc kid : kids) {
                if (!kid.getDependency().equals("infmod")) continue;
                kid.setDependency("xcomp");
            }
            kids.addAll(siblings);
            siblings.clear();
            Arc grandparentArc = tokenToHead[arcHead.getIndex()];
            if (grandparentArc != null && grandparentArc.getHead() != null) {
                arc.setDependency(grandparentArc.getDependency());
                Token grandparent = grandparentArc.getHead();
                arc.setHead(grandparent);
                ArrayList<Arc> children = tokenToArcs[grandparent.getIndex()];
                if (children == null) {
                    tokenToArcs[grandparentArc.getHead().getIndex()] = children = new ArrayList<Arc>();
                }
                children.add(arc);
                children.remove(grandparentArc);
                kids.add(grandparentArc);
            } else {
                arc.setDependency("ROOT");
                arc.setHead(parse.getRoot());
                ArrayList<Arc> rootChildren = tokenToArcs[0];
                if (rootChildren == null) {
                    tokenToArcs[0] = rootChildren = new ArrayList<Arc>();
                }
                rootChildren.add(arc);
                if (grandparentArc == null) {
                    tokenToHead[arcHead.getIndex()] = grandparentArc = new Arc(arcHead, arcChild, "cop");
                }
                rootChildren.remove(grandparentArc);
                kids.add(grandparentArc);
            }
            grandparentArc.setHead(arcChild);
            grandparentArc.setDependency("cop");
            modified[arcHead.getIndex()] = true;
        }
    }
}

