/*
 * Decompiled with CFR 0.152.
 */
package tratz.featgen;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import tratz.featgen.InitException;
import tratz.featgen.WfrEntry;
import tratz.featgen.fer.FeatureExtractionRule;
import tratz.featgen.wfr.WordFindingRule;

public class FeatureGenerationConfigurationReader
extends DefaultHandler {
    public static final String WFR_TAG = "wfr";
    public static final String FER_TAG = "fer";
    public static final String COMBO_TAG = "combo";
    public static final String PARAMS_TAG = "params";
    public static final String PARAM_TAG = "param";
    public static final String FER_LIST_TAG = "ferlist";
    public static final String CLASSNAME_ATT = "classname";
    public static final String PREFIX_ATT = "prefix";
    public static final String NAME_ATT = "name";
    public static final String COMBO_TYPE_ATT = "comboType";
    public static final String COMBO_WFR_PREFIX1 = "wfrPrefix1";
    public static final String COMBO_WFR_PREFIX2 = "wfrPrefix2";
    public static final String COMBO_FER_PREFIX1 = "ferPrefix1";
    public static final String COMBO_FER_PREFIX2 = "ferPrefix2";
    public static final String KEY_ATT = "key";
    public static final String VALUE_ATT = "value";
    private Set<String> mWfrNames;
    private Map<String, FeatureExtractionRule> mFerMap;
    private List<WfrEntry> mWfrEntries;
    private String mWfrClass;
    private String mWfrName;
    private String mWfrPrefix;
    private String mFerClass;
    private String mFerName;
    private String mFerPrefix;
    private String mComboWfrPrefix1;
    private String mComboWfrPrefix2;
    private String mComboFerPrefix1;
    private String mComboFerPrefix2;
    private Map<String, String> mParams;
    private List<FeatureExtractionRule> mFers;

    public static void read(File configurationFile) throws IOException {
        SAXParserFactory mParserFactory = SAXParserFactory.newInstance();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(configurationFile));
            InputSource inputSource = new InputSource(reader);
            FeatureGenerationConfigurationReader handler = new FeatureGenerationConfigurationReader();
            SAXParser parser = mParserFactory.newSAXParser();
            XMLReader xmlReader = parser.getXMLReader();
            xmlReader.setContentHandler(handler);
            xmlReader.parse(inputSource);
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException();
        }
    }

    public void startDocument() {
        this.mWfrNames = new HashSet<String>();
        this.mWfrEntries = new ArrayList<WfrEntry>();
        this.mFerMap = new HashMap<String, FeatureExtractionRule>();
        this.resetState();
    }

    public void endDocument() {
    }

    private void resetState() {
        this.mWfrClass = null;
        this.mWfrName = null;
        this.mWfrPrefix = null;
        this.mFerClass = null;
        this.mFerName = null;
        this.mFerPrefix = null;
        this.mComboWfrPrefix1 = null;
        this.mComboWfrPrefix2 = null;
        this.mComboFerPrefix1 = null;
        this.mComboFerPrefix2 = null;
        this.mParams = null;
        this.mFers = null;
    }

    public void startElement(String uri, String localName, String qname, Attributes attr) throws SAXParseException {
        System.out.println("Start element: local name: " + localName + " qname: " + qname + " uri: " + uri);
        if (localName.equals(WFR_TAG)) {
            this.resetState();
            this.mWfrClass = attr.getValue(CLASSNAME_ATT);
            this.mWfrName = attr.getValue(NAME_ATT);
            this.mWfrPrefix = attr.getValue(PREFIX_ATT);
            if (this.mWfrNames.contains(this.mWfrName)) {
                throw new SAXParseException("Error. Duplicate WFR name: " + this.mFerName, null);
            }
        } else if (localName.equals(FER_TAG)) {
            this.resetState();
            this.mFerClass = attr.getValue(CLASSNAME_ATT);
            this.mFerName = attr.getValue(NAME_ATT);
            this.mFerPrefix = attr.getValue(PREFIX_ATT);
            if (this.mFerMap.containsKey(this.mFerName)) {
                throw new SAXParseException("Error. Duplicate FER name: " + this.mFerName, null);
            }
        } else if (localName.equals(COMBO_TAG)) {
            this.resetState();
        } else if (localName.equals(FER_LIST_TAG)) {
            this.mFers = new ArrayList<FeatureExtractionRule>();
        } else if (localName.equals(PARAMS_TAG)) {
            this.mParams = new HashMap<String, String>();
        } else if (localName.equals(PARAM_TAG)) {
            String key = attr.getValue(KEY_ATT);
            String value = attr.getValue(VALUE_ATT);
            this.mParams.put(key, value);
        }
    }

    public void endElement(String uri, String localName, String qname) throws SAXParseException {
        try {
            if (localName.equals(WFR_TAG)) {
                WordFindingRule wfr = (WordFindingRule)Class.forName(this.mWfrClass).newInstance();
                wfr.init(this.mParams);
                this.mWfrNames.add(this.mWfrName);
                this.mWfrEntries.add(new WfrEntry(this.mWfrName, this.mWfrPrefix, this.mFers, wfr));
            } else if (localName.equals(FER_TAG)) {
                FeatureExtractionRule fer = (FeatureExtractionRule)Class.forName(this.mFerClass).newInstance();
                fer.init(this.mParams);
                this.mFerMap.put(this.mFerName, fer);
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new SAXParseException(cnfe.getMessage(), null);
        }
        catch (IllegalAccessException iae) {
            throw new SAXParseException(iae.getMessage(), null);
        }
        catch (InstantiationException ie) {
            throw new SAXParseException(ie.getMessage(), null);
        }
        catch (InitException ie) {
            throw new SAXParseException(ie.getMessage(), null);
        }
    }

    public void characters(char[] ch, int start, int length) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    public void warning(SAXParseException spe) {
        System.out.println("SAX parse exception for line " + spe.getLineNumber());
    }

    public void fatalError(SAXParseException spe) throws SAXException {
        System.out.println("SAX parse fatal error for line " + spe.getLineNumber());
        throw spe;
    }
}

