/*
 * Decompiled with CFR 0.152.
 */
package Jet.Pat;

import Jet.Pat.Id;
import Jet.Pat.PatternApplication;
import Jet.Pat.PatternArc;
import Jet.Pat.PatternNode;
import Jet.Pat.PatternSet;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class InternalPatternNode
extends PatternNode {
    public PatternArc[] arcs;

    public InternalPatternNode(Id id, PatternArc[] patternArcArray) {
        this.id = id;
        this.arcs = patternArcArray;
    }

    public InternalPatternNode(Id id, Vector vector) {
        this.id = id;
        this.arcs = vector.toArray(new PatternArc[0]);
    }

    public void eval(Document document, int n, HashMap hashMap, PatternApplication patternApplication) {
        if (n > PatternSet.limit) {
            return;
        }
        Annotation annotation = document.tokenAt(n);
        String string = annotation == null ? null : document.text(annotation).trim().intern();
        for (int i = 0; i < this.arcs.length; ++i) {
            this.arcs[i].eval(document, n, string, hashMap, patternApplication);
        }
    }

    public String toString() {
        String string = "";
        if (this.arcs.length == 1) {
            string = string + this.arcs[0].pe.toString() + " " + this.arcs[0].target.id.value;
            if (!this.arcs[0].target.visited()) {
                this.arcs[0].target.visit();
                string = string + " " + this.arcs[0].target.toString();
            }
        } else if (this.arcs.length > 1) {
            string = string + "(" + this.arcs[0].pe.toString() + " " + this.arcs[0].target.id.value;
            if (!this.arcs[0].target.visited()) {
                this.arcs[0].target.visit();
                string = string + " " + this.arcs[0].target.toString();
            }
            for (int i = 1; i < this.arcs.length; ++i) {
                string = string + " | " + this.arcs[i].pe.toString() + " " + this.arcs[i].target.id.value;
                if (this.arcs[i].target.visited()) continue;
                this.arcs[i].target.visit();
                string = string + " " + this.arcs[i].target.toString();
            }
            string = string + ")";
        }
        return string;
    }

    public void toTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        for (int i = 0; i < this.arcs.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.arcs[i].pe.toString() + " NODE_" + this.arcs[i].target.id.value);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            if (this.arcs[i].target.visited()) continue;
            this.arcs[i].target.visit();
            this.arcs[i].target.toTree(defaultMutableTreeNode2);
        }
    }
}

