/*
 * Decompiled with CFR 0.152.
 */
package Jet.HMM;

import Jet.HMM.HMM;
import Jet.HMM.HMMannotator;
import Jet.HMM.HMMarc;
import Jet.HMM.HMMstate;
import Jet.HMM.Retagger;
import Jet.HMM.WordFeatureHMMemitter;
import Jet.Lisp.FeatureSet;
import Jet.Scorer.SGMLScorer;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.DocumentCollection;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

public class HMMTagger {
    public static boolean trace = false;
    static SGMLScorer scorer = null;
    static String[] posTable = new String[]{"CC", "CD", "DT", "EX", "FW", "IN", "JJ", "JJR", "JJS", "LS", "MD", "NN", "NNS", "NNP", "NNPS", "PDT", "POS", "PRP", "PRP$", "RB", "RBR", "RBS", "RP", "SYM", "TO", "UH", "VB", "VBD", "VBG", "VBN", "VBP", "VBZ", "WDT", "WP", "WP$", "WRB", "#", "$", ".", ",", ":", "(", ")", "`", "``", "'", "''", "-LRB-", "-RRB-"};
    HMM posh = new HMM(WordFeatureHMMemitter.class);
    HMMannotator annotator = null;
    String[][] tagTable = new String[posTable.length][];

    void train(String string) {
        int n;
        Object object;
        for (int i = 0; i < posTable.length; ++i) {
            this.tagTable[i] = new String[]{"constit", "cat", posTable[i], posTable[i]};
        }
        HMMstate hMMstate = new HMMstate("start", "", WordFeatureHMMemitter.class);
        this.posh.addState(hMMstate);
        for (int i = 0; i < posTable.length; ++i) {
            hMMstate.addArc(new HMMarc(posTable[i], 0));
        }
        HMMstate hMMstate2 = new HMMstate("end", "", WordFeatureHMMemitter.class);
        this.posh.addState(hMMstate2);
        for (int i = 0; i < posTable.length; ++i) {
            String string2 = posTable[i];
            object = new HMMstate(string2, string2, WordFeatureHMMemitter.class);
            this.posh.addState((HMMstate)object);
            for (n = 0; n < posTable.length; ++n) {
                ((HMMstate)object).addArc(new HMMarc(posTable[n], 0));
            }
            ((HMMstate)object).addArc(new HMMarc("end", 0));
        }
        this.posh.resolveNames();
        this.posh.resetForTraining();
        this.annotator = new HMMannotator(this.posh);
        this.annotator.setTagTable(this.tagTable);
        this.annotator.setBItag(false);
        DocumentCollection documentCollection = new DocumentCollection(string);
        documentCollection.open();
        for (int i = 0; i < documentCollection.size(); ++i) {
            Vector<Annotation> vector;
            object = documentCollection.get(i);
            ((ExternalDocument)object).open();
            System.out.println("Training from " + ((ExternalDocument)object).fileName());
            int n2 = n = 0;
            while ((vector = ((Document)object).annotationsAt(n, "constit")) != null) {
                Annotation annotation = vector.get(0);
                n = annotation.span().end();
                String string3 = (String)annotation.get("cat");
                if (!string3.equals(".")) continue;
                ((Document)object).annotate("S", new Span(n2, n), new FeatureSet());
                n2 = n;
            }
            this.annotator.train((Document)object);
            ((Document)object).clearAnnotations();
        }
        this.posh.computeProbabilities();
    }

    public void store(String string) throws IOException {
        this.posh.store(new PrintWriter(new FileOutputStream(string)));
    }

    public void load(String string) throws IOException {
        this.posh.load(new BufferedReader(new FileReader(string)));
    }

    public void tagPenn(Document document, Span span) {
        this.annotate(document, span, "constit");
    }

    public void annotate(Document document, Span span, String string) {
        for (int i = 0; i < posTable.length; ++i) {
            this.tagTable[i] = new String[]{string, "cat", posTable[i], posTable[i]};
        }
        this.annotator = new HMMannotator(this.posh);
        this.annotator.setTagTable(this.tagTable);
        this.annotator.setBItag(false);
        this.annotator.setTrace(trace);
        this.annotator.annotateSpan(document, span);
    }

    public void score(Document document, Document document2) {
        scorer = new SGMLScorer(document, document2);
        scorer.match("constit");
        System.out.println("Constit tags in response:  " + HMMTagger.scorer.numOfTagsInDoc1);
        System.out.println("Constit tags in key:       " + HMMTagger.scorer.numOfTagsInDoc2);
        System.out.println("Matching constit tags:  " + HMMTagger.scorer.numOfMatchingTags);
        System.out.println("Matching POS     tags:  " + HMMTagger.scorer.numOfMatchingAttrs);
        System.out.println("Accuracy:  " + (float)HMMTagger.scorer.numOfMatchingAttrs / (float)HMMTagger.scorer.numOfMatchingTags);
    }

    public void tagJet(Document document, Span span) {
        this.annotate(document, span, "tagger");
        Retagger.mapConstit(document, span);
    }

    public void prune(Document document, Span span) {
        this.annotate(document, span, "tagger");
        Retagger.pruneConstit(document, span);
    }
}

