/*
 * Decompiled with CFR 0.152.
 */
package Jet.HMM;

import Jet.Chunk.TokenClassifier;
import Jet.HMM.BasicHMMemitter;
import Jet.HMM.HMMarc;
import Jet.HMM.HMMstate;
import Jet.JetTest;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class HMM
extends TokenClassifier {
    HashMap statesByName;
    ArrayList states = new ArrayList();
    ArrayList arcs;
    int startState = -1;
    int endState = -1;
    Class emitterClass;
    HashSet cache;
    String[] tagsToCache;
    double smallestDifference = 0.0;
    protected static final double UNLIKELY = -1.0E100;
    static boolean probReport = false;
    static boolean cacheTrace = false;
    private String excludedTag = null;
    int excludedTagStart = 0;
    int excludedTagEnd = 0;
    private int nTokens;
    private double[][] pathProb;
    private int[][] backPointer;
    private SortedSet deviationSet;
    HashMap allStateTokenCount;
    HashMap allStateLCtokenCount;
    public double viterbiProbability = 0.0;
    public double pathProbability = 0.0;
    private double margin;
    private boolean recordMargin = false;
    private boolean recordLocalMargin = false;
    private boolean Nbest = false;
    static final int NO_BACK_POINTER = -1;
    static final int MULTIPLE_BACK_POINTERS = -2;

    public HMM() {
        this(BasicHMMemitter.class);
    }

    public HMM(Class clazz) {
        this.statesByName = new HashMap();
        this.arcs = new ArrayList();
        this.emitterClass = clazz;
        this.tagsToCache = null;
        this.cache = new HashSet();
        this.allStateTokenCount = new HashMap();
        this.allStateLCtokenCount = new HashMap();
    }

    public void setTagsToCache(String[] stringArray) {
        this.tagsToCache = stringArray;
    }

    public void load(Reader reader) throws IOException {
        String string;
        HMMstate hMMstate = null;
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((string = bufferedReader.readLine()) != null) {
            try {
                String string2;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                if (!stringTokenizer.hasMoreTokens()) continue;
                String string3 = stringTokenizer.nextToken();
                if (string3.equalsIgnoreCase("state")) {
                    if (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        hMMstate = new HMMstate(string2, "", this.emitterClass);
                        this.addState(hMMstate);
                        hMMstate.resetForTraining();
                        continue;
                    }
                    throw new HMMerror("state name missing");
                }
                if (string3.equalsIgnoreCase("arc")) {
                    if (!stringTokenizer.hasMoreTokens() || !stringTokenizer.nextToken().equalsIgnoreCase("to")) {
                        throw new HMMerror("'to' missing");
                    }
                    if (!stringTokenizer.hasMoreTokens()) {
                        throw new HMMerror("state name missing");
                    }
                    string2 = stringTokenizer.nextToken();
                    int n = 1;
                    if (stringTokenizer.hasMoreTokens()) {
                        try {
                            n = Integer.parseInt(stringTokenizer.nextToken());
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new HMMerror("invalid count for arc");
                        }
                    }
                    HMMarc hMMarc = new HMMarc(string2, n);
                    this.arcs.add(hMMarc);
                    if (hMMstate == null) {
                        throw new HMMerror("no initial state for arc");
                    }
                    hMMstate.addArc(hMMarc);
                    hMMstate.count += n;
                    continue;
                }
                if (string3.equalsIgnoreCase("emit")) {
                    if (!stringTokenizer.hasMoreTokens()) {
                        throw new HMMerror("token missing");
                    }
                    string2 = stringTokenizer.nextToken();
                    String string4 = "";
                    if (hMMstate == null) {
                        throw new HMMerror("no state for emit");
                    }
                    if (stringTokenizer.countTokens() > 1) {
                        string4 = string2;
                        string2 = stringTokenizer.nextToken();
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        try {
                            int n = Integer.parseInt(stringTokenizer.nextToken());
                            hMMstate.incrementEmitCount(string2, string4, n);
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new HMMerror("invalid count for token");
                        }
                    }
                    hMMstate.incrementEmitCount(string2, string4, 1);
                    continue;
                }
                if (string3.equalsIgnoreCase("feature")) {
                    if (!stringTokenizer.hasMoreTokens()) {
                        throw new HMMerror("feature name missing");
                    }
                    string2 = stringTokenizer.nextToken();
                    if (hMMstate == null) {
                        throw new HMMerror("no state for allow");
                    }
                    hMMstate.setFeatureName(string2);
                    while (stringTokenizer.hasMoreTokens()) {
                        hMMstate.addAllowedFeatureValue(stringTokenizer.nextToken());
                    }
                    continue;
                }
                if (string3.equalsIgnoreCase("tag")) {
                    if (!stringTokenizer.hasMoreTokens()) {
                        throw new HMMerror("token missing");
                    }
                    string2 = stringTokenizer.nextToken();
                    if (hMMstate == null) {
                        throw new HMMerror("no state for tag");
                    }
                    hMMstate.tag = string2;
                    continue;
                }
                if (string3.equalsIgnoreCase("prevTagged")) {
                    if (!stringTokenizer.hasMoreTokens()) {
                        throw new HMMerror("token missing");
                    }
                    string2 = stringTokenizer.nextToken();
                    if (stringTokenizer.hasMoreTokens()) {
                        try {
                            int n = Integer.parseInt(stringTokenizer.nextToken());
                            hMMstate.setCacheCount(string2, n);
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new HMMerror("invalid count for token");
                        }
                    }
                    hMMstate.setCacheCount(string2, 1);
                    continue;
                }
                throw new HMMerror("unrecognized input line");
            }
            catch (HMMerror hMMerror) {
                System.out.println(">> " + string);
                System.out.println("Error:  " + hMMerror.getMessage());
            }
        }
        this.resolveNames();
        this.computeProbabilities();
    }

    public void load(String string) {
        try {
            this.load(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), JetTest.encoding)));
        }
        catch (IOException iOException) {
            System.out.println("HMM.load:  Unable to load HMM");
            System.out.println(iOException);
        }
    }

    void resolveNames() {
        Iterator iterator = this.states.iterator();
        while (iterator.hasNext()) {
            ((HMMstate)iterator.next()).resolveNames(this.statesByName, this.states.size());
        }
    }

    public void addState(HMMstate hMMstate) {
        String string = hMMstate.name;
        hMMstate.setHMM(this);
        this.statesByName.put(string, new Integer(this.states.size()));
        if (string.equalsIgnoreCase("start")) {
            this.startState = this.states.size();
        }
        if (string.equalsIgnoreCase("end")) {
            this.endState = this.states.size();
        }
        this.states.add(hMMstate);
    }

    public HMMstate getState(String string) {
        Integer n = (Integer)this.statesByName.get(string);
        if (n == null) {
            return null;
        }
        return (HMMstate)this.states.get(n);
    }

    public void resetForTraining() {
        Iterator iterator = this.states.iterator();
        while (iterator.hasNext()) {
            ((HMMstate)iterator.next()).resetForTraining();
        }
    }

    public void newDocument() {
        this.cache = new HashSet();
    }

    void addToCache(String string, String string2) {
        for (int i = 0; i < this.tagsToCache.length; ++i) {
            if (!string2.equals(this.tagsToCache[i])) continue;
            this.cache.add(string + "|" + string2);
            return;
        }
    }

    boolean inCache(String string, String string2) {
        if (string.equalsIgnoreCase("the")) {
            return false;
        }
        if (string.equalsIgnoreCase("of")) {
            return false;
        }
        return this.cache.contains(string + "|" + string2);
    }

    public void train0(Document document, Annotation[] annotationArray, String[] stringArray) {
        int n = this.startState;
        int n2 = annotationArray.length;
        int n3 = this.states.size();
        String string = "";
        for (int i = 0; i < n2; ++i) {
            Annotation annotation = annotationArray[i];
            String string2 = document.text(annotation).trim();
            String string3 = stringArray[i];
            HMMstate hMMstate = (HMMstate)this.states.get(n);
            ++hMMstate.count;
            int n4 = -1;
            for (int j = 0; j < n3; ++j) {
                if (hMMstate.arcs[j] == null) continue;
                HMMstate hMMstate2 = (HMMstate)this.states.get(j);
                if (!hMMstate2.tag.equals(string3)) continue;
                if (n4 >= 0) {
                    System.out.println("Training error:  multiple successor states");
                    System.out.print("from state " + hMMstate.name);
                    System.out.println(" with tag " + string3);
                }
                n4 = j;
            }
            if (n4 < 0) {
                System.out.println("Training error:  no successor states");
                System.out.print("from state " + hMMstate.name);
                System.out.println(" with tag " + string3);
                return;
            }
            ++hMMstate.arcs[n4].count;
            HMMstate hMMstate3 = (HMMstate)this.states.get(n4);
            hMMstate3.incrementEmitCount(string2, string, 1);
            if (this.tagsToCache != null) {
                this.addToCache(string2, string3);
            }
            n = n4;
            string = string2;
        }
        HMMstate hMMstate = (HMMstate)this.states.get(n);
        ++hMMstate.count;
        if (hMMstate.arcs[this.endState] == null) {
            System.out.println("Training error:  can't reach final state");
            System.out.println("from state " + hMMstate.name);
            return;
        }
        ++hMMstate.arcs[this.endState].count;
    }

    public void train(Document document, Annotation[] annotationArray, String[] stringArray) {
        Object object;
        int n;
        int n2;
        Object object2;
        int n3;
        int n4 = this.states.size();
        int n5 = annotationArray.length;
        int[][] nArray = new int[n5 + 1][n4];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[0][n3] = -1;
        }
        nArray[0][this.startState] = 0;
        for (n3 = 1; n3 <= n5; ++n3) {
            Annotation annotation = annotationArray[n3 - 1];
            object2 = stringArray[n3 - 1];
            n2 = 0;
            for (n = 0; n < n4; ++n) {
                HMMstate hMMstate = (HMMstate)this.states.get(n);
                int n6 = -1;
                if (hMMstate.tag.equals(object2) && hMMstate.allowedToken(annotation)) {
                    for (int i = 0; i < n4; ++i) {
                        object = (HMMstate)this.states.get(i);
                        if (((HMMstate)object).arcs[n] == null || nArray[n3 - 1][i] == -1) continue;
                        n2 = 1;
                        n6 = n6 == -1 ? i : -2;
                    }
                }
                nArray[n3][n] = n6;
            }
            if (n2 != 0) continue;
            System.out.println("HMM.train:  training error:  no successor states");
            System.out.print("at token " + document.text(annotation).trim());
            System.out.println(" with tag " + (String)object2);
            return;
        }
        if (this.endState < 0) {
            System.out.println("No end state for HMM.");
            return;
        }
        n3 = -1;
        for (int i = 0; i < n4; ++i) {
            object2 = (HMMstate)this.states.get(i);
            if (((HMMstate)object2).arcs[this.endState] == null || nArray[n5][i] == -1) continue;
            n3 = n3 == -1 ? i : -2;
        }
        int[] nArray2 = new int[n5 + 2];
        nArray2[n5 + 1] = this.endState;
        int n7 = n3;
        for (n2 = n5; n2 >= 0; --n2) {
            if (n7 == -1) {
                System.out.println("HMM.train:  no back pointer");
                System.out.println("Error occurred at token " + n2 + " = " + document.text(annotationArray[n2 - 1]).trim());
                return;
            }
            if (n7 == -2) {
                System.out.println("HMM.train:  multiple back pointers");
                return;
            }
            nArray2[n2] = n7;
            n7 = nArray[n2][n7];
        }
        String string = "";
        for (n = 0; n <= n5; ++n) {
            n7 = nArray2[n];
            int n8 = nArray2[n + 1];
            HMMstate hMMstate = (HMMstate)this.states.get(n7);
            ++hMMstate.count;
            ++hMMstate.arcs[n8].count;
            if (n <= 0) continue;
            String string2 = document.text(annotationArray[n - 1]).trim();
            hMMstate.incrementEmitCount(string2, string, 1);
            if (this.tagsToCache != null) {
                object = stringArray[n - 1];
                this.addToCache(string2, (String)object);
            }
            string = string2;
        }
    }

    public void computeProbabilities() {
        Iterator iterator = this.states.iterator();
        while (iterator.hasNext()) {
            ((HMMstate)iterator.next()).computeProbabilities();
        }
    }

    public void createModel() {
        this.computeProbabilities();
    }

    public void print() {
        Iterator iterator = this.states.iterator();
        while (iterator.hasNext()) {
            ((HMMstate)iterator.next()).print();
        }
    }

    public void store(PrintWriter printWriter) {
        Iterator iterator = this.states.iterator();
        while (iterator.hasNext()) {
            ((HMMstate)iterator.next()).store(printWriter);
        }
        printWriter.close();
    }

    public void store(String string) {
        try {
            this.store(new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), JetTest.encoding))));
        }
        catch (IOException iOException) {
            System.out.println("HMM.store:  unable to store HMM.");
            System.out.println(iOException);
        }
    }

    public int[] viterbiPath(Document document, Annotation[] annotationArray) {
        double d;
        double d2;
        this.viterbiProbability = 0.0;
        int n = this.states.size();
        this.nTokens = annotationArray.length;
        this.pathProb = new double[this.nTokens + 1][n];
        this.backPointer = new int[this.nTokens + 2][n];
        double[][] dArray = null;
        if (this.recordMargin | this.recordLocalMargin) {
            dArray = new double[this.nTokens + 1][n];
        }
        if (this.startState < 0) {
            System.out.println("No start state for HMM.");
            return null;
        }
        for (int i = 0; i < n; ++i) {
            this.pathProb[0][i] = i == this.startState ? 0.0 : -1.0E100;
        }
        String string = "";
        for (int i = 1; i <= this.nTokens; ++i) {
            Annotation annotation = annotationArray[i - 1];
            String string2 = document.text(annotation).trim();
            for (int j = 0; j < n; ++j) {
                HMMstate hMMstate = (HMMstate)this.states.get(j);
                double d3 = hMMstate.getEmissionProb(string2, string, annotation);
                d2 = -1.0E100;
                d = -1.0E100;
                int n2 = -1;
                for (int k = 0; k < n; ++k) {
                    double d4;
                    HMMstate hMMstate2 = (HMMstate)this.states.get(k);
                    double d5 = this.pathProb[i - 1][k] + hMMstate2.getTransitionProb(j) + d3;
                    if (d5 > d2) {
                        if (!this.recordLocalMargin) {
                            d = d2;
                        }
                        d2 = d5;
                        n2 = k;
                    }
                    if (!this.recordLocalMargin) continue;
                    if (this.violatesConstraint(i - 1, hMMstate)) {
                        if (!(d5 > d)) continue;
                        d = d5;
                        continue;
                    }
                    if (i <= 1 || !((d4 = dArray[i - 1][k] + hMMstate2.getTransitionProb(j) + d3) > d)) continue;
                    d = d4;
                }
                this.pathProb[i][j] = d2;
                this.backPointer[i][j] = n2;
                if (!(this.recordMargin | this.recordLocalMargin)) continue;
                dArray[i][j] = d;
            }
            string = string2;
        }
        if (this.endState < 0) {
            System.out.println("No end state for HMM.");
            return null;
        }
        double d6 = -1.0E100;
        double d7 = -1.0E100;
        int n3 = -1;
        for (int i = 0; i < n; ++i) {
            HMMstate hMMstate = (HMMstate)this.states.get(i);
            d2 = this.pathProb[this.nTokens][i] + hMMstate.getTransitionProb(this.endState);
            if (d2 > d6) {
                d6 = d2;
                n3 = i;
            }
            if (!this.recordLocalMargin || !((d = dArray[this.nTokens][i] + hMMstate.getTransitionProb(this.endState)) > d7)) continue;
            d7 = d;
        }
        this.backPointer[this.nTokens + 1][this.endState] = n3;
        int[] nArray = new int[this.nTokens + 2];
        nArray[this.nTokens + 1] = this.endState;
        int n4 = n3;
        this.margin = 2.0E100;
        for (int i = this.nTokens - 1; i >= 0; --i) {
            if (n4 < 0) {
                return null;
            }
            nArray[i + 1] = n4;
            HMMstate hMMstate = (HMMstate)this.states.get(n4);
            String string3 = hMMstate.tag;
            if (this.tagsToCache != null) {
                String string4 = document.text(annotationArray[i]).trim();
                if (cacheTrace) {
                    System.out.println("Adding " + string4 + " to cache with tag " + string3);
                }
                this.addToCache(string4, string3);
            }
            nArray[0] = this.startState;
            if (this.recordMargin && this.pathProb[i + 1][n4] - dArray[i + 1][n4] < this.margin) {
                this.margin = this.pathProb[i + 1][n4] - dArray[i + 1][n4];
            }
            n4 = this.backPointer[i + 1][n4];
        }
        this.viterbiProbability = d6;
        if (this.recordLocalMargin) {
            this.margin = d6 - d7;
        }
        this.pathProbability = this.viterbiProbability;
        if (this.Nbest) {
            this.deviationSet = new TreeSet();
            this.addDeviations(nArray, this.viterbiProbability, this.nTokens + 1);
        }
        return nArray;
    }

    public String[] viterbi(Document document, Annotation[] annotationArray) {
        int[] nArray = this.viterbiPath(document, annotationArray);
        if (nArray == null) {
            return null;
        }
        int n = annotationArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            HMMstate hMMstate = (HMMstate)this.states.get(nArray[i + 1]);
            stringArray[i] = hMMstate.tag;
        }
        return stringArray;
    }

    public double getPathProbability() {
        return this.pathProbability;
    }

    public void recordMargin() {
        this.recordMargin = true;
    }

    public double getMargin() {
        return this.margin;
    }

    public double getLocalMargin(Document document, Annotation[] annotationArray, String string, int n, int n2) {
        this.excludedTag = string;
        this.excludedTagStart = n;
        this.excludedTagEnd = n2;
        this.recordLocalMargin = true;
        this.viterbi(document, annotationArray);
        this.recordLocalMargin = false;
        return this.margin;
    }

    private boolean violatesConstraint(int n, HMMstate hMMstate) {
        return n == this.excludedTagStart - 1 && hMMstate.tag.equals(this.excludedTag) || n >= this.excludedTagStart && n <= this.excludedTagEnd && !hMMstate.tag.equals(this.excludedTag) || n == this.excludedTagEnd + 1 && hMMstate.tag.equals(this.excludedTag);
    }

    private void addDeviations(int[] nArray, double d, int n) {
        for (int i = 2; i <= n; ++i) {
            this.addDeviationsAtToken(nArray, d, i);
        }
    }

    private void addDeviationsAtToken(int[] nArray, double d, int n) {
        int n2 = nArray[n];
        int n3 = this.backPointer[n][n2];
        HMMstate hMMstate = (HMMstate)this.states.get(n3);
        for (int i = 0; i < this.states.size(); ++i) {
            HMMstate hMMstate2;
            if (i == n3 || i == this.startState || i == this.endState || (hMMstate2 = (HMMstate)this.states.get(i)).getTransitionProb(n2) == -1.0E100) continue;
            double d2 = d - this.pathProb[n - 1][n3] - hMMstate.getTransitionProb(n2) + hMMstate2.getTransitionProb(n2) + this.pathProb[n - 1][i];
            Deviation deviation = new Deviation(nArray, n, i, d2);
            this.deviationSet.add(deviation);
        }
    }

    public void setNbest() {
        this.Nbest = true;
    }

    public int[] nextBestPath() {
        int n;
        if (this.deviationSet == null || this.deviationSet.isEmpty()) {
            return null;
        }
        Deviation deviation = (Deviation)this.deviationSet.last();
        this.deviationSet.remove(deviation);
        int[] nArray = deviation.basePath;
        int n2 = deviation.token;
        int[] nArray2 = new int[this.nTokens + 2];
        for (n = n2; n < this.nTokens + 2; ++n) {
            nArray2[n] = nArray[n];
        }
        n = deviation.prior;
        for (int i = n2 - 1; i >= 0; --i) {
            nArray2[i] = n;
            if ((n = this.backPointer[i][n]) >= 0) continue;
            return null;
        }
        this.addDeviations(nArray2, deviation.cost, n2 - 1);
        this.pathProbability = deviation.cost;
        return nArray2;
    }

    public String[] nextBest() {
        int[] nArray = this.nextBestPath();
        if (nArray == null) {
            return null;
        }
        String[] stringArray = new String[this.nTokens];
        for (int i = 0; i < this.nTokens; ++i) {
            HMMstate hMMstate = (HMMstate)this.states.get(nArray[i + 1]);
            stringArray[i] = hMMstate.tag;
        }
        return stringArray;
    }

    public static void main(String[] stringArray) {
        HMM hMM = HMM.makeTestHMM();
        Document document = new Document("big big cat nap");
        Annotation[] annotationArray = new Annotation[]{new Annotation("token", new Span(0, 4), null), new Annotation("token", new Span(4, 8), null), new Annotation("token", new Span(8, 12), null), new Annotation("token", new Span(12, 15), null)};
        document.addAnnotation(annotationArray[0]);
        document.addAnnotation(annotationArray[1]);
        document.addAnnotation(annotationArray[2]);
        document.addAnnotation(annotationArray[3]);
        hMM.setNbest();
        int[] nArray = hMM.viterbiPath(document, annotationArray);
        double d = hMM.getPathProbability();
        System.out.println("Best path:   " + HMM.pathString(nArray) + " with probability " + d);
        int[] nArray2 = hMM.nextBestPath();
        d = hMM.getPathProbability();
        System.out.println("Second path: " + HMM.pathString(nArray2) + " with probability " + d);
        int[] nArray3 = hMM.nextBestPath();
        d = hMM.getPathProbability();
        System.out.println("Third path:  " + HMM.pathString(nArray3) + " with probability " + d);
        int[] nArray4 = hMM.nextBestPath();
        d = hMM.getPathProbability();
        System.out.println("Fourth path: " + HMM.pathString(nArray4) + " with probability " + d);
        int[] nArray5 = hMM.nextBestPath();
        d = hMM.getPathProbability();
        System.out.println("Fifth path:  " + HMM.pathString(nArray5) + " with probability " + d);
    }

    private static HMM makeTestHMM() {
        HMM hMM = new HMM(BasicHMMemitter.class);
        HMMstate hMMstate = new HMMstate("start", "", BasicHMMemitter.class);
        HMMstate hMMstate2 = new HMMstate("adj", "JJ", BasicHMMemitter.class);
        HMMstate hMMstate3 = new HMMstate("noun", "NN", BasicHMMemitter.class);
        HMMstate hMMstate4 = new HMMstate("end", "", BasicHMMemitter.class);
        hMM.addState(hMMstate);
        hMM.addState(hMMstate2);
        hMM.addState(hMMstate3);
        hMM.addState(hMMstate4);
        hMM.resetForTraining();
        hMMstate.addArc(new HMMarc("adj", 3));
        hMMstate.addArc(new HMMarc("noun", 1));
        hMMstate2.addArc(new HMMarc("noun", 3));
        hMMstate2.addArc(new HMMarc("adj", 1));
        hMMstate3.addArc(new HMMarc("noun", 1));
        hMMstate3.addArc(new HMMarc("end", 4));
        hMMstate2.incrementEmitCount("safe", "", 1);
        hMMstate2.incrementEmitCount("big", "", 3);
        hMMstate3.incrementEmitCount("cat", "", 2);
        hMMstate3.incrementEmitCount("nap", "", 1);
        hMMstate3.incrementEmitCount("safe", "", 1);
        hMMstate3.incrementEmitCount("cracker", "", 1);
        hMMstate.count = 4;
        hMMstate2.count = 4;
        hMMstate3.count = 5;
        hMM.resolveNames();
        hMM.computeProbabilities();
        return hMM;
    }

    static String pathString(int[] nArray) {
        if (nArray == null) {
            return " null ";
        }
        String string = " [";
        for (int i = 0; i < nArray.length; ++i) {
            string = string + " " + nArray[i];
        }
        string = string + " ] ";
        return string;
    }

    class HMMerror
    extends Exception {
        HMMerror(String string) {
            super(string);
        }
    }

    private class Deviation
    implements Comparable {
        int[] basePath;
        int token;
        int prior;
        double cost;

        public Deviation(int[] nArray, int n, int n2, double d) {
            this.basePath = nArray;
            this.token = n;
            this.prior = n2;
            this.cost = d;
        }

        public int compareTo(Object object) {
            if (object instanceof Deviation) {
                Deviation deviation = (Deviation)object;
                double d = deviation.cost;
                if (this.cost < d) {
                    return -1;
                }
                if (this.cost > d) {
                    return 1;
                }
                return 0;
            }
            throw new ClassCastException();
        }

        public String toString() {
            return "Change prior of token " + this.token + " to " + this.prior + " in" + HMM.pathString(this.basePath);
        }
    }
}

