/*
 * Decompiled with CFR 0.152.
 */
package Jet.Format;

import Jet.Parser.ParseTreeNode;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class PTBWriter {
    private static final Map<String, String> TRANSFORM_TABLE = new HashMap<String, String>();

    public void save(ParseTreeNode parseTreeNode, Writer writer) throws IOException {
        writer.write(40);
        writer.write(this.buildTagName(parseTreeNode));
        writer.write(32);
        if (parseTreeNode.children != null && parseTreeNode.children.length != 0) {
            for (ParseTreeNode parseTreeNode2 : parseTreeNode.children) {
                this.save(parseTreeNode2, writer);
                writer.write(32);
            }
        } else {
            writer.write(this.escape(parseTreeNode.word));
        }
        writer.write(41);
    }

    private String buildTagName(ParseTreeNode parseTreeNode) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(parseTreeNode.category.toString().toUpperCase());
        if (parseTreeNode.head != 0) {
            stringBuilder.append('-');
            stringBuilder.append(parseTreeNode.head);
        }
        return stringBuilder.toString();
    }

    private String escape(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '*' || c == '/') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        String string2 = stringBuilder.toString();
        if (TRANSFORM_TABLE.containsKey(string2)) {
            return TRANSFORM_TABLE.get(string2);
        }
        return string2;
    }

    static {
        TRANSFORM_TABLE.put("(", "-LRB-");
        TRANSFORM_TABLE.put("{", "-LCB-");
        TRANSFORM_TABLE.put("[", "-LSB-");
        TRANSFORM_TABLE.put(")", "-RRB-");
        TRANSFORM_TABLE.put("}", "-RCB-");
        TRANSFORM_TABLE.put("]", "-RSB-");
    }
}

