/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.EDTtype;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.StringTokenizer;

class EDTtypeData {
    static HashMap subtypeTotals = new HashMap();
    String word;
    String type = null;
    String subtype = null;
    int count = 0;
    HashMap typeCount;
    int genericCount = 0;
    int nonGenericCount = 0;

    EDTtypeData(String string) {
        this.word = string;
        this.typeCount = new HashMap();
    }

    static EDTtypeData readLine(String string) {
        int n = string.indexOf(124);
        if (n <= 1) {
            System.err.println("** error in ACE type dict: " + string);
            return null;
        }
        String string2 = string.substring(0, n - 1);
        EDTtypeData eDTtypeData = new EDTtypeData(string2);
        String string3 = string.substring(n + 2);
        StringTokenizer stringTokenizer = new StringTokenizer(string3);
        while (stringTokenizer.hasMoreTokens()) {
            String string4;
            String string5;
            String string6 = stringTokenizer.nextToken();
            String string7 = stringTokenizer.nextToken();
            int n2 = Integer.valueOf(string7);
            int n3 = string6.indexOf(58);
            if (n3 > 0) {
                string5 = string6.substring(0, n3);
                string4 = string6.substring(n3 + 1);
            } else {
                string5 = string6;
                string4 = "*";
            }
            eDTtypeData.incrementTypeCount(string5, string4, n2);
        }
        return eDTtypeData;
    }

    String getBestType() {
        if (this.type == null) {
            this.determineBestType();
        }
        return this.type;
    }

    String getBestSubtype() {
        if (this.type == null) {
            this.determineBestType();
        }
        return this.subtype;
    }

    String getBestTypeSubtype() {
        return EDTtype.typeAndSubtype(this.getBestType(), this.getBestSubtype());
    }

    void write(PrintStream printStream) {
        printStream.print(this.word + " |");
        for (String string : this.typeCount.keySet()) {
            HashMap hashMap = (HashMap)this.typeCount.get(string);
            for (String string2 : hashMap.keySet()) {
                if (string2 == "total") continue;
                Integer n = (Integer)hashMap.get(string2);
                if (string2.equals("*")) {
                    printStream.print(" " + string + " " + n);
                    continue;
                }
                printStream.print(" " + string + ":" + string2 + " " + n);
            }
        }
        printStream.println();
    }

    void incrementTypeCount(String string, String string2, int n) {
        EDTtypeData.incrementCount(this.typeCount, string, string2, n);
        if (!string2.equals("*")) {
            EDTtypeData.incrementCount(this.typeCount, string, "total", n);
            EDTtypeData.incrementCount(subtypeTotals, string, string2, n);
        }
    }

    static void incrementCount(HashMap hashMap, String string, String string2, int n) {
        Integer n2;
        HashMap<String, Integer> hashMap2 = (HashMap<String, Integer>)hashMap.get(string);
        if (hashMap2 == null) {
            hashMap2 = new HashMap<String, Integer>();
            hashMap.put(string, hashMap2);
        }
        int n3 = (n2 = (Integer)hashMap2.get(string2)) == null ? 0 : n2;
        hashMap2.put(string2, new Integer(n3 += n));
    }

    void incrementGenericCount(boolean bl) {
        if (bl) {
            ++this.genericCount;
        } else {
            ++this.nonGenericCount;
        }
    }

    void determineBestType() {
        int n;
        Object object3;
        Object object22;
        if (this.type != null) {
            return;
        }
        int n2 = 0;
        for (Object object22 : this.typeCount.keySet()) {
            object3 = (Integer)((HashMap)this.typeCount.get(object22)).get("total");
            n = object3 == null ? 0 : (Integer)object3;
            if (n <= n2) continue;
            this.type = object22;
            n2 = n;
        }
        if (this.type == null) {
            for (Object object22 : this.typeCount.keySet()) {
                object3 = (Integer)((HashMap)this.typeCount.get(object22)).get("*");
                n = object3 == null ? 0 : (Integer)object3;
                if (n <= n2) continue;
                this.type = object22;
                n2 = n;
            }
            if (this.type == null) {
                System.err.println("EDTtypeData.determineBestType failed for " + this.word);
            } else {
                this.subtype = EDTtypeData.bestSubtype(this.type);
            }
            return;
        }
        n2 = -1;
        object22 = (HashMap)this.typeCount.get(this.type);
        for (Object object3 : ((HashMap)object22).keySet()) {
            Integer n3;
            int n4;
            if (object3 == "total" || ((String)object3).equals("*") || (n4 = (n3 = (Integer)((HashMap)object22).get(object3)) == null ? 0 : n3) <= n2) continue;
            this.subtype = object3;
            n2 = n4;
        }
    }

    static void reportSubtypeTotals() {
        for (String string : subtypeTotals.keySet()) {
            System.out.println("For type: " + string);
            HashMap hashMap = (HashMap)subtypeTotals.get(string);
            for (String string2 : hashMap.keySet()) {
                Integer n = (Integer)hashMap.get(string2);
                System.out.print(string2 + " " + n + " ");
            }
            System.out.println();
        }
    }

    static String bestSubtype(String string) {
        HashMap hashMap = (HashMap)subtypeTotals.get(string);
        String string2 = null;
        int n = 0;
        for (String string3 : hashMap.keySet()) {
            Integer n2 = (Integer)hashMap.get(string3);
            int n3 = n2;
            if (n3 <= n) continue;
            string2 = string3;
            n = n3;
        }
        if (string2 != null) {
            return string2;
        }
        if (string.equals("OTHER")) {
            return "";
        }
        System.err.println("*** Cannot determine best subtype for type " + string);
        return "Other";
    }
}

