/*
 * Decompiled with CFR 0.152.
 */
package opennlp.perceptron;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPOutputStream;
import opennlp.model.AbstractModel;
import opennlp.perceptron.PerceptronModelWriter;

public class PlainTextPerceptronModelWriter
extends PerceptronModelWriter {
    BufferedWriter output;

    public PlainTextPerceptronModelWriter(AbstractModel abstractModel, File file) throws IOException, FileNotFoundException {
        super(abstractModel);
        this.output = file.getName().endsWith(".gz") ? new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(file)))) : new BufferedWriter(new FileWriter(file));
    }

    public PlainTextPerceptronModelWriter(AbstractModel abstractModel, BufferedWriter bufferedWriter) {
        super(abstractModel);
        this.output = bufferedWriter;
    }

    public void writeUTF(String string) throws IOException {
        this.output.write(string);
        this.output.newLine();
    }

    public void writeInt(int n) throws IOException {
        this.output.write(Integer.toString(n));
        this.output.newLine();
    }

    public void writeDouble(double d) throws IOException {
        this.output.write(Double.toString(d));
        this.output.newLine();
    }

    public void close() throws IOException {
        this.output.flush();
        this.output.close();
    }
}

