/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.princeton.file;

import java.util.HashMap;
import java.util.Map;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.dictionary.file.AbstractDictionaryFile;
import net.didion.jwnl.dictionary.file.DictionaryFileType;

public abstract class AbstractPrincetonDictionaryFile
extends AbstractDictionaryFile {
    private static final String NOUN_EXT = "noun";
    private static final String VERB_EXT = "verb";
    private static final String ADJECTIVE_EXT = "adj";
    private static final String ADVERB_EXT = "adv";
    private static final Map _posToExtMap = new HashMap(4, 1.0f);
    private static final Map _fileTypeToFileNameMap;

    public AbstractPrincetonDictionaryFile() {
    }

    public AbstractPrincetonDictionaryFile(String string, POS pOS, DictionaryFileType dictionaryFileType) {
        super(string, pOS, dictionaryFileType);
    }

    protected String makeFilename() {
        String string = this.getExtension(this.getPOS());
        if (this.getFileType() == DictionaryFileType.EXCEPTION || JWNL.getOS() == JWNL.WINDOWS) {
            return this.makeWindowsFilename(string, this.getFileNames((DictionaryFileType)this.getFileType())._windowsFileTypeName);
        }
        return this.makeNonWindowsFilename(string, this.getFileNames((DictionaryFileType)this.getFileType())._nonWindowsFileTypeName);
    }

    private String makeWindowsFilename(String string, String string2) {
        return string + "." + string2;
    }

    private String makeNonWindowsFilename(String string, String string2) {
        return string2 + "." + string;
    }

    private String getExtension(POS pOS) {
        return (String)_posToExtMap.get(pOS);
    }

    private FileNames getFileNames(DictionaryFileType dictionaryFileType) {
        return (FileNames)_fileTypeToFileNameMap.get(dictionaryFileType);
    }

    static {
        _posToExtMap.put(POS.NOUN, NOUN_EXT);
        _posToExtMap.put(POS.VERB, VERB_EXT);
        _posToExtMap.put(POS.ADJECTIVE, ADJECTIVE_EXT);
        _posToExtMap.put(POS.ADVERB, ADVERB_EXT);
        _fileTypeToFileNameMap = new HashMap(3, 1.0f);
        _fileTypeToFileNameMap.put(DictionaryFileType.INDEX, new FileNames("idx", "index"));
        _fileTypeToFileNameMap.put(DictionaryFileType.DATA, new FileNames("dat", "data"));
        _fileTypeToFileNameMap.put(DictionaryFileType.EXCEPTION, new FileNames("exc", "exc"));
    }

    private static final class FileNames {
        String _windowsFileTypeName;
        String _nonWindowsFileTypeName;

        public FileNames(String string, String string2) {
            this._windowsFileTypeName = string;
            this._nonWindowsFileTypeName = string2;
        }
    }
}

