/*
 * Decompiled with CFR 0.152.
 */
package tratz.pos;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import tratz.cmdline.CommandLineOptions;
import tratz.cmdline.CommandLineOptionsParser;
import tratz.cmdline.ParsedCommandLine;
import tratz.jwni.WordNet;
import tratz.ml.ClassScoreTuple;
import tratz.ml.LinearClassificationModel;
import tratz.parse.io.SentenceReader;
import tratz.parse.io.SentenceWriter;
import tratz.parse.types.Parse;
import tratz.parse.types.Sentence;
import tratz.parse.types.Token;
import tratz.pos.featgen.PosFeatureGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformPosTagging {
    public static final String OPT_MODEL_FILE = "model";
    public static final String OPT_INPUT_FILE = "input";
    public static final String OPT_SENTENCE_READER = "sreader";
    public static final String OPT_SENTENCE_WRITER = "swriter";
    public static final String OPT_SENTENCE_WRITER_OPTIONS = "writeropts";
    public static final String OPT_WORDNET_DIR = "wndir";
    public static final String OPT_CONFUSION_FILE = "confusion";

    public static CommandLineOptions createOptions() {
        CommandLineOptions opts = new CommandLineOptions();
        opts.addOption(OPT_MODEL_FILE, "file", "file containing the POS-tagging model");
        opts.addOption(OPT_INPUT_FILE, "file", "the input file");
        opts.addOption(OPT_SENTENCE_READER, "classname", "name of the class for reading in the sentences (should implement " + SentenceReader.class.getName() + ")");
        opts.addOption(OPT_SENTENCE_WRITER, "classname", "name of the class for writing out the tagged sentences (should implement " + SentenceWriter.class.getName() + ")");
        opts.addOption(OPT_SENTENCE_WRITER_OPTIONS, "string", "the map of key-value pairs for the sentence writer (separated by semicolons if multiple) (e.g., output=xyz.txt)");
        opts.addOption(OPT_WORDNET_DIR, "file", "the dictionary (dict) directory of WordNet");
        opts.addOption(OPT_CONFUSION_FILE, "file", "name of the file to write the confusion matrix to (optional)");
        return opts;
    }

    public static void main(String[] args) throws Exception {
        ParsedCommandLine cmdLine = new CommandLineOptionsParser().parseOptions(PerformPosTagging.createOptions(), args);
        String modelFile = cmdLine.getStringValue(OPT_MODEL_FILE);
        String inputFile = cmdLine.getStringValue(OPT_INPUT_FILE);
        String sentenceReaderClass = cmdLine.getStringValue(OPT_SENTENCE_READER);
        String wnDir = cmdLine.getStringValue(OPT_WORDNET_DIR);
        String confusionFile = cmdLine.getStringValue(OPT_CONFUSION_FILE);
        String sentenceWriterClass = cmdLine.getStringValue(OPT_SENTENCE_WRITER);
        String sentenceWriterParams = cmdLine.getStringValue(OPT_SENTENCE_WRITER_OPTIONS);
        WordNet wn = new WordNet(new File(wnDir));
        SentenceWriter sentenceWriter = (SentenceWriter)Class.forName(sentenceWriterClass).newInstance();
        HashMap<String, String> params = new HashMap<String, String>();
        if (sentenceWriterParams != null) {
            String[] keyValuePairs;
            for (String keyValuePair : keyValuePairs = sentenceWriterParams.split(";")) {
                String[] pair = keyValuePair.split("=");
                params.put(pair[0], pair[1]);
            }
        }
        sentenceWriter.initialize(params);
        SentenceReader sentenceReader = (SentenceReader)Class.forName(sentenceReaderClass).newInstance();
        System.err.print("Reading POS-tagging model " + new File(modelFile).getAbsolutePath() + " ...");
        long startTime = System.nanoTime();
        ObjectInputStream ois = new ObjectInputStream(new GZIPInputStream(new FileInputStream(modelFile)));
        LinearClassificationModel decisionModule = (LinearClassificationModel)ois.readObject();
        PosFeatureGenerator featureGenerator = (PosFeatureGenerator)ois.readObject();
        ois.close();
        System.err.println("Done (Took: " + (double)(System.nanoTime() - startTime) / Math.pow(10.0, 6.0) + " seconds");
        startTime = System.nanoTime();
        System.err.println("Input file: " + new File(inputFile).getAbsolutePath());
        BufferedReader reader = new BufferedReader(new FileReader(new File(inputFile)));
        int numCorrect = 0;
        int numWrong = 0;
        System.err.println("Begin POS-tagging...");
        HashMap<String, Map<String, IntCounter>> confusion = new HashMap<String, Map<String, IntCounter>>();
        int totalSentences = 0;
        Parse parse = null;
        int sno = 0;
        while ((parse = sentenceReader.readSentence(reader)) != null) {
            Sentence sentence = parse.getSentence();
            List<Token> tokens = sentence.getTokens();
            String[] originalPos = null;
            if (confusionFile != null) {
                originalPos = new String[tokens.size() + 1];
                for (Token t : tokens) {
                    originalPos[t.getIndex()] = t.getPos();
                }
            }
            int numTokens = tokens.size();
            for (int j = 0; j < numTokens; ++j) {
                IntCounter count;
                Set<String> feats = featureGenerator.getFeats(tokens, j);
                ClassScoreTuple[] classRankings = decisionModule.getDecision(feats);
                Token t = tokens.get(j);
                String predictedPos = classRankings[0].clazz;
                t.setPos(predictedPos);
                if (confusionFile == null) continue;
                HashMap<String, IntCounter> row = (HashMap<String, IntCounter>)confusion.get(originalPos[t.getIndex()]);
                if (row == null) {
                    row = new HashMap<String, IntCounter>();
                    confusion.put(originalPos[t.getIndex()], row);
                }
                if ((count = (IntCounter)row.get(predictedPos)) == null) {
                    count = new IntCounter(0);
                    row.put(predictedPos, count);
                }
                ++count.val;
                if (predictedPos.equals(originalPos[t.getIndex()])) {
                    ++numCorrect;
                    continue;
                }
                ++numWrong;
            }
            sentenceWriter.appendSentence(sentence, parse);
            if (sno % 100 == 0) {
                System.err.println(sno);
            }
            ++totalSentences;
            ++sno;
        }
        if (confusionFile != null) {
            File confusionMatrixFile = new File(confusionFile);
            System.err.println("Writing confusion matrix to: " + confusionMatrixFile.getAbsolutePath());
            PerformPosTagging.writeConfusionMatrix(confusionMatrixFile, confusion);
        }
        System.err.println("Time: " + (double)(System.nanoTime() - startTime) / Math.pow(10.0, 9.0));
        System.err.println("Number correct: " + numCorrect);
        System.err.println("NUmber wrong: " + numWrong);
        System.err.println("Accuracy: " + (double)numCorrect / ((double)numCorrect + (double)numWrong));
        System.err.println("Tokens/second: " + (double)(numCorrect + numWrong) / ((double)(System.nanoTime() - startTime) / Math.pow(10.0, 9.0)));
        reader.close();
        sentenceWriter.close();
    }

    private static void writeConfusionMatrix(File outputFile, Map<String, Map<String, IntCounter>> confusionMatrix) throws IOException {
        ArrayList<String> keys = new ArrayList<String>(confusionMatrix.keySet());
        int numKeys = keys.size();
        Collections.sort(keys);
        PrintWriter conf = new PrintWriter(outputFile);
        for (String key : keys) {
            conf.print("\t");
            conf.print(key);
        }
        conf.println();
        for (int i = 0; i < numKeys; ++i) {
            conf.print((String)keys.get(i));
            Map<String, IntCounter> counts = confusionMatrix.get(keys.get(i));
            for (int j = 0; j < numKeys; ++j) {
                if (counts == null) {
                    conf.print("\t0");
                    continue;
                }
                IntCounter count = counts.get(keys.get(j));
                conf.print("\t");
                conf.print(count == null ? "0" : Integer.valueOf(count.val));
            }
            conf.println("\t" + (String)keys.get(i));
        }
        for (String key : keys) {
            conf.print("\t");
            conf.print(key);
        }
        conf.println();
        conf.close();
    }

    private static class IntCounter {
        int val;

        public IntCounter(int x) {
            this.val = x;
        }
    }
}

