/*
 * Decompiled with CFR 0.152.
 */
package tratz.types;

import java.io.Serializable;

public class FloatArrayList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private float[] mData;
    private int mLength;

    public FloatArrayList() {
        this(10);
    }

    public FloatArrayList(int size) {
        this.mData = new float[size];
    }

    public void add(float b) {
        this.expandIfNecessary(this.mData, this.mLength);
        this.mData[this.mLength++] = b;
    }

    private void expandIfNecessary(float[] data, int neededLength) {
        if (data.length == neededLength) {
            int newSize = data.length * 3 / 2 + 1;
            float[] newData = new float[newSize];
            System.arraycopy(data, 0, newData, 0, data.length);
            this.mData = newData;
        }
    }

    public float[] getData() {
        return this.mData;
    }

    public float[] toCompactArray() {
        float[] result = new float[this.mLength];
        System.arraycopy(this.mData, 0, result, 0, this.mLength);
        return result;
    }

    public float get(int i) {
        return this.mData[i];
    }

    public void set(int i, float b) {
        this.mData[i] = b;
    }

    public int size() {
        return this.mLength;
    }
}

