/*
 * Decompiled with CFR 0.152.
 */
package Jet.Time;

import Jet.Lisp.FeatureSet;
import Jet.Time.TimeRule;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import pnuts.lang.Context;
import pnuts.lang.Package;
import pnuts.lang.ParseException;
import pnuts.lang.Pnuts;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptRule
extends TimeRule {
    private Pnuts pnuts;

    @Override
    public void setParameters(Map map) {
        super.setParameters(map);
        try {
            String string = (String)map.get("script");
            this.pnuts = Pnuts.parse(string);
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException);
        }
    }

    @Override
    public void apply(Document document, List<Object> list, Span span, DateTime dateTime) {
        Map map = this.getParameters();
        Map map2 = this.getTimeAnnotator().getConfig();
        String string = (String)map.get("format");
        DateTimeFormatter dateTimeFormatter = null;
        if (string != null) {
            dateTimeFormatter = DateTimeFormat.forPattern(string);
        }
        Package package_ = new Package();
        package_.set("ref", dateTime);
        package_.set("formatter", dateTimeFormatter);
        package_.set("values", list);
        package_.set("config", map2);
        package_.set("doc", document);
        package_.set("span", span);
        package_.set("annotate", new PnutsAnnotateFunction(document));
        package_.set("removeAnnotation", new PnutsRemoveAnnotationFunction(document));
        Context context = new Context(package_);
        Object object = null;
        try {
            object = this.pnuts.run(context);
        }
        catch (PnutsException pnutsException) {
            if (pnutsException.getThrowable() instanceof RuntimeException) {
                throw (RuntimeException)pnutsException.getThrowable();
            }
            throw pnutsException;
        }
        if (object instanceof DateTime) {
            String string2 = dateTimeFormatter.print((DateTime)object);
            FeatureSet featureSet = new FeatureSet();
            featureSet.put("VAL", string2);
            document.annotate("TIMEX2", span, featureSet);
        } else if (object instanceof FeatureSet) {
            FeatureSet featureSet = (FeatureSet)object;
            document.annotate("TIMEX2", span, featureSet);
        } else if (object != null) {
            throw new RuntimeException();
        }
    }

    private static class PnutsRemoveAnnotationFunction
    extends PnutsFunction {
        private Document doc;

        public PnutsRemoveAnnotationFunction(Document document) {
            this.doc = document;
        }

        public boolean defined(int n) {
            return n == 1;
        }

        public Object exec(Object[] objectArray, Context context) {
            if (!this.defined(objectArray.length)) {
                this.undefined(objectArray, context);
                return null;
            }
            Annotation annotation = (Annotation)objectArray[0];
            this.doc.removeAnnotation(annotation);
            return null;
        }
    }

    private static class PnutsAnnotateFunction
    extends PnutsFunction {
        private Document doc;

        public PnutsAnnotateFunction(Document document) {
            this.doc = document;
        }

        public boolean defined(int n) {
            return n == 2;
        }

        public Object exec(Object[] objectArray, Context context) {
            FeatureSet featureSet;
            if (!this.defined(objectArray.length)) {
                this.undefined(objectArray, context);
                return null;
            }
            Span span = (Span)objectArray[0];
            if (objectArray[1] instanceof FeatureSet) {
                featureSet = (FeatureSet)objectArray[1];
            } else if (objectArray[1] instanceof Map) {
                Map map = (Map)objectArray[1];
                featureSet = new FeatureSet();
                for (Map.Entry entry : map.entrySet()) {
                    featureSet.put((String)entry.getKey(), entry.getValue());
                }
            } else {
                this.undefined(objectArray, context);
                return null;
            }
            this.doc.annotate("TIMEX2", span, featureSet);
            return null;
        }
    }
}

