/*
 * Decompiled with CFR 0.152.
 */
package Jet.NE;

import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import gnu.trove.TObjectIntHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Evaluator {
    private static final String TOTAL = "\u0000";
    private TObjectIntHashMap correct = new TObjectIntHashMap();
    private TObjectIntHashMap miss = new TObjectIntHashMap();
    private TObjectIntHashMap gold = new TObjectIntHashMap();
    private TObjectIntHashMap system = new TObjectIntHashMap();

    public void evaluate(Document document, Document document2) {
        String string;
        Span span;
        String string2;
        Map<Span, String> map = this.makeSpanToEntityTypeMap(document2);
        Map<Span, String> map2 = this.makeSpanToEntityTypeMap(document);
        for (Map.Entry<Span, String> entry : map.entrySet()) {
            string2 = entry.getValue();
            span = entry.getKey();
            string = map2.get(span);
            if (string == null || !string.equals(string2)) {
                Evaluator.increment(this.miss, string2);
            }
            Evaluator.increment(this.gold, string2);
        }
        for (Map.Entry<Span, String> entry : map2.entrySet()) {
            string2 = entry.getValue();
            span = entry.getKey();
            string = map.get(span);
            if (string != null && string.equals(string2)) {
                Evaluator.increment(this.correct, string2);
            }
            Evaluator.increment(this.system, string2);
        }
    }

    public Collection<String> getTypes() {
        String[] stringArray = new String[this.gold.size() - 1];
        int n = 0;
        for (Object object : this.gold.keys()) {
            if (object.equals(TOTAL)) continue;
            stringArray[n++] = (String)object;
        }
        return Arrays.asList(stringArray);
    }

    public double getPrecision(String string) {
        return (double)this.correct.get(string) / (double)this.system.get(string);
    }

    public double getPrecision() {
        return this.getPrecision(TOTAL);
    }

    public double getRecall(String string) {
        return (double)(this.gold.get(string) - this.miss.get(string)) / (double)this.gold.get(string);
    }

    public double getRecall() {
        return this.getRecall(TOTAL);
    }

    private Map<Span, String> makeSpanToEntityTypeMap(Document document) {
        HashMap<Span, String> hashMap = new HashMap<Span, String>();
        Vector<Annotation> vector = document.annotationsOfType("ENAMEX");
        for (Annotation annotation : vector) {
            hashMap.put(annotation.span(), (String)annotation.get("TYPE"));
        }
        return hashMap;
    }

    private static void increment(TObjectIntHashMap tObjectIntHashMap, Object object) {
        if (tObjectIntHashMap.containsKey(object)) {
            tObjectIntHashMap.increment(object);
        } else {
            tObjectIntHashMap.put(object, 1);
        }
        if (tObjectIntHashMap.containsKey(TOTAL)) {
            tObjectIntHashMap.increment(TOTAL);
        } else {
            tObjectIntHashMap.put(TOTAL, 1);
        }
    }
}

