/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.util.logging;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.didion.jwnl.util.logging.JDKLogListener;
import net.didion.jwnl.util.logging.Level;
import net.didion.jwnl.util.logging.LogListener;
import net.didion.jwnl.util.logging.LogPublishingService;
import net.didion.jwnl.util.logging.LogRecord;

public class JDKServiceAdapter
implements LogListener {
    private static final List _logListeners = new ArrayList();
    private static final JDKServiceAdapter INSTANCE = new JDKServiceAdapter();

    public static JDKServiceAdapter getInstance() {
        return INSTANCE;
    }

    private JDKServiceAdapter() {
        LogPublishingService.getInstance().addLogListener(this);
    }

    public void addJDKLogListener(JDKLogListener jDKLogListener) {
        _logListeners.add(jDKLogListener);
    }

    public void removeJDKLogListener(JDKLogListener jDKLogListener) {
        _logListeners.remove(jDKLogListener);
    }

    public void publish(LogRecord logRecord) {
        java.util.logging.LogRecord logRecord2 = this.toJDKLogRecord(logRecord);
        Iterator iterator = _logListeners.iterator();
        while (iterator.hasNext()) {
            ((JDKLogListener)iterator.next()).publish(logRecord2);
        }
    }

    private java.util.logging.LogRecord toJDKLogRecord(LogRecord logRecord) {
        java.util.logging.LogRecord logRecord2 = new java.util.logging.LogRecord(this.toJDKLevel(logRecord.getLevel()), logRecord.getMessage());
        logRecord2.setThrown(logRecord.getThrown());
        return logRecord2;
    }

    private java.util.logging.Level toJDKLevel(Level level) {
        return java.util.logging.Level.parse(String.valueOf(level.intValue()));
    }
}

