/*
 * Decompiled with CFR 0.152.
 */
package org.ho.yaml.wrapper;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.ho.yaml.ReflectionUtil;
import org.ho.yaml.exception.PropertyAccessException;
import org.ho.yaml.wrapper.AbstractWrapper;
import org.ho.yaml.wrapper.MapWrapper;

public class DefaultBeanWrapper
extends AbstractWrapper
implements MapWrapper {
    public DefaultBeanWrapper(Class clazz) {
        super(clazz);
    }

    public boolean hasProperty(String string) {
        PropertyDescriptor propertyDescriptor = ReflectionUtil.getPropertyDescriptor(this.type, string);
        return this.config.isPropertyAccessibleForEncoding(propertyDescriptor);
    }

    public Object getProperty(String string) throws PropertyAccessException {
        Object object;
        Object object2 = this.getObject();
        try {
            object = ReflectionUtil.getPropertyDescriptor(this.type, string);
            if (this.config.isPropertyAccessibleForEncoding((PropertyDescriptor)object)) {
                Method method = ((PropertyDescriptor)object).getReadMethod();
                method.setAccessible(true);
                return method.invoke(object2, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object = this.type.getDeclaredField(string);
            if (this.config.isFieldAccessibleForEncoding((Field)object)) {
                ((Field)object).setAccessible(true);
                return ((Field)object).get(object2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new PropertyAccessException("Can't get " + string + " property on type " + this.type + ".");
    }

    public void setProperty(String string, Object object) throws PropertyAccessException {
        Object object2;
        try {
            object2 = ReflectionUtil.getPropertyDescriptor(this.type, string);
            if (this.config.isPropertyAccessibleForEncoding((PropertyDescriptor)object2)) {
                Method method = ((PropertyDescriptor)object2).getWriteMethod();
                method.setAccessible(true);
                method.invoke(this.getObject(), object);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object2 = this.type.getDeclaredField(string);
            if (this.config.isFieldAccessibleForDecoding((Field)object2)) {
                ((Field)object2).setAccessible(true);
                ((Field)object2).set(this.getObject(), object);
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public Class getPropertyType(String string) {
        if (ReflectionUtil.hasProperty(this.type, string)) {
            return ReflectionUtil.getPropertyDescriptor(this.type, string).getPropertyType();
        }
        try {
            Field field = this.type.getDeclaredField(string);
            if (ReflectionUtil.isMemberField(field)) {
                field.setAccessible(true);
                return field.getType();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public boolean containsKey(Object object) {
        return this.hasProperty((String)object);
    }

    public Object get(Object object) {
        return this.getProperty((String)object);
    }

    public Class getExpectedType(Object object) {
        return this.getPropertyType((String)object);
    }

    public Set keys() {
        HashSet<String> hashSet = new HashSet<String>();
        for (PropertyDescriptor propertyDescriptor : ReflectionUtil.getProperties(this.getType())) {
            if (!this.config.isPropertyAccessibleForEncoding(propertyDescriptor)) continue;
            hashSet.add(propertyDescriptor.getName());
        }
        for (Field field : this.getType().getDeclaredFields()) {
            if (!this.config.isFieldAccessibleForEncoding(field)) continue;
            field.setAccessible(true);
            hashSet.add(field.getName());
        }
        return hashSet;
    }

    public void put(Object object, Object object2) {
        this.setProperty((String)object, object2);
    }
}

