/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.mallet.base.types;

import edu.umass.cs.mallet.base.types.Alphabet;
import edu.umass.cs.mallet.base.types.AugmentableFeatureVector;
import edu.umass.cs.mallet.base.types.FeatureVector;
import edu.umass.cs.mallet.base.types.Matrix2;
import edu.umass.cs.mallet.base.types.Sequence;
import edu.umass.cs.mallet.base.types.TokenSequence;
import edu.umass.cs.mallet.base.types.Vector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class FeatureVectorSequence
implements Sequence,
Serializable {
    FeatureVector[] sequence;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;
    private static final int NULL_INTEGER = -1;

    public FeatureVectorSequence(FeatureVector[] featureVectors) {
        this.sequence = featureVectors;
    }

    public FeatureVectorSequence(Alphabet dict, TokenSequence tokens, boolean binary, boolean augmentable, boolean growAlphabet) {
        this.sequence = new FeatureVector[tokens.size()];
        if (augmentable) {
            int i = 0;
            while (i < tokens.size()) {
                this.sequence[i] = new AugmentableFeatureVector(dict, tokens.getToken(i).getFeatures(), binary, growAlphabet);
                ++i;
            }
        } else {
            int i = 0;
            while (i < tokens.size()) {
                this.sequence[i] = new FeatureVector(dict, tokens.getToken(i).getFeatures(), binary, growAlphabet);
                ++i;
            }
        }
    }

    public FeatureVectorSequence(Alphabet dict, TokenSequence tokens, boolean binary, boolean augmentable) {
        this(dict, tokens, binary, augmentable, true);
    }

    public FeatureVectorSequence(Alphabet dict, TokenSequence tokens) {
        this(dict, tokens, false, false);
    }

    public int size() {
        return this.sequence.length;
    }

    public Object get(int i) {
        return this.sequence[i];
    }

    public FeatureVector getFeatureVector(int i) {
        return this.sequence[i];
    }

    public double dotProduct(int sequencePosition, Matrix2 weights, int weightRowIndex) {
        return weights.rowDotProduct(weightRowIndex, this.sequence[sequencePosition]);
    }

    public double dotProduct(int sequencePosition, Vector weights) {
        return weights.dotProduct(this.sequence[sequencePosition]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append('\n');
        int i = 0;
        while (i < this.sequence.length) {
            sb.append(String.valueOf(Integer.toString(i)) + ": ");
            sb.append(this.sequence[i].toString(true));
            sb.append('\n');
            ++i;
        }
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        if (this.sequence == null) {
            out.writeInt(-1);
        } else {
            int size = this.sequence.length;
            out.writeInt(size);
            int i = 0;
            while (i < size) {
                out.writeObject(this.sequence[i]);
                ++i;
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        int size = in.readInt();
        if (size == -1) {
            this.sequence = null;
        } else {
            this.sequence = new FeatureVector[size];
            int i = 0;
            while (i < size) {
                this.sequence[i] = (FeatureVector)in.readObject();
                ++i;
            }
        }
    }
}

