/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.mallet.base.classify;

import edu.umass.cs.mallet.base.classify.Classification;
import edu.umass.cs.mallet.base.pipe.Pipe;
import edu.umass.cs.mallet.base.types.Alphabet;
import edu.umass.cs.mallet.base.types.Instance;
import edu.umass.cs.mallet.base.types.InstanceList;
import edu.umass.cs.mallet.base.types.LabelAlphabet;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.logging.Logger;

public abstract class Classifier {
    private static Logger logger = Logger.getLogger("edu.umass.cs.mallet.base.classify.Classifier");
    protected Pipe instancePipe;

    protected Classifier() {
    }

    public Classifier(Pipe instancePipe) {
        this.instancePipe = instancePipe;
        assert (instancePipe.getTargetAlphabet() != null);
        assert (instancePipe.getTargetAlphabet().getClass().isAssignableFrom(LabelAlphabet.class));
    }

    public Pipe getInstancePipe() {
        return this.instancePipe;
    }

    public Alphabet getAlphabet() {
        return this.instancePipe.getDataAlphabet();
    }

    public LabelAlphabet getLabelAlphabet() {
        return (LabelAlphabet)this.instancePipe.getTargetAlphabet();
    }

    public ArrayList classify(InstanceList instances) {
        ArrayList<Classification> ret = new ArrayList<Classification>(instances.size());
        InstanceList.Iterator iter = instances.iterator();
        while (iter.hasNext()) {
            ret.add(this.classify(iter.nextInstance()));
        }
        return ret;
    }

    public Classification[] classify(Instance[] instances) {
        Classification[] ret = new Classification[instances.length];
        int i = 0;
        while (i < instances.length) {
            ret[i] = this.classify(instances[i]);
            ++i;
        }
        return ret;
    }

    public abstract Classification classify(Instance var1);

    public Classification classify(Object obj) {
        if (obj instanceof Instance) {
            return this.classify((Instance)obj);
        }
        return this.classify(new Instance(obj, null, null, null, this.instancePipe));
    }

    public double getAccuracy(InstanceList ilist) {
        return this.getAccuracy(this.classify(ilist));
    }

    public double getAccuracy(ArrayList classifications) {
        int numCorrect = 0;
        int i = 0;
        while (i < classifications.size()) {
            if (((Classification)classifications.get(i)).bestLabelIsCorrect()) {
                ++numCorrect;
            }
            ++i;
        }
        return (double)numCorrect / (double)classifications.size();
    }

    public double getPrecision(InstanceList ilist, Object entry) {
        return this.getPrecision(this.classify(ilist), this.getLabelAlphabet().lookupIndex(entry, false));
    }

    public double getPrecision(ArrayList classification, Object entry) {
        return this.getPrecision(classification, this.getLabelAlphabet().lookupIndex(entry, false));
    }

    public double getPrecision(InstanceList ilist, int index) {
        return this.getPrecision(this.classify(ilist), index);
    }

    public double getPrecision(ArrayList classification, int index) {
        int numCorrect = 0;
        int numInstances = 0;
        int i = 0;
        while (i < classification.size()) {
            int trueLabel = ((Classification)classification.get(i)).getInstance().getLabeling().getBestIndex();
            int classLabel = ((Classification)classification.get(i)).getLabeling().getBestIndex();
            if (classLabel == index) {
                ++numInstances;
                if (trueLabel == index) {
                    ++numCorrect;
                }
            }
            ++i;
        }
        if (numInstances == 0) {
            logger.warning("No class instances: dividing by 0");
        }
        return (double)numCorrect / (double)numInstances;
    }

    public double getRecall(InstanceList ilist, Object entry) {
        return this.getRecall(this.classify(ilist), this.getLabelAlphabet().lookupIndex(entry, false));
    }

    public double getRecall(InstanceList ilist, int index) {
        return this.getRecall(this.classify(ilist), index);
    }

    public double getRecall(ArrayList classification, Object entry) {
        return this.getRecall(classification, this.getLabelAlphabet().lookupIndex(entry, false));
    }

    public double getRecall(ArrayList classification, int index) {
        int numCorrect = 0;
        int numInstances = 0;
        int i = 0;
        while (i < classification.size()) {
            int trueLabel = ((Classification)classification.get(i)).getInstance().getLabeling().getBestIndex();
            int classLabel = ((Classification)classification.get(i)).getLabeling().getBestIndex();
            if (trueLabel == index) {
                ++numInstances;
                if (classLabel == index) {
                    ++numCorrect;
                }
            }
            ++i;
        }
        if (numInstances == 0) {
            logger.warning("No class instances: dividing by 0");
        }
        return (double)numCorrect / (double)numInstances;
    }

    public double getF1(InstanceList ilist, Object entry) {
        return this.getF1(this.classify(ilist), this.getLabelAlphabet().lookupIndex(entry, false));
    }

    public double getF1(InstanceList ilist, int index) {
        return this.getF1(this.classify(ilist), index);
    }

    public double getF1(ArrayList classification, Object entry) {
        return this.getF1(classification, this.getLabelAlphabet().lookupIndex(entry, false));
    }

    public double getF1(ArrayList classification, int index) {
        double precision = this.getPrecision(classification, index);
        double recall = this.getRecall(classification, index);
        if (precision == 0.0 && recall == 0.0) {
            logger.warning("Precision and recall are 0: dividing by 0");
        }
        return 2.0 * precision * recall / (precision + recall);
    }

    public void print() {
        System.out.println("Classifier " + this.getClass().getName() + "\n  Detailed printout not yet implemented.");
    }

    public void print(PrintWriter out) {
        out.println("Classifier " + this.getClass().getName() + "\n  Detailed printout not yet implemented.");
    }
}

