/*
 * Decompiled with CFR 0.152.
 */
package pnuts.tools;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import pnuts.ext.NonPublicMemberAccessor;
import pnuts.ext.PublicMemberAccessor;
import pnuts.lang.Context;
import pnuts.lang.Pnuts;
import pnuts.lang.Runtime;
import pnuts.security.SecurePnutsImpl;
import pnuts.tools.ContextFactory;
import pnuts.tools.LogReader;
import pnuts.tools.PnutsConsole;
import pnuts.tools.PnutsConsoleUI;
import pnuts.tools.TerminalDebugger;
import pnuts.tools.TerminalInputStream;
import pnuts.tools.VisualDebugger;

public class Main {
    private static final String pnutsDebuggerProperty = "pnuts.debugger";
    static String java_vendor = System.getProperty("java.vendor");
    static String java_version = System.getProperty("java.version");
    static /* synthetic */ Class class$pnuts$lang$Pnuts;
    static /* synthetic */ Class class$pnuts$tools$Main;

    static String version() {
        try {
            Class.forName("java.lang.Package");
            Package pkg = (class$pnuts$lang$Pnuts == null ? (class$pnuts$lang$Pnuts = Main.class$("pnuts.lang.Pnuts")) : class$pnuts$lang$Pnuts).getPackage();
            return pkg.getSpecificationVersion() + " (" + pkg.getImplementationVersion() + ")";
        }
        catch (ClassNotFoundException e) {
            return "1.1";
        }
    }

    static void greeting(Context context) {
        PrintWriter w = context.getTerminalWriter();
        if (java_vendor == null) {
            java_vendor = System.getProperty("java.vendor");
        }
        w.print("Pnuts version " + Main.version() + ", " + java_version + " (" + java_vendor + ")");
        String vm_name = System.getProperty("java.vm.name");
        String vm_info = System.getProperty("java.vm.info");
        if (vm_name != null) {
            w.print("\n" + vm_name);
            if (vm_info != null) {
                w.println(" (" + vm_info + ")");
            } else {
                w.println();
            }
        } else {
            w.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void printHelp(String command) {
        try {
            InputStream in = (class$pnuts$tools$Main == null ? (class$pnuts$tools$Main = Main.class$("pnuts.tools.Main")) : class$pnuts$tools$Main).getResourceAsStream(command + ".help");
            InputStreamReader reader = new InputStreamReader(in, "UTF-8");
            try {
                int n;
                PrintWriter writer = new PrintWriter(System.err);
                char[] buf = new char[512];
                while ((n = ((Reader)reader).read(buf, 0, 512)) != -1) {
                    writer.write(buf, 0, n);
                }
                writer.flush();
            }
            finally {
                ((Reader)reader).close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Throwable {
        String module_property;
        Object param = null;
        Context context = null;
        Properties defaultSettings = new Properties();
        boolean evaluated = false;
        boolean interactive = false;
        boolean quiet = false;
        String inputlog = null;
        ContextFactory contextFactory = null;
        String iparam = Runtime.getProperty("pnuts.interactive");
        if (iparam != null) {
            if ("false".equals(iparam)) {
                quiet = true;
            } else if ("true".equals(iparam)) {
                interactive = true;
            }
        }
        boolean use_compiler = true;
        boolean optimize = false;
        boolean debug_mode = false;
        boolean accessible = false;
        boolean publicAccess = false;
        boolean guiConsole = false;
        boolean sandbox = false;
        boolean verbose = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-help".equals(arg)) {
                Main.printHelp("pnuts");
                System.exit(0);
                continue;
            }
            if ("-version".equals(arg)) {
                System.err.println(Main.version());
                System.exit(0);
                continue;
            }
            if ("-vd".equals(arg)) {
                defaultSettings.setProperty(pnutsDebuggerProperty, "pnuts.tools.VisualDebugger");
                contextFactory = new VisualDebugger();
                use_compiler = false;
                debug_mode = true;
                continue;
            }
            if (arg.startsWith("-d")) {
                String pnutsContextFactory = Runtime.getProperty(pnutsDebuggerProperty);
                if (pnutsContextFactory != null) {
                    Class<?> cls = Class.forName(pnutsContextFactory);
                    contextFactory = (ContextFactory)cls.newInstance();
                } else if (arg.length() > 3 && arg.charAt(2) == ':') {
                    String debug_script = arg.substring(3);
                    System.out.println("reading " + debug_script);
                    FileReader reader = new FileReader(debug_script);
                    contextFactory = new TerminalDebugger(reader);
                } else {
                    contextFactory = new TerminalDebugger();
                }
                use_compiler = false;
                debug_mode = true;
                continue;
            }
            if ("-pure".equals(arg)) {
                use_compiler = false;
                continue;
            }
            if ("-O".equals(arg)) {
                optimize = true;
                continue;
            }
            if ("-a".equals(arg)) {
                accessible = true;
                continue;
            }
            if ("-b".equals(arg)) continue;
            if ("-p".equals(arg)) {
                publicAccess = true;
                continue;
            }
            if ("-v".equals(arg)) {
                verbose = true;
                continue;
            }
            if ("-w".equals(arg)) {
                guiConsole = true;
                continue;
            }
            if ("-s".equals(arg)) {
                sandbox = true;
                continue;
            }
            if ("-inputlog".equals(arg)) continue;
            if ("-a".equals(arg) || "-u".equals(arg) || "-U".equals(arg) || "-f".equals(arg) || "-F".equals(arg) || "-r".equals(arg) || "-R".equals(arg) || "-e".equals(arg) || "-m".equals(arg)) {
                ++i;
                continue;
            }
            if (!arg.startsWith("-J")) break;
        }
        if (use_compiler) {
            defaultSettings.setProperty("pnuts.lang.defaultPnutsImpl", "pnuts.compiler.CompilerPnutsImpl");
            if (!accessible && !"false".equals(System.getProperty("pnuts.compiler.useDynamicProxy"))) {
                defaultSettings.setProperty("pnuts.compiler.useDynamicProxy", "true");
            }
            if (optimize) {
                defaultSettings.setProperty("pnuts.compiler.optimize", "true");
            }
        } else {
            defaultSettings.setProperty("pnuts.lang.defaultPnutsImpl", "pnuts.lang.PnutsImpl");
        }
        if (verbose) {
            defaultSettings.setProperty("pnuts.verbose", "true");
        }
        Pnuts.setDefaults(defaultSettings);
        context = debug_mode ? contextFactory.createContext() : new Context();
        if (accessible) {
            context.setConfiguration(new NonPublicMemberAccessor());
        } else if (publicAccess) {
            context.setConfiguration(new PublicMemberAccessor());
        }
        if (sandbox && Pnuts.isJava2()) {
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new SecurityManager());
            }
            context.setImplementation(new SecurePnutsImpl(context.getImplementation()));
        }
        if ((module_property = Runtime.getProperty("pnuts.tools.modules")) != null) {
            StringTokenizer stoken = new StringTokenizer(module_property, ",");
            while (stoken.hasMoreTokens()) {
                context.usePackage(stoken.nextToken());
            }
        }
        for (int i = 0; i < args.length; ++i) {
            try {
                if ("-r".equals(args[i])) {
                    if (++i >= args.length) break;
                    Pnuts.load(args[i], (Context)context.clone());
                    continue;
                }
                if ("-R".equals(args[i])) {
                    if (++i >= args.length) break;
                    Pnuts.load(args[i], (Context)context.clone());
                    evaluated = true;
                    continue;
                }
                if ("-f".equals(args[i])) {
                    if (++i >= args.length) break;
                    Pnuts.loadFile(args[i], (Context)context.clone());
                    continue;
                }
                if ("-F".equals(args[i])) {
                    if (++i >= args.length) break;
                    Pnuts.loadFile(args[i], (Context)context.clone());
                    evaluated = true;
                    continue;
                }
                if ("-u".equals(args[i])) {
                    if (++i >= args.length) break;
                    Pnuts.load(new URL(args[i]), (Context)context.clone());
                    continue;
                }
                if ("-U".equals(args[i])) {
                    if (++i >= args.length) break;
                    Pnuts.load(new URL(args[i]), (Context)context.clone());
                    evaluated = true;
                    continue;
                }
                if ("-e".equals(args[i])) {
                    if (++i >= args.length) break;
                    Pnuts.eval(args[i], (Context)context.clone());
                    evaluated = true;
                    continue;
                }
                if ("-m".equals(args[i])) {
                    if (++i >= args.length) break;
                    context.usePackage(args[i]);
                    continue;
                }
                if ("-encoding".equals(args[i])) {
                    if (++i >= args.length) break;
                    context.setScriptEncoding(args[i]);
                    continue;
                }
                if ("-inputlog".equals(args[i])) {
                    if (++i >= args.length) break;
                    inputlog = args[i];
                    continue;
                }
                if (args[i].startsWith("-pure") || args[i].startsWith("-O") || args[i].startsWith("-a") || args[i].startsWith("-b") || args[i].startsWith("-p") || args[i].startsWith("-d") || args[i].startsWith("-vd") || "-v".equals(args[i]) || "-w".equals(args[i]) || "-s".equals(args[i])) continue;
                evaluated = true;
                String[] scriptArgs = new String[args.length - i];
                System.arraycopy(args, i, scriptArgs, 0, scriptArgs.length);
                context.getCurrentPackage().set("$args".intern(), scriptArgs);
                Pnuts.loadFile(args[i], (Context)context.clone());
                break;
            }
            catch (Throwable t) {
                Runtime.printError(t, context);
                return;
            }
        }
        if (!interactive && evaluated) {
            return;
        }
        if (quiet) {
            interactive = false;
        } else if (!interactive) {
            int av = 0;
            try {
                av = System.in.available();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (av < 1) {
                interactive = true;
            }
        }
        if (interactive) {
            if (guiConsole) {
                PnutsConsoleUI ui = new PnutsConsoleUI();
                ui.setTitle("Pnuts");
                PnutsConsole console2 = ui.createConsole(context, inputlog);
                console2.start();
                JFrame f = ui.getFrame();
                f.setDefaultCloseOperation(3);
                ((Component)f).setVisible(true);
                Reader in = console2.getReader();
                if (contextFactory instanceof TerminalDebugger) {
                    ((TerminalDebugger)contextFactory).setInput(new BufferedReader(in));
                }
            } else {
                InputStream in = Pnuts.isJava2() ? System.in : new TerminalInputStream(System.in);
                Main.greeting(context);
                Reader r = Runtime.getScriptReader(in, context);
                if (inputlog != null) {
                    try {
                        r = new LogReader(r, inputlog);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (contextFactory instanceof TerminalDebugger) {
                    ((TerminalDebugger)contextFactory).setInput(new BufferedReader(r));
                }
                Pnuts.load(r, true, context);
            }
        } else {
            try {
                Pnuts.load(System.in, false, context);
            }
            catch (Throwable t) {
                Runtime.printError(t, context);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

